/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.conditions;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.Ignore;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="5.7")
public class IgnoreCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@org.junit.Ignore is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        Optional ignoreAnnotation = AnnotationUtils.findAnnotation((Optional)element, Ignore.class);
        if (ignoreAnnotation.isPresent()) {
            String reason = ignoreAnnotation.map(Ignore::value).filter(StringUtils::isNotBlank).orElseGet(() -> element.get() + " is disabled via @org.junit.Ignore");
            return ConditionEvaluationResult.disabled((String)reason);
        }
        return ENABLED;
    }
}

