/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.stem.model.codegen.ModelGeneratorDescriptors;
import org.eclipse.stem.model.codegen.descriptor.ModelGeneratorDescriptor;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.CompartmentType;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelGenSettings;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.ModelParamConstraint;
import org.eclipse.stem.model.metamodel.ModelType;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.EcoreTransformSwitch;
import org.eclipse.stem.model.transform.GenModelTransformSwitch;
import org.eclipse.stem.model.transform.MetamodelResourceFactory;
import org.eclipse.stem.model.transform.ModelGenerator;

public class TransformerApplication
implements IApplication {
    ResourceSet resourceSet = new ResourceSetImpl();
    URI ecoreUri = URI.createPlatformResourceURI((String)"/testproject2/model/test1.ecore", (boolean)true);
    URI genmodelUri = URI.createPlatformResourceURI((String)"/testproject2/model/test1.genmodel", (boolean)true);
    URI ecoreProjectUri = URI.createPlatformResourceURI((String)"/testproject2", (boolean)true);
    Set<EPackage> containedEPackages = new HashSet<EPackage>();
    static final MetamodelFactory factory = MetamodelFactory.eINSTANCE;

    public TransformerApplication() {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("metamodel", new MetamodelResourceFactory());
        this.resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("stem", new MetamodelResourceFactory());
    }

    private Package loadModel(URI uri) {
        Resource modelResource = this.resourceSet.getResource(uri, true);
        for (Resource.Diagnostic d : modelResource.getErrors()) {
            System.err.println(d.getMessage());
        }
        return (Package)modelResource.getContents().get(0);
    }

    private EPackage loadEcore(URI uri) {
        Resource modelResource = this.resourceSet.getResource(uri, true);
        return (EPackage)modelResource.getContents().get(0);
    }

    private EClass getParentModel() throws Exception {
        final ArrayList ecores = new ArrayList();
        Job searchJob = new Job("asdf"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.getRoot().accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getName().endsWith(".ecore")) {
                                ecores.add(proxy.requestResource());
                            }
                            return !proxy.getName().startsWith(".");
                        }
                    }, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        searchJob.schedule();
        searchJob.join();
        ResourceSetImpl rs = new ResourceSetImpl();
        EClass cls = null;
        for (IResource ecore : ecores) {
            URI ecoreURI = URI.createPlatformResourceURI((String)ecore.getFullPath().toString(), (boolean)true);
            Resource r = rs.createResource(ecoreURI);
            r.load(null);
            EPackage pkg = (EPackage)r.getContents().get(0);
            cls = (EClass)pkg.getEClassifier("PolioOpvIpvDiseaseModel");
            if (cls != null) break;
        }
        return cls;
    }

    private void setupWorkspace() throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(".JETEmitters");
        project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        project.create((IProgressMonitor)new NullProgressMonitor());
        project.open(null);
        IResource[] iResourceArray = project.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            System.out.println(res);
            ++n2;
        }
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    public Object start(IApplicationContext arg0) throws Exception {
        this.setupWorkspace();
        List ds = ModelGeneratorDescriptors.getInstance().getDescriptors();
        for (ModelGeneratorDescriptor d : ds) {
            System.out.println(d);
        }
        String basePluginUri = "/org.eclipse.stem.diseasemodels/model/standard.metamodel";
        String extendedPluginUri = "/org.eclipse.stem.diseasemodels.swinesalmonella/model/swinesalmonella.metamodel";
        URI extendURI = URI.createPlatformPluginURI((String)extendedPluginUri, (boolean)true);
        URI.createPlatformPluginURI((String)basePluginUri, (boolean)true);
        Package extendPkg = this.loadModel(extendURI);
        EcoreUtil.resolveAll((EObject)extendPkg);
        ModelGenSettings settings = MetamodelFactory.eINSTANCE.createModelGenSettings();
        settings.setPropertyEditorParentClass("org.eclipse.stem.ui.wizards.StandardDiseaseModelPropertyEditor");
        ((Model)extendPkg.getModels().get(0)).setGeneratorSettings(settings);
        ModelGenerator generator = new ModelGenerator(extendPkg);
        generator.transform((IProgressMonitor)new NullProgressMonitor());
        generator.generate((IProgressMonitor)new NullProgressMonitor());
        return 0;
    }

    private GenModel loadGenModel(URI genModelUri, ResourceSet resourceSet) throws Exception {
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        Resource genModelResource = resourceSet.getResource(genModelUri, true);
        GenModel genModel = (GenModel)genModelResource.getContents().get(0);
        return genModel;
    }

    private EPackage loadEcore(URI ecoreUri, ResourceSet resourceSet) throws Exception {
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        Resource ecoreResource = resourceSet.getResource(ecoreUri, true);
        EPackage ep = (EPackage)ecoreResource.getContents().get(0);
        return ep;
    }

    private boolean shouldIncludeGenModel(GenModel gm) {
        return !gm.getModelName().equals("GenModel");
    }

    private void addReferencedPackagesToGenModel(GenModel gm) {
        for (EPackage pkgRef : this.containedEPackages) {
            URI packageGenmodelUri = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(pkgRef.getNsURI());
            if (packageGenmodelUri == null) continue;
            try {
                GenModel gmToInclude = this.loadGenModel(packageGenmodelUri, this.resourceSet);
                if (!this.shouldIncludeGenModel(gmToInclude)) continue;
                ImporterUtil.addUniqueGenPackages((List)gm.getUsedGenPackages(), (List)gmToInclude.getGenPackages());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void prepareWorkspace() throws Exception {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsr = ws.getRoot();
        IProject modelProject = wsr.getProject("org.eclipse.stem.diseasemodels.testmodel");
        IProject codegenProject = wsr.getProject(".JETEmitters");
        IProject testProject = wsr.getProject("testproject2");
        try {
            modelProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            codegenProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            testProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        ws.getDescription().setAutoBuilding(false);
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void generate(GenModel gm) throws Exception {
        if (gm == null) {
            gm = this.loadGenModel(this.genmodelUri, this.resourceSet);
        }
        System.out.println("Got GenModel: " + gm);
        Generator g = GenModelUtil.createGenerator((GenModel)gm);
        gm.setCanGenerate(true);
        g.setInput((Object)gm);
        g.generate((Object)gm, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", "model project", BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        g.generate((Object)gm, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", "edit project", BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        g.generate((Object)gm, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", "editor project", BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
    }

    private GenModel createGenModel(EPackage ePkg) {
        return new GenModelTransformSwitch().transform(ePkg);
    }

    private void resolveCrossReferences(EObject eObject) {
        if (eObject == null) {
            return;
        }
        if (eObject instanceof EPackage) {
            this.containedEPackages.add((EPackage)eObject);
            this.resolveCrossReferences((EObject)((EPackage)eObject).getESuperPackage());
        }
        for (EObject obj : eObject.eCrossReferences()) {
            if (!(obj.eContainer() instanceof EPackage)) continue;
            this.resolveCrossReferences(obj.eContainer());
        }
    }

    private void resolveReferencedEPackages(EPackage ePkg) {
        ePkg.eContainer();
        this.resolveCrossReferences((EObject)ePkg);
        TreeIterator i = ePkg.eAllContents();
        while (i.hasNext()) {
            EObject childEObject = (EObject)i.next();
            this.resolveCrossReferences(childEObject);
        }
    }

    private EPackage createEPackage(Package modelPackage) {
        EcoreTransformSwitch transformer = new EcoreTransformSwitch();
        return (EPackage)transformer.doSwitch((EObject)modelPackage);
    }

    public void print(EObject m) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Resource poResource = this.resourceSet.createResource(this.genmodelUri);
        poResource.getContents().add((Object)m);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        poResource.save((OutputStream)baos, options);
        System.out.println(baos.toString());
    }

    public URI save(GenModel m, ResourceSet resourceSet) throws Exception {
        Resource poResource = resourceSet.createResource(this.genmodelUri);
        poResource.getContents().add((Object)m);
        poResource.save(null);
        return this.ecoreUri;
    }

    public URI save(EPackage m, ResourceSet resourceSet) throws Exception {
        Resource poResource = resourceSet.createResource(this.ecoreUri);
        poResource.getContents().add((Object)m);
        poResource.save(null);
        return this.ecoreUri;
    }

    public void save(Package m, URI uri) throws Exception {
        Resource poResource = this.resourceSet.createResource(uri);
        poResource.getContents().add((Object)m);
        poResource.save(null);
    }

    private void createProject() throws Exception {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("testproject");
        project.create((IProgressMonitor)progressMonitor);
        project.open((IProgressMonitor)progressMonitor);
    }

    private Model getModelForName(String name, Package basePackage) {
        for (Model m : basePackage.getModels()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    private Package createExtendedModel(Package basePackage) throws Exception {
        Model sirDM = this.getModelForName("SIR", basePackage);
        Package pkg = MetamodelFactory.eINSTANCE.createPackage();
        pkg.setName("Extended");
        pkg.setPackagePrefix("org.eclipse.stem.diseasemodels");
        Model extendedSIRDM = MetamodelFactory.eINSTANCE.createModel();
        extendedSIRDM.setName("ExtendedSIR");
        extendedSIRDM.setParentModel(sirDM);
        extendedSIRDM.setModelType(ModelType.DISEASE_MODEL);
        extendedSIRDM.setClass(null);
        CompartmentGroup extendedSIRCG = MetamodelFactory.eINSTANCE.createCompartmentGroup();
        extendedSIRCG.setName("ExtendedSIRLabel");
        extendedSIRCG.setParentGroup(sirDM.getCompartments());
        Compartment s2 = MetamodelFactory.eINSTANCE.createCompartment();
        s2.setDataType(EcorePackage.Literals.EDOUBLE);
        s2.setName("s2");
        Compartment i2 = MetamodelFactory.eINSTANCE.createCompartment();
        i2.setDataType(EcorePackage.Literals.EDOUBLE);
        i2.setName("i2");
        Compartment r2 = MetamodelFactory.eINSTANCE.createCompartment();
        r2.setDataType(EcorePackage.Literals.EDOUBLE);
        r2.setName("r2");
        extendedSIRCG.getCompartments().add((Object)s2);
        extendedSIRCG.getCompartments().add((Object)i2);
        extendedSIRCG.getCompartments().add((Object)r2);
        extendedSIRDM.setCompartments(extendedSIRCG);
        pkg.getModels().add((Object)extendedSIRDM);
        Model extendedAgainSIRDM = MetamodelFactory.eINSTANCE.createModel();
        extendedAgainSIRDM.setName("ExtendedAgainSIR");
        extendedAgainSIRDM.setParentModel(extendedSIRDM);
        extendedAgainSIRDM.setModelType(ModelType.DISEASE_MODEL);
        extendedAgainSIRDM.setClass(null);
        CompartmentGroup extendedAgainSIRCG = MetamodelFactory.eINSTANCE.createCompartmentGroup();
        extendedAgainSIRCG.setName("ExtendedAgainSIRLabel");
        extendedAgainSIRCG.setParentGroup(extendedSIRCG);
        Compartment s3 = MetamodelFactory.eINSTANCE.createCompartment();
        s3.setDataType(EcorePackage.Literals.EDOUBLE);
        s3.setName("s3");
        Compartment i3 = MetamodelFactory.eINSTANCE.createCompartment();
        i3.setDataType(EcorePackage.Literals.EDOUBLE);
        i3.setName("i3");
        Compartment r3 = MetamodelFactory.eINSTANCE.createCompartment();
        r3.setDataType(EcorePackage.Literals.EDOUBLE);
        r3.setName("r3");
        extendedAgainSIRCG.getCompartments().add((Object)s3);
        extendedAgainSIRCG.getCompartments().add((Object)i3);
        extendedAgainSIRCG.getCompartments().add((Object)r3);
        extendedAgainSIRDM.setCompartments(extendedAgainSIRCG);
        pkg.getModels().add((Object)extendedAgainSIRDM);
        return pkg;
    }

    private Package createBaseModel() throws Exception {
        EPackage ePackage = this.loadEcore(URI.createPlatformPluginURI((String)"/org.eclipse.stem.diseasemodels/model/standard.ecore", (boolean)true));
        EcoreUtil.resolveAll((EObject)ePackage);
        ePackage.getEClassifier("StandardDiseaseModel");
        Package pkg = MetamodelFactory.eINSTANCE.createPackage();
        pkg.setName("DiseaseModels");
        pkg.setPackagePrefix("org.eclipse.stem");
        Model stdDM = MetamodelFactory.eINSTANCE.createModel();
        stdDM.setName("StandardDiseaseModel");
        stdDM.setParentModel(null);
        stdDM.setModelType(ModelType.DISEASE_MODEL);
        stdDM.setClass((EClass)ePackage.getEClassifier("StandardDiseaseModel"));
        CompartmentGroup stdCG = MetamodelFactory.eINSTANCE.createCompartmentGroup();
        stdCG.setName("StandardDiseaseModelLabel");
        stdCG.setClass((EClass)ePackage.getEClassifier("StandardDiseaseModelLabel"));
        stdCG.setValueClass((EClass)ePackage.getEClassifier("StandardDiseaseModelLabelValue"));
        Compartment s = MetamodelFactory.eINSTANCE.createCompartment();
        s.setDataType(EcorePackage.Literals.EDOUBLE);
        s.setName("s");
        stdCG.getCompartments().add((Object)s);
        stdDM.setCompartments(stdCG);
        pkg.getModels().add((Object)stdDM);
        Model siDM = MetamodelFactory.eINSTANCE.createModel();
        siDM.setName("SI");
        siDM.setParentModel(stdDM);
        siDM.setModelType(ModelType.DISEASE_MODEL);
        siDM.setClass((EClass)ePackage.getEClassifier("SI"));
        CompartmentGroup siCG = MetamodelFactory.eINSTANCE.createCompartmentGroup();
        siCG.setName("SILabel");
        siCG.setClass((EClass)ePackage.getEClassifier("SILabel"));
        siCG.setValueClass((EClass)ePackage.getEClassifier("SILabelValue"));
        siCG.setParentGroup(stdCG);
        Compartment i = MetamodelFactory.eINSTANCE.createCompartment();
        i.setDataType(EcorePackage.Literals.EDOUBLE);
        i.setName("i");
        siCG.getCompartments().add((Object)i);
        siDM.setCompartments(siCG);
        pkg.getModels().add((Object)siDM);
        Model sirDM = MetamodelFactory.eINSTANCE.createModel();
        sirDM.setName("SIR");
        sirDM.setParentModel(siDM);
        sirDM.setModelType(ModelType.DISEASE_MODEL);
        sirDM.setClass((EClass)ePackage.getEClassifier("SIR"));
        CompartmentGroup sirCG = MetamodelFactory.eINSTANCE.createCompartmentGroup();
        sirCG.setName("SIRLabel");
        sirCG.setParentGroup(siCG);
        sirCG.setClass((EClass)ePackage.getEClassifier("SIRLabel"));
        sirCG.setValueClass((EClass)ePackage.getEClassifier("SIRLabelValue"));
        Compartment r = MetamodelFactory.eINSTANCE.createCompartment();
        r.setDataType(EcorePackage.Literals.EDOUBLE);
        r.setName("r");
        sirCG.getCompartments().add((Object)r);
        sirDM.setCompartments(sirCG);
        pkg.getModels().add((Object)sirDM);
        Model seirDM = MetamodelFactory.eINSTANCE.createModel();
        seirDM.setName("SEIR");
        seirDM.setParentModel(sirDM);
        seirDM.setModelType(ModelType.DISEASE_MODEL);
        seirDM.setClass((EClass)ePackage.getEClassifier("SEIR"));
        CompartmentGroup seirCG = MetamodelFactory.eINSTANCE.createCompartmentGroup();
        seirCG.setName("SEIRLabel");
        seirCG.setParentGroup(sirCG);
        seirCG.setClass((EClass)ePackage.getEClassifier("SEIRLabel"));
        seirCG.setValueClass((EClass)ePackage.getEClassifier("SEIRLabelValue"));
        Compartment e = MetamodelFactory.eINSTANCE.createCompartment();
        e.setDataType(EcorePackage.Literals.EDOUBLE);
        e.setName("e");
        seirCG.getCompartments().add((Object)e);
        seirDM.setCompartments(seirCG);
        pkg.getModels().add((Object)seirDM);
        return pkg;
    }

    public Package createOPVModel(Model parent) {
        Package polioPackage = factory.createPackage();
        polioPackage.setName("PolioOpvIpv");
        polioPackage.setPackagePrefix("org.eclipse.stem.diseasemodels");
        Model polioOPVDiseaseModel = factory.createModel();
        polioOPVDiseaseModel.setParentModel(parent);
        polioOPVDiseaseModel.setName("PolioOpvIpvDiseaseModel");
        polioOPVDiseaseModel.setModelType(ModelType.DISEASE_MODEL);
        this.setupOPVParameters(polioOPVDiseaseModel);
        this.setupOPVLabel(polioOPVDiseaseModel);
        polioPackage.getModels().add((Object)polioOPVDiseaseModel);
        return polioPackage;
    }

    private void setupOPVParameters(Model model) {
        ModelParam a = factory.createModelParam();
        a.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        a.setName("opvEfficacy");
        a.setDefaultValue("0.9");
        a.setDisplayName("Efficacy of live-attenuated vaccine (a)");
        this.addZeroOneConstraint(a);
        model.getParameters().add((Object)a);
        ModelParam phi = factory.createModelParam();
        phi.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        phi.setName("reversionRateOPV");
        phi.setDefaultValue("10e-4");
        phi.setDisplayName("OPV Reversion Rate (\u03c6)");
        this.addZeroOneConstraint(phi);
        model.getParameters().add((Object)phi);
        ModelParam mu2 = factory.createModelParam();
        mu2.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        mu2.setName("birthDeathRateDeveloping");
        mu2.setDefaultValue("0.04");
        mu2.setDisplayName("Birth-Death Rate - Developing Countries (\u03bc)");
        this.addZeroOneConstraint(mu2);
        model.getParameters().add((Object)mu2);
        ModelParam betaOPV = factory.createModelParam();
        betaOPV.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        betaOPV.setName("transmissionRateOPV");
        betaOPV.setDefaultValue("0.1");
        betaOPV.setDisplayName("Transmission Rate - OPV Derived Virus (\u03b2opv)");
        this.addZeroOneConstraint(betaOPV);
        model.getParameters().add((Object)betaOPV);
        ModelParam betaW = factory.createModelParam();
        betaW.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        betaW.setName("transmissionRateWild");
        betaW.setDefaultValue("0.5");
        betaW.setDisplayName("Transmission Rate - Wild Virus (\u03b2w)");
        this.addZeroOneConstraint(betaW);
        model.getParameters().add((Object)betaW);
        ModelParam fr = factory.createModelParam();
        fr.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        fr.setName("relativeSusceptibilityRecentOPV");
        fr.setDefaultValue("0.25");
        fr.setDisplayName("Relative Susceptibility - Recent OPV Infection (fr)");
        this.addZeroOneConstraint(fr);
        model.getParameters().add((Object)fr);
        ModelParam fi = factory.createModelParam();
        fi.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        fi.setName("relativeSusceptibilityIPV");
        fi.setDefaultValue("0.95");
        fi.setDisplayName("Relative Susceptibility - IPV Only (fi)");
        this.addZeroOneConstraint(fi);
        model.getParameters().add((Object)fi);
        ModelParam sigmaV = factory.createModelParam();
        sigmaV.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        sigmaV.setName("incubationRateVaccine");
        sigmaV.setDefaultValue("0.1");
        sigmaV.setDisplayName("Incubation Rate - Vaccine (\u03c3v)");
        sigmaV.setHelpMessage("Incubation rate of vaccine-derived poliovirus");
        this.addZeroOneConstraint(sigmaV);
        model.getParameters().add((Object)sigmaV);
        ModelParam sigmaW = factory.createModelParam();
        sigmaW.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        sigmaW.setName("incubationRateWild");
        sigmaW.setDefaultValue("0.5");
        sigmaW.setDisplayName("Incubation Rate - Wild (\u03c3w)");
        sigmaW.setHelpMessage("Incubation rate of wild poliovirus");
        this.addZeroOneConstraint(sigmaW);
        model.getParameters().add((Object)sigmaW);
        ModelParam gammaV = factory.createModelParam();
        gammaV.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        gammaV.setName("recoveryRateVaccine");
        gammaV.setDefaultValue("0.143");
        gammaV.setDisplayName("Recovery Rate - Vaccine (\u03b3v)");
        gammaV.setHelpMessage("Recovery Rate of vaccine-derived poliovirus");
        this.addZeroOneConstraint(gammaV);
        model.getParameters().add((Object)gammaV);
        ModelParam gammaW = factory.createModelParam();
        gammaW.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        gammaW.setName("recoveryRateWild");
        gammaW.setDefaultValue("0.625");
        gammaW.setDisplayName("Recovery Rate - Wild (\u03b3w)");
        gammaW.setHelpMessage("Recovery Rate of wild poliovirus");
        this.addZeroOneConstraint(gammaW);
        model.getParameters().add((Object)gammaW);
        ModelParam epsilon = factory.createModelParam();
        epsilon.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        epsilon.setName("paralyticIncidenceFromVaccine");
        epsilon.setDefaultValue("7.14e-7");
        epsilon.setDisplayName("Paralytic Incidences in Newly Vaccinated (\u03b5)");
        this.addZeroOneConstraint(epsilon);
        model.getParameters().add((Object)epsilon);
        ModelParam pipara = factory.createModelParam();
        pipara.setDataType((EClassifier)EcorePackage.Literals.EDOUBLE);
        pipara.setName("paralyticCaseProportion");
        pipara.setDefaultValue("0.005");
        pipara.setDisplayName("Proportion of Paralytic Polio cases (\u03c0para)");
        this.addZeroOneConstraint(pipara);
        model.getParameters().add((Object)pipara);
    }

    private void addMinMaxValueConstraint(ModelParam param, double minValue, double maxValue) {
        ModelParamConstraint min = factory.createModelParamConstraint();
        min.setConstraint(String.valueOf(minValue));
        min.setName("minValue");
        ModelParamConstraint max = factory.createModelParamConstraint();
        max.setConstraint(String.valueOf(maxValue));
        max.setName("maxValue");
        param.getConstraints().add((Object)min);
        param.getConstraints().add((Object)max);
    }

    private void addZeroOneConstraint(ModelParam param) {
        this.addMinMaxValueConstraint(param, 0.0, 1.0);
    }

    private void setupOPVLabel(Model model) {
        CompartmentGroup polioOPVLabel = factory.createCompartmentGroup();
        polioOPVLabel.setParentGroup(model.getParentModel().getCompartments());
        polioOPVLabel.setName("PolioOpvIpv");
        Compartment Sopv = factory.createCompartment();
        Sopv.setDataType(EcorePackage.Literals.EDOUBLE);
        Sopv.setName("Sopv");
        Compartment Eopv = factory.createCompartment();
        Eopv.setDataType(EcorePackage.Literals.EDOUBLE);
        Eopv.setName("Eopv");
        Compartment Vopv = factory.createCompartment();
        Vopv.setDataType(EcorePackage.Literals.EDOUBLE);
        Vopv.setName("Vopv");
        Compartment Popv = factory.createCompartment();
        Popv.setDataType(EcorePackage.Literals.EDOUBLE);
        Popv.setName("Popv");
        Compartment Pw = factory.createCompartment();
        Pw.setDataType(EcorePackage.Literals.EDOUBLE);
        Pw.setName("Pw");
        Compartment Sipv = factory.createCompartment();
        Sipv.setDataType(EcorePackage.Literals.EDOUBLE);
        Sipv.setName("Sipv");
        Compartment Eipv_w = factory.createCompartment();
        Eipv_w.setDataType(EcorePackage.Literals.EDOUBLE);
        Eipv_w.setName("Eipv_w");
        Compartment Cipv_w = factory.createCompartment();
        Cipv_w.setDataType(EcorePackage.Literals.EDOUBLE);
        Cipv_w.setName("Cipv_w");
        Compartment Eipv_opv = factory.createCompartment();
        Eipv_opv.setDataType(EcorePackage.Literals.EDOUBLE);
        Eipv_opv.setName("Eipv_opv");
        Compartment Cipv_opv = factory.createCompartment();
        Cipv_opv.setDataType(EcorePackage.Literals.EDOUBLE);
        Cipv_opv.setName("Cipv_opv");
        polioOPVLabel.getCompartments().add((Object)Sopv);
        polioOPVLabel.getCompartments().add((Object)Eopv);
        polioOPVLabel.getCompartments().add((Object)Vopv);
        polioOPVLabel.getCompartments().add((Object)Popv);
        polioOPVLabel.getCompartments().add((Object)Pw);
        polioOPVLabel.getCompartments().add((Object)Sipv);
        polioOPVLabel.getCompartments().add((Object)Eipv_w);
        polioOPVLabel.getCompartments().add((Object)Cipv_w);
        polioOPVLabel.getCompartments().add((Object)Eipv_opv);
        polioOPVLabel.getCompartments().add((Object)Cipv_opv);
        Compartment Incidence_opv = factory.createCompartment();
        Incidence_opv.setDataType(EcorePackage.Literals.EDOUBLE);
        Incidence_opv.setType(CompartmentType.INCIDENCE);
        Incidence_opv.setName("Incidence_opv");
        Compartment Incidence_ipvw = factory.createCompartment();
        Incidence_ipvw.setDataType(EcorePackage.Literals.EDOUBLE);
        Incidence_ipvw.setType(CompartmentType.INCIDENCE);
        Incidence_ipvw.setName("Incidence_ipv_w");
        Compartment Incidence_ipv_opv = factory.createCompartment();
        Incidence_ipv_opv.setDataType(EcorePackage.Literals.EDOUBLE);
        Incidence_ipv_opv.setType(CompartmentType.INCIDENCE);
        Incidence_ipv_opv.setName("Incidence_ipv_opv");
        polioOPVLabel.getCompartments().add((Object)Incidence_opv);
        polioOPVLabel.getCompartments().add((Object)Incidence_ipvw);
        polioOPVLabel.getCompartments().add((Object)Incidence_ipv_opv);
        model.setCompartments(polioOPVLabel);
    }

    public void stop() {
    }
}

