/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.servlet.SlideShowServlet;

public class ImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String text = "DEFAULT";
    private int textsize = 14;
    private String fc = "#ffffff";
    private String bc = "#000000";
    private int h = 32;
    int w = 0;
    private String fontName = "Sans-serif";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            if (name.equals("text")) {
                this.text = value;
                continue;
            }
            if (name.equals("w")) {
                this.w = Integer.parseInt(value);
                continue;
            }
            if (name.equals("h")) {
                this.h = Integer.parseInt(value);
                continue;
            }
            if (name.equals("bc")) {
                this.bc = value;
                continue;
            }
            if (!name.equals("fc")) continue;
            this.fc = value;
        }
        BufferedImage image = this.getImage();
        if (image == null) {
            this.errHtml(response, "Unable to create image.");
        }
        response.setContentType("image/png");
        ServletOutputStream outputStream = response.getOutputStream();
        ImageIO.write((RenderedImage)image, "png", (OutputStream)outputStream);
        outputStream.close();
    }

    public BufferedImage getImage() {
        BufferedImage image = null;
        Font font = new Font(this.fontName, 1, this.textsize);
        if (this.w == 0) {
            this.w = (this.text.length() + 2) * 8;
        }
        int textColor = 0;
        int imageColor = 0;
        try {
            if (this.fc.startsWith("#")) {
                this.fc = this.fc.substring(1);
            }
            textColor = (int)(Long.parseLong(this.fc, 16) & 0xFFFFFFFL);
            if (this.bc.startsWith("#")) {
                this.bc = this.bc.substring(1);
            }
            imageColor = (int)(Long.parseLong(this.bc, 16) & 0xFFFFFFFL);
        }
        catch (Exception excep) {
            this.debug("textColor=" + textColor);
            this.debug("imageColor=" + imageColor);
            this.debug("Invalid text or image color.", excep);
            return null;
        }
        try {
            image = new BufferedImage(this.w, this.h, 1);
            int i = 0;
            while (i < this.w) {
                int j = 0;
                while (j < this.h) {
                    image.setRGB(i, j, imageColor);
                    ++j;
                }
                ++i;
            }
            Graphics2D g = image.createGraphics();
            Color c = new Color(textColor, (textColor >> 24 & 0xFF) != 0);
            g.setColor(c);
            g.setFont(font);
            g.drawString(this.text, this.textsize / 2, this.textsize * 5 / 4);
            g.dispose();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
        return image;
    }

    private void errHtml(HttpServletResponse response, String msg) throws IOException {
        response.setContentType("text/html");
        PrintWriter out = new PrintWriter((OutputStream)response.getOutputStream());
        out.println("<html>");
        out.println("<head><title>KML SlideShow Error</title></head>");
        out.println("<body>");
        out.println("<p>" + msg + "</p>");
        out.println("</body></html>");
        out.flush();
    }

    private void debug(String msg) {
        if (SlideShowServlet.DEBUG) {
            Activator.logInformation((String)("ImageServlet: " + msg));
        }
    }

    private void debug(String msg, Throwable e) {
        Activator.logInformation((String)msg);
        e.printStackTrace();
    }
}

