/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeMapDataImpl
implements IVisualizeMapData {
    private Map<Node, Node> orig2resultMap = new HashMap<Node, Node>(1024);
    private Map<Node, Node> result2origMap = new HashMap<Node, Node>(1024);
    private Map<Node, Integer> orig2idMap = new HashMap<Node, Integer>(1024);
    private Map<Node, Integer> result2idMap = new HashMap<Node, Integer>(1024);
    private Map<Integer, Integer> accId2id = new HashMap<Integer, Integer>(1024);
    private Map<Integer, Integer> id2accId = new HashMap<Integer, Integer>(1024);
    private Map<Node, VisualizationNodeInfo> node2infoMap = new HashMap<Node, VisualizationNodeInfo>(1024);
    private Map<Node, Node> removedNodeMap = new HashMap<Node, Node>(512);
    private Map<Node, Node> intraPageLinkMap = new HashMap<Node, Node>(256);
    private List<VisualizationNodeInfo> nodeInfoList = new ArrayList<VisualizationNodeInfo>(1024);

    protected Map<Node, Node> getOrig2ResultMap() {
        return this.orig2resultMap;
    }

    protected Map<Integer, Integer> getAccId2IdMap() {
        return this.accId2id;
    }

    public Map<Integer, Integer> getId2AccIdMap() {
        return this.id2accId;
    }

    @Override
    public Map<Node, Integer> getOrig2idMap() {
        return this.orig2idMap;
    }

    public Map<Node, Integer> getResult2idMap() {
        return this.result2idMap;
    }

    protected Map<Node, Node> getIntraPageLinkMap() {
        return this.intraPageLinkMap;
    }

    public List<VisualizationNodeInfo> getNodeInfoList() {
        return this.nodeInfoList;
    }

    protected Map<Node, VisualizationNodeInfo> getNode2infoMap() {
        return this.node2infoMap;
    }

    protected void addOrigResultMapping(Node node, Node node2) {
        this.orig2resultMap.put(node, node2);
        this.result2origMap.put(node2, node);
    }

    public void addOrigIdAccIdMapping(Integer n, Integer n2) {
        this.accId2id.put(n2, n);
        this.id2accId.put(n, n2);
    }

    @Override
    public void addReplacedNodeMapping(Node node, Node node2) {
        this.removedNodeMap.put(node, node2);
    }

    protected void addNodeIdMapping(Node node, Integer n) {
        this.result2idMap.put(node, n);
        this.orig2idMap.put(this.getOrigNode(node), n);
    }

    protected void addNodeInfoMapping(Node node, VisualizationNodeInfo visualizationNodeInfo) {
        this.node2infoMap.put(node, visualizationNodeInfo);
    }

    protected void addNodeInfoIntoList(VisualizationNodeInfo visualizationNodeInfo) {
        this.nodeInfoList.add(visualizationNodeInfo);
    }

    protected void addIntraPageLinkMapping(Node node, Node node2) {
        this.intraPageLinkMap.put(node, node2);
    }

    @Override
    public Node getOrigNode(Node node) {
        return this.result2origMap.get(node);
    }

    @Override
    public Node getResultNode(Node node) {
        return this.orig2resultMap.get(node);
    }

    @Override
    public Node getReplacement(Node node) {
        return this.removedNodeMap.get(node);
    }

    @Override
    public Integer getIdOfNode(Node node) {
        return this.result2idMap.get(node);
    }

    @Override
    public Integer getIdOfOrigNode(Node node) {
        return this.orig2idMap.get(node);
    }

    public VisualizationNodeInfo getNodeInfo(Node node) {
        return this.node2infoMap.get(node);
    }

    public void makeIdMapping(String string) {
        Set<Node> set = this.getResult2idMap().keySet();
        for (Node node : set) {
            if (node.getNodeType() != 1) continue;
            Integer n = this.getIdOfNode(node);
            Element element = (Element)node;
            element.setAttribute("id", "id" + n.toString());
            if (element.hasAttribute(string)) {
                try {
                    Integer n2 = new Integer(element.getAttribute(string));
                    this.addOrigIdAccIdMapping(n, n2);
                }
                catch (Exception exception) {}
            }
            DocumentCleaner.removeOnMouse((Element)node);
        }
    }
}

