/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ie;

import org.eclipse.actf.model.internal.ui.editors.ie.BrowserIE_Plugin;
import org.eclipse.actf.model.ui.editor.actions.GoBackAction;
import org.eclipse.actf.model.ui.editor.actions.GoForwardAction;
import org.eclipse.actf.model.ui.editor.actions.RefreshAction;
import org.eclipse.actf.model.ui.editor.actions.StopAction;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.WebBrowserEventUtil;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class WebBrowserToolbar
extends Composite {
    private Text _addressText;
    private boolean _isFocusOnText;
    private IWebBrowserACTF browser;

    public WebBrowserToolbar(IWebBrowserACTF iWebBrowserACTF, Composite composite, int n) {
        super(composite, n);
        this.browser = iWebBrowserACTF;
        this.setLayoutData(new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 1;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        this.initLayout();
    }

    private void initLayout() {
        ToolBar toolBar = new ToolBar((Composite)this, 16384);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        toolBarManager.add((IAction)new GoBackAction());
        toolBarManager.add((IAction)new GoForwardAction());
        toolBarManager.add((IAction)new StopAction());
        toolBarManager.add((IAction)new RefreshAction());
        toolBarManager.update(true);
        this._addressText = new Text((Composite)this, 2052);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this._addressText.setLayoutData((Object)gridData);
        this._addressText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                WebBrowserToolbar.this._isFocusOnText = false;
                if (WebBrowserToolbar.this.browser != null) {
                    WebBrowserEventUtil.focusLostOfAddressText((IWebBrowserACTF)WebBrowserToolbar.this.browser);
                }
            }

            public void focusGained(FocusEvent focusEvent) {
                WebBrowserToolbar.this._addressText.selectAll();
                if (WebBrowserToolbar.this.browser != null) {
                    WebBrowserEventUtil.focusGainedOfAddressText((IWebBrowserACTF)WebBrowserToolbar.this.browser);
                }
            }
        });
        this._addressText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.stateMask == 65536 && (traverseEvent.character == 'd' || traverseEvent.character == 'D')) {
                    WebBrowserToolbar.this._addressText.setFocus();
                    WebBrowserToolbar.this._addressText.selectAll();
                }
            }
        });
        this._addressText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (!WebBrowserToolbar.this._isFocusOnText) {
                    WebBrowserToolbar.this._addressText.selectAll();
                    WebBrowserToolbar.this._isFocusOnText = true;
                }
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                WebBrowserToolbar.this._addressText.selectAll();
            }
        });
        this._addressText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r' && WebBrowserToolbar.this.browser != null) {
                    WebBrowserToolbar.this.browser.open(WebBrowserToolbar.this._addressText.getText());
                    WebBrowserToolbar.this.forceFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        ToolBar toolBar2 = new ToolBar((Composite)this, 131072);
        ToolBarManager toolBarManager2 = new ToolBarManager(toolBar2);
        Action action = new Action(ModelServiceMessages.WebBrowser_Go, BrowserIE_Plugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.model.ui", (String)"icons/browser/go.png")){

            public void run() {
                if (WebBrowserToolbar.this.browser != null && WebBrowserToolbar.this._addressText != null) {
                    WebBrowserToolbar.this.browser.open(WebBrowserToolbar.this._addressText.getText());
                }
            }
        };
        action.setToolTipText(ModelServiceMessages.WebBrowser_Go_tp);
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
        actionContributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        toolBarManager2.add((IContributionItem)actionContributionItem);
        toolBarManager2.update(true);
    }

    public String getAddressTextString() {
        return this._addressText.getText();
    }

    public void setAddressTextString(String string) {
        this._addressText.setText(string);
    }

    public void setFocusToAddressText(boolean bl) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this._addressText.setFocus();
        if (bl) {
            this._addressText.selectAll();
        } else {
            this._addressText.setSelection(0);
        }
    }

    public void showAddressText(boolean bl) {
        this.setVisible(bl);
    }
}

