/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class GraphCanvas
extends Canvas {
    protected Color axisColor;
    private int xpad = 10;
    private int ypad = 10;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private Rectangle globalArea = new Rectangle(0, 0, 0, 0);
    private Rectangle localArea = new Rectangle(0, 0, 0, 0);
    private boolean autoScroll = true;
    private double scale = 1.0;

    public GraphCanvas(Composite parent, int style) {
        super(parent, style | 0x200 | 0x100);
        this.axisColor = parent.getDisplay().getSystemColor(15);
        this.hBar = this.getHorizontalBar();
        this.vBar = this.getVerticalBar();
        this.hBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (GraphCanvas.this.hBar.getSelection() + GraphCanvas.this.hBar.getThumb() == GraphCanvas.this.hBar.getMaximum()) {
                    GraphCanvas.this.autoScroll = true;
                } else {
                    GraphCanvas.this.autoScroll = false;
                }
                GraphCanvas.this.setLocalArea(new Rectangle(GraphCanvas.this.hBar.getSelection(), ((GraphCanvas)GraphCanvas.this).localArea.y, ((GraphCanvas)GraphCanvas.this).localArea.width, ((GraphCanvas)GraphCanvas.this).localArea.height), true);
                GraphCanvas.this.redraw();
            }
        });
        this.vBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GraphCanvas.this.autoScroll = false;
                GraphCanvas.this.setLocalArea(new Rectangle(((GraphCanvas)GraphCanvas.this).localArea.x, GraphCanvas.this.vBar.getMaximum() - (GraphCanvas.this.vBar.getSelection() + GraphCanvas.this.vBar.getThumb()) + GraphCanvas.this.vBar.getMinimum(), ((GraphCanvas)GraphCanvas.this).localArea.width, ((GraphCanvas)GraphCanvas.this).localArea.height), true);
                GraphCanvas.this.redraw();
            }
        });
    }

    public void setPadding(int xpad, int ypad) {
        this.setXPadding(xpad);
        this.setYPadding(ypad);
    }

    public void setXPadding(int xpad) {
        this.xpad = xpad > 0 ? xpad : this.xpad;
    }

    public void setYPadding(int ypad) {
        this.ypad = ypad > 0 ? ypad : this.ypad;
    }

    public int getXPadding() {
        return this.xpad;
    }

    public int getYPadding() {
        return this.ypad;
    }

    public synchronized void repaint() {
        this.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    GraphCanvas.this.redraw();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    public Point getSize() {
        Point p = new Point(super.getSize().x, super.getSize().y);
        p.x -= this.vBar.getSize().x + 5;
        p.y -= this.hBar.getSize().y + 5;
        return p;
    }

    public Point getTrueSize() {
        return super.getSize();
    }

    public void setScale(double s) {
        this.scale = s;
        this.setLocalArea(this.localArea, true);
        this.redraw();
    }

    public void setGlobalArea(Rectangle area) {
        this.globalArea = area;
        this.hBar.setMinimum(this.getGlobalXMin());
        this.hBar.setMaximum(this.getGlobalXMax());
        this.vBar.setMinimum(this.getGlobalYMin());
        this.vBar.setMaximum(this.getGlobalYMax());
    }

    public void setLocalArea(Rectangle area) {
        this.setLocalArea(area, false);
    }

    public void setLocalArea(Rectangle area, boolean force) {
        if (this.autoScroll || force) {
            this.localArea = area;
            this.hBar.setThumb(this.getLocalWidth());
            this.vBar.setThumb(this.getLocalHeight());
            this.hBar.setIncrement(this.getLocalWidth() >> 3);
            this.hBar.setPageIncrement(this.getLocalWidth());
            this.vBar.setIncrement(this.getLocalHeight() >> 3);
            this.vBar.setPageIncrement(this.getLocalHeight());
        }
        if (this.autoScroll) {
            this.hBar.setSelection(this.hBar.getMaximum());
            this.vBar.setSelection(this.getGlobalYMax() - Math.min(this.getLocalYMax(), this.getGlobalYMax()) + this.getGlobalYMin());
        }
    }

    public int getGlobalXMin() {
        return this.globalArea.x;
    }

    public int getLocalXMin() {
        return this.localArea.x;
    }

    public int getGlobalXMax() {
        return this.globalArea.x + this.globalArea.width;
    }

    public int getLocalXMax() {
        return this.getLocalXMin() + this.getLocalWidth();
    }

    public int getGlobalYMin() {
        return this.globalArea.y;
    }

    public int getLocalYMin() {
        return this.localArea.y;
    }

    public int getGlobalYMax() {
        return this.globalArea.y + this.globalArea.height;
    }

    public int getLocalYMax() {
        return this.getLocalYMin() + this.getLocalHeight();
    }

    public int getGlobalWidth() {
        return this.globalArea.width;
    }

    public int getLocalWidth() {
        return (int)((double)this.localArea.width / this.scale);
    }

    public int getGlobalHeight() {
        return this.globalArea.height;
    }

    public int getLocalHeight() {
        return (int)((double)this.localArea.height / this.scale);
    }
}

