/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;

public final class RangeListConstraint
extends SubtypeConstraint {
    private final LimitType.Type limitType;
    private final List<RangeLimit> rlList;

    public RangeListConstraint(LimitType.Type limitType) {
        this.limitType = limitType;
        this.rlList = new ArrayList<RangeLimit>();
    }

    private RangeListConstraint(LimitType.Type limitType, List<RangeLimit> rlList) {
        this.limitType = limitType;
        this.rlList = rlList;
    }

    public RangeListConstraint(LimitType l) {
        this.limitType = l.getType();
        this.rlList = new ArrayList<RangeLimit>(1);
        this.rlList.add(new RangeLimit(l, false));
    }

    public RangeListConstraint(LimitType lBegin, LimitType lEnd) {
        this.limitType = lBegin.getType();
        if (lBegin.compareTo(lEnd) == 0) {
            this.rlList = new ArrayList<RangeLimit>(1);
            this.rlList.add(new RangeLimit(lBegin, false));
        } else {
            this.rlList = new ArrayList<RangeLimit>(2);
            this.rlList.add(new RangeLimit(lBegin, true));
            this.rlList.add(new RangeLimit(lEnd, false));
        }
    }

    public LimitType.Type getLimitType() {
        return this.limitType;
    }

    @Override
    public RangeListConstraint complement() {
        if (this.rlList.isEmpty()) {
            return new RangeListConstraint(LimitType.getMinimum(this.limitType), LimitType.getMaximum(this.limitType));
        }
        ArrayList<RangeLimit> retVal = new ArrayList<RangeLimit>();
        LimitType min = LimitType.getMinimum(this.limitType);
        RangeLimit rl = this.rlList.get(0);
        if (rl.value.compareTo(min) != 0) {
            if (min.isAdjacent(rl.value)) {
                retVal.add(new RangeLimit(min, false));
            } else {
                retVal.add(new RangeLimit(min, true));
                retVal.add(new RangeLimit(rl.value.decrement(), false));
            }
        }
        int last = this.rlList.size() - 1;
        for (int i = 0; i < last; ++i) {
            rl = this.rlList.get(i);
            RangeLimit rl1 = this.rlList.get(i + 1);
            if (rl.interval) continue;
            if (rl.value.increment().compareTo(rl1.value.decrement()) == 0) {
                retVal.add(new RangeLimit(rl.value.increment(), false));
                continue;
            }
            retVal.add(new RangeLimit(rl.value.increment(), true));
            retVal.add(new RangeLimit(rl1.value.decrement(), false));
        }
        rl = this.rlList.get(last);
        LimitType max = LimitType.getMaximum(this.limitType);
        if (rl.value.compareTo(max) != 0) {
            if (rl.value.isAdjacent(max)) {
                retVal.add(new RangeLimit(max, false));
            } else {
                retVal.add(new RangeLimit(rl.value.increment(), true));
                retVal.add(new RangeLimit(max, false));
            }
        }
        return new RangeListConstraint(this.limitType, retVal);
    }

    public RangeListConstraint setOperation(SubtypeConstraint other, boolean isUnion) {
        int i;
        RangeListConstraint o = (RangeListConstraint)other;
        if (this.rlList.isEmpty()) {
            return isUnion ? o : this;
        }
        if (o.rlList.isEmpty()) {
            return isUnion ? this : o;
        }
        ArrayList<SweepPoint> sweepPoints = new ArrayList<SweepPoint>();
        SweepPoint spi = new SweepPoint(0, 0);
        while (spi.aIdx < this.rlList.size() || spi.bIdx < o.rlList.size()) {
            if (spi.aIdx >= this.rlList.size()) {
                sweepPoints.add(new SweepPoint(-1, spi.bIdx));
                spi.bIdx++;
                continue;
            }
            if (spi.bIdx >= o.rlList.size()) {
                sweepPoints.add(new SweepPoint(spi.aIdx, -1));
                spi.aIdx++;
                continue;
            }
            int compRv = this.rlList.get(spi.aIdx).value.compareTo(o.rlList.get(spi.bIdx).value);
            if (compRv < 0) {
                sweepPoints.add(new SweepPoint(spi.aIdx, -1));
                spi.aIdx++;
                continue;
            }
            if (compRv == 0) {
                sweepPoints.add(new SweepPoint(spi.aIdx, spi.bIdx));
                spi.aIdx++;
                spi.bIdx++;
                continue;
            }
            sweepPoints.add(new SweepPoint(-1, spi.bIdx));
            spi.bIdx++;
        }
        boolean inA = false;
        boolean inB = false;
        for (i = 0; i < sweepPoints.size(); ++i) {
            boolean aInterval = inA;
            boolean aPoint = false;
            spi = (SweepPoint)sweepPoints.get(i);
            if (spi.aIdx != -1) {
                aPoint = true;
                if (this.rlList.get(spi.aIdx).interval) {
                    aInterval = true;
                    inA = true;
                } else {
                    aInterval = false;
                    inA = false;
                }
            }
            boolean bInterval = inB;
            boolean bPoint = false;
            if (spi.bIdx != -1) {
                bPoint = true;
                if (o.rlList.get(spi.bIdx).interval) {
                    bInterval = true;
                    inB = true;
                } else {
                    bInterval = false;
                    inB = false;
                }
            }
            spi.unionInterval = aInterval || bInterval;
            spi.intersectionPoint = !(!aPoint && !inA || !bPoint && !inB);
            spi.intersectionInterval = aInterval && bInterval;
        }
        if (isUnion) {
            for (i = 1; i < sweepPoints.size(); ++i) {
                LimitType second;
                SweepPoint spFirst = (SweepPoint)sweepPoints.get(i - 1);
                SweepPoint spSecond = (SweepPoint)sweepPoints.get(i);
                LimitType first = spFirst.aIdx != -1 ? this.rlList.get(spFirst.aIdx).value : o.rlList.get(spFirst.bIdx).value;
                if (!first.isAdjacent(second = spSecond.aIdx != -1 ? this.rlList.get(spSecond.aIdx).value : o.rlList.get(spSecond.bIdx).value)) continue;
                spFirst.unionInterval = true;
                spFirst.intersectionInterval = spFirst.intersectionPoint && spSecond.intersectionPoint;
            }
        }
        ArrayList<RangeLimit> retVal = new ArrayList<RangeLimit>();
        for (int i2 = 0; i2 < sweepPoints.size(); ++i2) {
            LimitType l;
            spi = (SweepPoint)sweepPoints.get(i2);
            if (isUnion) {
                if (i2 != 0 && ((SweepPoint)sweepPoints.get(i2 - 1)).unionInterval && spi.unionInterval) continue;
                l = spi.aIdx != -1 ? this.rlList.get(spi.aIdx).value : o.rlList.get(spi.bIdx).value;
                retVal.add(new RangeLimit(l, spi.unionInterval));
                continue;
            }
            if (!spi.intersectionPoint || i2 != 0 && ((SweepPoint)sweepPoints.get(i2 - 1)).intersectionInterval && spi.intersectionInterval) continue;
            l = spi.aIdx != -1 ? this.rlList.get(spi.aIdx).value : o.rlList.get(spi.bIdx).value;
            retVal.add(new RangeLimit(l, spi.intersectionInterval));
        }
        return new RangeListConstraint(this.limitType, retVal);
    }

    @Override
    public RangeListConstraint intersection(SubtypeConstraint other) {
        return this.setOperation(other, false);
    }

    @Override
    public RangeListConstraint union(SubtypeConstraint other) {
        return this.setOperation(other, true);
    }

    @Override
    public boolean isElement(Object o) {
        int compRv;
        if (this.rlList.isEmpty()) {
            return false;
        }
        LimitType l = (LimitType)o;
        int lowerIdx = 0;
        int upperIdx = this.rlList.size() - 1;
        while (upperIdx > lowerIdx + 1) {
            int middleIndex = lowerIdx + (upperIdx - lowerIdx) / 2;
            if (this.rlList.get(middleIndex).value.compareTo(l) < 0) {
                lowerIdx = middleIndex;
                continue;
            }
            upperIdx = middleIndex;
        }
        if (lowerIdx == upperIdx) {
            compRv = this.rlList.get(lowerIdx).value.compareTo(l);
            if (compRv == 0) {
                return true;
            }
            if (compRv < 0) {
                return this.rlList.get(lowerIdx).interval;
            }
            return lowerIdx > 0 ? this.rlList.get(lowerIdx - 1).interval : false;
        }
        compRv = this.rlList.get(lowerIdx).value.compareTo(l);
        if (compRv > 0) {
            return lowerIdx > 0 ? this.rlList.get(lowerIdx - 1).interval : false;
        }
        if (compRv == 0) {
            return true;
        }
        compRv = this.rlList.get(upperIdx).value.compareTo(l);
        if (compRv > 0) {
            return this.rlList.get(upperIdx - 1).interval;
        }
        if (compRv == 0) {
            return true;
        }
        return this.rlList.get(upperIdx).interval;
    }

    @Override
    public TernaryBool isEmpty() {
        return TernaryBool.fromBool(this.rlList.isEmpty());
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        RangeListConstraint rlc = (RangeListConstraint)other;
        if (this.rlList.size() != rlc.rlList.size()) {
            return TernaryBool.TFALSE;
        }
        for (int i = 0; i < this.rlList.size(); ++i) {
            if (this.rlList.get(i).value.compareTo(rlc.rlList.get(i).value) != 0) {
                return TernaryBool.TFALSE;
            }
            if (this.rlList.get(i).interval == rlc.rlList.get(i).interval) continue;
            return TernaryBool.TFALSE;
        }
        return TernaryBool.TTRUE;
    }

    @Override
    public TernaryBool isFull() {
        if (this.rlList.size() != 2) {
            return TernaryBool.TFALSE;
        }
        if (!this.rlList.get(0).interval) {
            return TernaryBool.TFALSE;
        }
        LimitType l = this.rlList.get(0).value;
        if (l.compareTo(LimitType.getMinimum(this.limitType)) != 0) {
            return TernaryBool.TFALSE;
        }
        l = this.rlList.get(1).value;
        if (l.compareTo(LimitType.getMaximum(this.limitType)) != 0) {
            return TernaryBool.TFALSE;
        }
        return TernaryBool.TTRUE;
    }

    public LimitType getMinimal() {
        return !this.rlList.isEmpty() ? this.rlList.get(0).value : null;
    }

    public LimitType getMaximal() {
        return !this.rlList.isEmpty() ? this.rlList.get(this.rlList.size() - 1).value : null;
    }

    public void toString(StringBuilder sb, boolean addBrackets) {
        if (addBrackets) {
            sb.append('(');
        }
        int last = this.rlList.size() - 1;
        for (int i = 0; i <= last; ++i) {
            RangeLimit rl = this.rlList.get(i);
            rl.value.toString(sb);
            if (rl.interval) {
                sb.append("..");
                continue;
            }
            if (i >= last) continue;
            sb.append(", ");
        }
        if (addBrackets) {
            sb.append(')');
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        this.toString(sb, true);
    }

    static final class RangeLimit {
        private final LimitType value;
        private final boolean interval;

        private RangeLimit(LimitType v, boolean i) {
            this.value = v;
            this.interval = i;
        }
    }

    static final class SweepPoint {
        private int aIdx;
        private int bIdx;
        private boolean unionInterval;
        private boolean intersectionInterval;
        private boolean intersectionPoint;

        private SweepPoint(int a, int b) {
            this.aIdx = a;
            this.bIdx = b;
            this.unionInterval = false;
            this.intersectionInterval = false;
            this.intersectionPoint = false;
        }
    }
}

