/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class JavaRuntimeHelper {
    public static final String VERSION_1_8 = "1.8";
    public static final int MODULE_PATH = 4;
    public static final int CLASS_PATH = 5;

    public static boolean isModularConfiguration(ILaunchConfiguration configuration) {
        try {
            IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
            if (vm instanceof AbstractVMInstall) {
                AbstractVMInstall install = (AbstractVMInstall)vm;
                String vmver = install.getJavaVersion();
                if (vmver == null) {
                    return false;
                }
                if (vmver.length() > 3) {
                    vmver = vmver.substring(0, 3);
                }
                if (VERSION_1_8.compareTo(vmver) < 0) {
                    return true;
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return false;
    }
}

