/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class NewTITANProjectImportMainPage
extends WizardPage {
    private Composite pageComposite;
    private Text projectFileText;
    private Button projectFileSelectionButton;
    private Text searchPathEnumerateTextField;
    private String projectFile;
    private List<String> searchPaths;
    private boolean correctSearchPaths = false;
    private final BasicProjectSelectorListener generalListener = new BasicProjectSelectorListener();

    public NewTITANProjectImportMainPage(String name) {
        super(name);
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    public List<String> getSearchPaths() {
        return this.searchPaths;
    }

    public void createControl(Composite parent) {
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageComposite.setLayoutData((Object)data);
        this.createProjectFileEditor(this.pageComposite);
        this.setControl((Control)this.pageComposite);
        this.setPageComplete(false);
    }

    protected void createProjectFileEditor(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText("Original project file:");
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.projectFileText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        this.projectFileText.setLayoutData((Object)gd);
        this.projectFileText.setFont(font);
        this.projectFileText.addModifyListener((ModifyListener)this.generalListener);
        this.projectFileSelectionButton = new Button((Composite)group, 8);
        this.projectFileSelectionButton.setText("Browse..");
        this.projectFileSelectionButton.setLayoutData((Object)new GridData());
        this.projectFileSelectionButton.addSelectionListener((SelectionListener)this.generalListener);
        group = new Group(parent, 0);
        group.setText("Search paths during importing referenced projects:");
        gd = new GridData(768);
        group.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        this.searchPathEnumerateTextField = new Text((Composite)group, 2052);
        this.searchPathEnumerateTextField.setLayoutData((Object)gd);
        this.searchPathEnumerateTextField.setFont(font);
        this.searchPathEnumerateTextField.addModifyListener((ModifyListener)this.generalListener);
    }

    protected void handleProjectFileButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterPath(this.projectFileText.getText());
        dialog.setFilterExtensions(new String[]{"*.tpd", "*.Tpd", "*.TITAN_Project_Format"});
        String file = dialog.open();
        if (file != null && !file.equals(this.projectFileText.getText())) {
            this.projectFileText.setText(file);
        }
    }

    protected void handleProjectFileModified() {
        this.projectFile = this.projectFileText.getText();
        this.correctSearchPaths = this.checkSearchPaths();
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NewTITANProjectImportMainPage.this.checkProjectFile();
            }
        });
    }

    protected void handleSearchPathTextModified() {
        this.correctSearchPaths = this.checkSearchPaths();
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NewTITANProjectImportMainPage.this.checkProjectFile();
            }
        });
    }

    private void checkProjectFile() {
        this.setPageComplete(this.projectFile != null && !"".equals(this.projectFile.trim()) && this.correctSearchPaths);
    }

    private boolean checkSearchPaths() {
        String text = this.searchPathEnumerateTextField.getText().trim();
        if (!text.isEmpty() && !text.startsWith("-I")) {
            this.setErrorMessage("The search path shall start with -I.");
            return false;
        }
        this.searchPaths = new ArrayList<String>(Arrays.asList(text.split("\\s*-I\\s*", -1)));
        this.searchPaths.removeAll(Arrays.asList(null, ""));
        for (String string : this.searchPaths) {
            if ((string = string.trim()).contains(" ")) {
                this.setErrorMessage("The path (" + string + ")  contains whitespaces or the -I flag is missing.");
                return false;
            }
            Path path = new Path(string);
            if (path.isAbsolute()) continue;
            this.setErrorMessage("The paths in the search paths must be absolute. " + string + " is not an absolute path.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected class BasicProjectSelectorListener
    implements ModifyListener,
    SelectionListener {
        protected BasicProjectSelectorListener() {
        }

        public void modifyText(ModifyEvent e) {
            Object source = e.getSource();
            if (source == NewTITANProjectImportMainPage.this.projectFileText) {
                NewTITANProjectImportMainPage.this.handleProjectFileModified();
            } else if (source == NewTITANProjectImportMainPage.this.searchPathEnumerateTextField) {
                NewTITANProjectImportMainPage.this.handleSearchPathTextModified();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == NewTITANProjectImportMainPage.this.projectFileSelectionButton) {
                NewTITANProjectImportMainPage.this.handleProjectFileButtonSelected();
            }
        }
    }
}

