/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class GroupsWithoutAttributes
extends BaseModuleCodeSmellSpotter {
    private static final String WARNING_MESSAGE = "The group `{0}'' does not contain any attribute";

    public GroupsWithoutAttributes() {
        super(CodeSmellType.GROUPS_WITHOUT_ATTRIBUTES);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        Group g;
        MultipleWithAttributes attributePath;
        if (node instanceof Group && (attributePath = (g = (Group)node).getAttributePath().getAttributes()) == null) {
            String msg = MessageFormat.format(WARNING_MESSAGE, g.getIdentifier().getDisplayName());
            problems.report(g.getIdentifier().getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Group.class);
        return ret;
    }
}

