/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.Module_List;
import org.eclipse.titan.runtime.core.TC_End;
import org.eclipse.titan.runtime.core.TTCN_Communication;
import org.eclipse.titan.runtime.core.TTCN_Default;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanPort;
import org.eclipse.titan.runtime.core.TitanTimer;
import org.eclipse.titan.runtime.core.TitanVerdictType;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.utils.StringUtils;

public final class TTCN_Runtime {
    public static final int TTCN3_MAJOR = 11;
    public static final int TTCN3_MINOR = 0;
    public static final int TTCN3_PATCHLEVEL = 0;
    public static final int TTCN3_BUILDNUMBER = 0;
    public static final String VERSION_STRING = "11.0.0";
    public static final String PRODUCT_NUMBER = "11.0.0";
    private static ThreadLocal<executorStateEnum> executorState = new ThreadLocal<executorStateEnum>(){

        @Override
        protected executorStateEnum initialValue() {
            return executorStateEnum.UNDEFINED_STATE;
        }
    };
    private static ThreadLocal<String> component_type_module = new ThreadLocal();
    private static ThreadLocal<String> component_type_name = new ThreadLocal();
    private static ThreadLocal<String> system_type_module = new ThreadLocal();
    private static ThreadLocal<String> system_type_name = new ThreadLocal();
    private static ThreadLocal<String> component_name = new ThreadLocal();
    private static ThreadLocal<Boolean> is_alive = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static String control_module_name = null;
    private static ThreadLocal<String> testcaseModuleName = new ThreadLocal();
    private static ThreadLocal<String> testcaseDefinitionName = new ThreadLocal();
    private static ThreadLocal<Double> startTime = new ThreadLocal<Double>(){

        @Override
        protected Double initialValue() {
            return 0.0;
        }
    };
    private static ThreadLocal<TitanVerdictType.VerdictTypeEnum> localVerdict = new ThreadLocal<TitanVerdictType.VerdictTypeEnum>(){

        @Override
        protected TitanVerdictType.VerdictTypeEnum initialValue() {
            return TitanVerdictType.VerdictTypeEnum.NONE;
        }
    };
    private static int[] verdictCount = new int[]{0, 0, 0, 0, 0};
    private static int controlErrorCount = 0;
    private static ThreadLocal<String> verdictReason = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return "";
        }
    };
    private static ThreadLocal<Integer> ttcn_try_block_counter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<Integer> create_done_killed_compref = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static ThreadLocal<Boolean> running_alive_result = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static TitanAlt_Status any_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
    private static TitanAlt_Status all_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
    private static TitanAlt_Status any_component_killed_status = TitanAlt_Status.ALT_UNCHECKED;
    private static TitanAlt_Status all_component_killed_status = TitanAlt_Status.ALT_UNCHECKED;
    private static ThreadLocal<Integer> component_status_table_offset = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 3;
        }
    };
    private static ThreadLocal<ArrayList<component_status_table_struct>> component_status_table = new ThreadLocal<ArrayList<component_status_table_struct>>(){

        @Override
        protected ArrayList<component_status_table_struct> initialValue() {
            return new ArrayList<component_status_table_struct>();
        }
    };
    private static HashMap<Integer, component_thread_struct> components_by_compref;
    private static HashMap<Thread, component_thread_struct> components_by_thread;
    private static final int HASHTABLE_SIZE = 97;
    private static ArrayList<Thread> threads;
    private static ThreadLocal<Integer> translation_count;
    private static ThreadLocal<TitanPort> port;

    private TTCN_Runtime() {
    }

    public static executorStateEnum get_state() {
        return executorState.get();
    }

    public static void set_state(executorStateEnum newState) {
        executorState.set(newState);
    }

    public static boolean is_hc() {
        switch (executorState.get()) {
            case HC_INITIAL: 
            case HC_IDLE: 
            case HC_CONFIGURING: 
            case HC_ACTIVE: 
            case HC_OVERLOADED: 
            case HC_OVERLOADED_TIMEOUT: 
            case HC_EXIT: {
                return true;
            }
        }
        return false;
    }

    public static boolean is_mtc() {
        switch (executorState.get()) {
            case MTC_INITIAL: 
            case MTC_IDLE: 
            case MTC_CONTROLPART: 
            case MTC_TESTCASE: 
            case MTC_TERMINATING_TESTCASE: 
            case MTC_TERMINATING_EXECUTION: 
            case MTC_PAUSED: 
            case MTC_CREATE: 
            case MTC_START: 
            case MTC_STOP: 
            case MTC_KILL: 
            case MTC_RUNNING: 
            case MTC_ALIVE: 
            case MTC_DONE: 
            case MTC_KILLED: 
            case MTC_CONNECT: 
            case MTC_DISCONNECT: 
            case MTC_MAP: 
            case MTC_UNMAP: 
            case MTC_CONFIGURING: 
            case MTC_EXIT: {
                return true;
            }
        }
        return false;
    }

    public static boolean is_ptc() {
        switch (executorState.get()) {
            case PTC_INITIAL: 
            case PTC_IDLE: 
            case PTC_FUNCTION: 
            case PTC_CREATE: 
            case PTC_START: 
            case PTC_STOP: 
            case PTC_KILL: 
            case PTC_RUNNING: 
            case PTC_ALIVE: 
            case PTC_DONE: 
            case PTC_KILLED: 
            case PTC_CONNECT: 
            case PTC_DISCONNECT: 
            case PTC_MAP: 
            case PTC_UNMAP: 
            case PTC_STOPPED: 
            case PTC_EXIT: {
                return true;
            }
        }
        return false;
    }

    public static boolean is_tc() {
        return TTCN_Runtime.is_mtc() || TTCN_Runtime.is_ptc();
    }

    public static boolean is_single() {
        switch (executorState.get()) {
            case SINGLE_CONTROLPART: 
            case SINGLE_TESTCASE: {
                return true;
            }
        }
        return false;
    }

    public static boolean is_undefined() {
        return executorState.get() == executorStateEnum.UNDEFINED_STATE;
    }

    public static boolean is_idle() {
        switch (executorState.get()) {
            case HC_IDLE: 
            case HC_ACTIVE: 
            case HC_OVERLOADED: 
            case MTC_IDLE: 
            case PTC_IDLE: 
            case PTC_STOPPED: {
                return true;
            }
        }
        return false;
    }

    public static boolean is_overloaded() {
        switch (executorState.get()) {
            case HC_OVERLOADED: 
            case HC_OVERLOADED_TIMEOUT: {
                return true;
            }
        }
        return false;
    }

    public static void set_port_state(int state, String info, boolean bySystem) {
        if (translation_count.get() > 0) {
            int low_end;
            if (port == null) {
                throw new TtcnError("Internal error: TTCN_Runtime.set_port_state: The port is null.");
            }
            int n = low_end = bySystem ? -1 : 0;
            if (state < low_end || state > 4) {
                translation_count.set(translation_count.get() - 1);
                throw new TtcnError("The value of the first parameter in the setstate operation must be 0, 1, 2, 3 or 4.");
            }
        } else {
            throw new TtcnError("setstate operation was called without being in a translation procedure.");
        }
        TitanPort.translation_port_state realState = TitanPort.translation_port_state.getByCode(state);
        port.get().change_port_state(realState);
        TTCN_Logger.log_setstate(port.get().get_name(), realState, new TitanCharString(info));
    }

    public static void set_port_state(TitanInteger state, TitanCharString info, boolean bySystem) {
        TTCN_Runtime.set_port_state(state.get_int(), info.get_value().toString(), bySystem);
    }

    public static TitanPort get_translation_port() {
        if (port.get() == null) {
            throw new TtcnError("Operation 'port.getref' was called while not in a port translation procedure.");
        }
        return port.get();
    }

    public static void set_translation_mode(boolean enabled, TitanPort p_port) {
        if (enabled) {
            translation_count.set(translation_count.get() + 1);
        } else {
            translation_count.set(translation_count.get() - 1);
            if (translation_count.get() < 0) {
                translation_count.set(0);
            }
        }
        if (translation_count.get() == 0 || p_port != null) {
            port.set(p_port);
        }
    }

    public static void increase_try_catch_counter() {
        ttcn_try_block_counter.set(ttcn_try_block_counter.get() + 1);
    }

    public static void decrease_try_catch_counter() {
        ttcn_try_block_counter.set(ttcn_try_block_counter.get() - 1);
    }

    public static boolean is_in_ttcn_try_block() {
        return ttcn_try_block_counter.get() > 0;
    }

    private static boolean in_controlPart() {
        return executorState.get() == executorStateEnum.SINGLE_CONTROLPART || executorState.get() == executorStateEnum.MTC_CONTROLPART;
    }

    private static boolean verdict_enabled() {
        return executorState.get() == executorStateEnum.SINGLE_TESTCASE || TTCN_Runtime.is_mtc() || TTCN_Runtime.is_ptc();
    }

    private static void wait_for_state_change() {
        executorStateEnum oldState = executorState.get();
        do {
            TTCN_Snapshot.take_new(true);
        } while (oldState == executorState.get());
    }

    static void clean_up() {
        component_type_module.set(null);
        component_type_name.set(null);
        system_type_module.set(null);
        system_type_name.set(null);
        component_name.set(null);
        control_module_name = null;
        testcaseModuleName.set(null);
        testcaseDefinitionName.set(null);
    }

    private static void initialize_component_type() {
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.init__component__start, component_type_module.get(), component_type_name.get(), 0, null, TTCN_Runtime.get_testcase_name(), 0, 0);
        Module_List.initialize_component(component_type_module.get(), component_type_name.get(), true);
        TitanPort.set_parameters(TitanComponent.self.get().get_component(), component_name.get());
        TitanPort.all_start();
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.init__component__finish, component_type_module.get(), component_type_name.get(), 0, null, null, 0, 0);
        localVerdict.set(TitanVerdictType.VerdictTypeEnum.NONE);
        verdictReason.set("");
    }

    private static void terminate_component_type() {
        if (component_type_module.get() != null && component_type_name.get() != null) {
            TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.terminating__component, component_type_module.get(), component_type_name.get(), 0, null, null, 0, 0);
            TTCN_Default.deactivate_all();
            TitanTimer.all_stop();
            TitanPort.deactivate_all();
            TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.component__shut__down, component_type_module.get(), component_type_name.get(), 0, null, TTCN_Runtime.get_testcase_name(), 0, 0);
            component_type_module.set(null);
            component_type_name.set(null);
        }
    }

    private static void set_component_type(String par_component_type_module, String par_component_type_name) {
        if (par_component_type_module == null || par_component_type_module.length() == 0 || par_component_type_name == null || par_component_type_name.length() == 0) {
            throw new TtcnError("Internal error: TTCN_Runtime.set_component_type: Trying to set an invalid component type.");
        }
        if (component_type_module.get() != null && component_type_name.get() != null) {
            throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.set_component_type: Trying to set component type {0}.{1} while another one is active.", par_component_type_module, par_component_type_name));
        }
        component_type_module.set(par_component_type_module);
        component_type_name.set(par_component_type_name);
    }

    private static void set_system_type(String par_system_type_module, String par_system_type_name) {
        if (par_system_type_module == null || par_system_type_module.length() == 0 || par_system_type_name == null || par_system_type_name.length() == 0) {
            throw new TtcnError("Internal error: TTCN_Runtime.set_system_type: Trying to set an invalid system component type.");
        }
        system_type_module.set(par_system_type_module);
        system_type_name.set(par_system_type_name);
    }

    public static void set_component_name(String new_component_name) {
        if (new_component_name != null && new_component_name.length() > 0) {
            component_name.set(new_component_name);
        } else {
            component_name.set(null);
        }
    }

    private static void set_testcase_name(String parModuleName, String parTestcaseName) {
        if (parModuleName == null || parModuleName.length() == 0 || parTestcaseName == null || parTestcaseName.length() == 0) {
            throw new TtcnError("Internal error: TTCN_Runtime.set_testcase_name: Trying to set an invalid testcase name.");
        }
        if (testcaseModuleName.get() != null || testcaseDefinitionName.get() != null) {
            throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.set_testcase_name: Trying to set testcase name {0}.{1} while another one is active.", parModuleName, parTestcaseName));
        }
        testcaseModuleName.set(parModuleName);
        testcaseDefinitionName.set(parTestcaseName);
    }

    public static String get_host_name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new TtcnError(e);
        }
    }

    public static String get_component_type() {
        return component_type_name.get();
    }

    public static String get_component_name() {
        return component_name.get();
    }

    public static String get_testcase_name() {
        return testcaseDefinitionName.get();
    }

    public static void set_logger_parameters() {
        TTCN_Logger.set_plugin_parameters(TitanComponent.self.get(), component_name.get());
    }

    public static TitanCharString get_testcase_id_macro() {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Macro %%testcaseId cannot be used from the control part outside test cases.");
        }
        if (testcaseDefinitionName.get() == null || testcaseDefinitionName.get().length() == 0) {
            throw new TtcnError("Internal error: Evaluating macro %%testcaseId, but the name of the current testcase is not set.");
        }
        return new TitanCharString(testcaseDefinitionName.get());
    }

    public static TitanCharString get_testcasename() {
        if (TTCN_Runtime.in_controlPart() || TTCN_Runtime.is_hc()) {
            return new TitanCharString("");
        }
        if (testcaseDefinitionName.get() == null || testcaseDefinitionName.get().length() == 0) {
            throw new TtcnError("Internal error: Evaluating predefined function testcasename(), but the name of the current testcase is not set.");
        }
        return new TitanCharString(testcaseDefinitionName.get());
    }

    public static TitanFloat now() {
        if (startTime.get() == 0.0) {
            throw new TtcnError("Accessing the test system time while no test case is running.");
        }
        double current_Time = (double)System.currentTimeMillis() / 1000.0;
        return new TitanFloat(current_Time - startTime.get());
    }

    public static int hc_main(String local_addr, String MC_host, int MC_port) {
        int returnValue = 0;
        TTCN_Runtime.set_state(executorStateEnum.HC_INITIAL);
        TTCN_Logger.log_hc_start(TTCN_Runtime.get_host_name());
        TTCN_Logger.write_logger_settings();
        try {
            TTCN_Communication.set_mc_address(MC_host, MC_port);
            TTCN_Communication.connect_mc();
            executorState.set(executorStateEnum.HC_IDLE);
            TTCN_Communication.send_version();
            TTCN_Runtime.initialize_component_process_tables();
            do {
                TTCN_Snapshot.take_new(true);
                TTCN_Communication.process_all_messages_hc();
            } while (executorState.get().ordinal() >= executorStateEnum.HC_IDLE.ordinal() && executorState.get().ordinal() < executorStateEnum.HC_EXIT.ordinal());
            if (executorState.get() == executorStateEnum.HC_EXIT) {
                TTCN_Communication.disconnect_mc();
                TTCN_Runtime.clean_up();
            }
        }
        catch (TtcnError error) {
            returnValue = -1;
            TTCN_Runtime.clean_up();
        }
        TTCN_Runtime.clear_component_process_tables();
        if (TTCN_Runtime.is_hc()) {
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.host__controller__finished);
        }
        TTCN_Logger.close_file();
        return returnValue;
    }

    public static int mtc_main() {
        int returnValue = 0;
        TTCN_Logger.open_file();
        TTCN_Logger.log_executor_component(TitanLoggerApi.ExecutorComponent_reason.enum_type.mtc__started);
        try {
            TTCN_Communication.connect_mc();
            executorState.set(executorStateEnum.MTC_IDLE);
            TTCN_Communication.send_mtc_created();
            do {
                TTCN_Snapshot.take_new(true);
                TTCN_Communication.process_all_messages_tc();
            } while (executorState.get() != executorStateEnum.MTC_EXIT);
            TTCN_Communication.disconnect_mc();
            TTCN_Runtime.clean_up();
        }
        catch (TtcnError error) {
            returnValue = -1;
        }
        TTCN_Logger.log_executor_component(TitanLoggerApi.ExecutorComponent_reason.enum_type.mtc__finished);
        TTCN_Logger.close_file();
        return returnValue;
    }

    public static int ptc_main() {
        int returnValue = 0;
        TTCN_Logger.open_file();
        TTCN_Logger.begin_event(TTCN_Logger.Severity.EXECUTOR_COMPONENT);
        TTCN_Logger.log_event_str(MessageFormat.format("TTCN-3 Parallel Test Component started on {0}. Component reference: ", TTCN_Runtime.get_host_name()));
        TitanComponent.self.get().log();
        TTCN_Logger.log_event_str(MessageFormat.format(", component type: {0}.{1}", component_type_module.get(), component_type_name.get()));
        if (component_name != null) {
            TTCN_Logger.log_event_str(MessageFormat.format(", component name: {0}", component_name.get()));
        }
        TTCN_Logger.log_event_str(". Version: 11.0.0.");
        TTCN_Logger.end_event();
        TTCN_Logger.write_logger_settings();
        try {
            TTCN_Communication.connect_mc();
            executorState.set(executorStateEnum.PTC_IDLE);
            TTCN_Communication.send_ptc_created(TitanComponent.self.get().componentValue);
            try {
                TTCN_Runtime.initialize_component_type();
            }
            catch (TtcnError error) {
                TTCN_Logger.log_executor_component(TitanLoggerApi.ExecutorComponent_reason.enum_type.component__init__fail);
                returnValue = -1;
            }
            if (returnValue == 0) {
                try {
                    do {
                        TTCN_Snapshot.take_new(true);
                        TTCN_Communication.process_all_messages_tc();
                    } while (executorState.get() != executorStateEnum.PTC_EXIT);
                }
                catch (TtcnError error) {
                    TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.error__idle__ptc, null, null, 0, null, null, 0, 0);
                    returnValue = -1;
                }
            }
            if (returnValue != 0) {
                try {
                    TTCN_Runtime.terminate_component_type();
                }
                catch (TtcnError error) {
                    // empty catch block
                }
                try {
                    TTCN_Communication.send_killed(localVerdict.get(), verdictReason.get());
                }
                catch (TtcnError error) {
                    // empty catch block
                }
                TTCN_Logger.log_final_verdict(true, localVerdict.get(), localVerdict.get(), localVerdict.get(), verdictReason.get(), -1, -3, null);
                executorState.set(executorStateEnum.PTC_EXIT);
            }
            TTCN_Communication.disconnect_mc();
            TTCN_Runtime.clear_component_status_table();
            TTCN_Runtime.clean_up();
        }
        catch (TtcnError error) {
            returnValue = -1;
        }
        TTCN_Logger.log_executor_component(TitanLoggerApi.ExecutorComponent_reason.enum_type.ptc__finished);
        TTCN_Logger.close_file();
        return returnValue;
    }

    public static void initialize_system_port(String port_name) {
        Module_List.initialize_system_port(system_type_module.get(), system_type_name.get(), port_name);
    }

    public static int create_component(String createdComponentTypeModule, String createdComponentTypeName, String createdComponentName, String createdComponentLocation, boolean createdComponentAlive) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Create operation cannot be performed in the control part.");
        }
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Create operation cannot be performed in single mode.");
        }
        if (createdComponentName != null && createdComponentName.length() == 0) {
            TtcnError.TtcnWarning("Empty charstring value was ignored as component name in create operation.");
            createdComponentName = null;
        }
        if (createdComponentLocation != null && createdComponentLocation.length() == 0) {
            TtcnError.TtcnWarning("Empty charstring value was ignored as component location in create operation.");
            createdComponentLocation = null;
        }
        TTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED);
        TTCN_Logger.log_event_str(MessageFormat.format("Creating new {0}PTC with component type {1}.{2}", createdComponentAlive ? "alive " : "", createdComponentTypeModule, createdComponentTypeName));
        if (createdComponentName != null) {
            TTCN_Logger.log_event_str(MessageFormat.format(", component name: {0}", createdComponentName));
        }
        if (createdComponentLocation != null) {
            TTCN_Logger.log_event_str(MessageFormat.format(", location: {0}", createdComponentName));
        }
        TTCN_Logger.log_char('.');
        TTCN_Logger.end_event();
        switch (executorState.get()) {
            case MTC_TESTCASE: {
                executorState.set(executorStateEnum.MTC_CREATE);
                break;
            }
            case PTC_FUNCTION: {
                executorState.set(executorStateEnum.PTC_CREATE);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing create operation in invalid state.");
            }
        }
        TTCN_Communication.send_create_req(createdComponentTypeModule, createdComponentTypeName, createdComponentName, createdComponentLocation, createdComponentAlive, startTime.get());
        if (TTCN_Runtime.is_mtc()) {
            if (any_component_done_status == TitanAlt_Status.ALT_NO) {
                any_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
            }
            if (any_component_killed_status == TitanAlt_Status.ALT_NO) {
                any_component_killed_status = TitanAlt_Status.ALT_UNCHECKED;
            }
            all_component_killed_status = TitanAlt_Status.ALT_UNCHECKED;
        }
        TTCN_Runtime.wait_for_state_change();
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__created, createdComponentTypeModule, createdComponentTypeName, create_done_killed_compref.get(), createdComponentName, createdComponentLocation, createdComponentAlive ? 1 : 0, 0);
        TitanComponent.register_component_name(create_done_killed_compref.get(), createdComponentName);
        return create_done_killed_compref.get();
    }

    public static void prepare_start_component(TitanComponent component_reference, String module_name, String function_name, Text_Buf text_buf) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Start test component operation cannot be performed in the control part.");
        }
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Start test component operation cannot be performed in single mode.");
        }
        component_reference.must_bound("Performing a start operation on an unbound component reference.");
        int compref = component_reference.get_component();
        switch (compref) {
            case 0: {
                throw new TtcnError("Start operation cannot be performed on the null component reference.");
            }
            case 1: {
                throw new TtcnError("Start operation cannot be performed on the component reference of MTC.");
            }
            case 2: {
                throw new TtcnError("Start operation cannot be performed on the component reference of system.");
            }
            case -1: {
                throw new TtcnError("Internal error: 'any component' cannot be started.");
            }
            case -2: {
                throw new TtcnError("Internal error: 'all component' cannot be started.");
            }
        }
        if (TitanComponent.self.get().get_component() == compref) {
            throw new TtcnError("Start operation cannot be performed on the own component reference of the initiating component (i.e. 'self.start' is not allowed).");
        }
        if (TTCN_Runtime.in_component_status_table(compref)) {
            if (TTCN_Runtime.get_killed_status(compref) == TitanAlt_Status.ALT_YES) {
                throw new TtcnError(MessageFormat.format("PTC with component reference {0} is not alive anymore. Start operation cannot be performed on it.", compref));
            }
            TTCN_Runtime.cancel_component_done(compref);
        }
        TTCN_Communication.prepare_start_req(text_buf, compref, module_name, function_name);
    }

    public static void send_start_component(Text_Buf text_buf) {
        switch (executorState.get()) {
            case MTC_TESTCASE: {
                executorState.set(executorStateEnum.MTC_START);
                break;
            }
            case PTC_FUNCTION: {
                executorState.set(executorStateEnum.PTC_START);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing component start operation in invalid state.");
            }
        }
        TTCN_Communication.send_message(text_buf);
        if (TTCN_Runtime.is_mtc()) {
            all_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
        }
        TTCN_Runtime.wait_for_state_change();
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.function__started, null, null, 0, null, null, 0, 0);
    }

    public static void start_function(String module_name, String function_name, Text_Buf text_buf) {
        switch (executorState.get()) {
            case PTC_IDLE: 
            case PTC_STOPPED: {
                break;
            }
            default: {
                text_buf.cut_message();
                throw new TtcnError("Internal error: Message START arrived in invalid state.");
            }
        }
        try {
            Module_List.start_function(module_name, function_name, text_buf);
            return;
        }
        catch (TC_End e) {
            switch (executorState.get()) {
                case PTC_STOPPED: {
                    TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("Function {0} was stopped. PTC remains alive and is waiting for next start.", function_name));
                    TTCN_Communication.send_stopped(localVerdict.get(), verdictReason.get());
                    return;
                }
                case PTC_EXIT: {
                    TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.function__stopped, null, function_name, 0, null, null, 0, 0);
                    break;
                }
                default: {
                    throw new TtcnError("Internal error: PTC was stopped in invalid state.");
                }
            }
        }
        catch (TtcnError e) {
            TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.function__error, null, function_name, 0, null, null, 0, 0);
            executorState.set(executorStateEnum.PTC_EXIT);
        }
        TTCN_Runtime.terminate_component_type();
        TTCN_Communication.send_stopped_killed(localVerdict.get(), verdictReason.get());
        TTCN_Logger.log_final_verdict(true, localVerdict.get(), localVerdict.get(), localVerdict.get(), verdictReason.get(), -1, -3, null);
    }

    public static void function_started(Text_Buf text_buf) {
        text_buf.cut_message();
        executorState.set(executorStateEnum.PTC_FUNCTION);
        TTCN_Communication.process_all_messages_tc();
    }

    public static void prepare_function_finished(String return_type, Text_Buf text_buf) {
        if (executorState.get() != executorStateEnum.PTC_FUNCTION) {
            throw new TtcnError("Internal error: PTC behaviour function finished in invalid state.");
        }
        if (is_alive.get().booleanValue()) {
            TTCN_Communication.prepare_stopped(text_buf, localVerdict.get(), return_type, verdictReason.get());
        } else {
            TTCN_Runtime.terminate_component_type();
            TTCN_Communication.prepare_stopped_killed(text_buf, localVerdict.get(), return_type, verdictReason.get());
        }
    }

    public static void send_function_finished(Text_Buf text_buf) {
        TTCN_Communication.send_message(text_buf);
        if (is_alive.get().booleanValue()) {
            executorState.set(executorStateEnum.PTC_STOPPED);
        } else {
            TTCN_Logger.log_final_verdict(true, localVerdict.get(), localVerdict.get(), localVerdict.get(), verdictReason.get(), -1, -3, null);
            executorState.set(executorStateEnum.PTC_EXIT);
        }
    }

    public static void function_finished(String function_name) {
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.function__finished, null, function_name, 0, null, null, is_alive.get() != false ? 1 : 0, 0);
        Text_Buf text_buf = new Text_Buf();
        TTCN_Runtime.prepare_function_finished(null, text_buf);
        TTCN_Runtime.send_function_finished(text_buf);
    }

    public static TitanAlt_Status component_done(int component_reference, AtomicReference<TitanVerdictType.VerdictTypeEnum> ptc_verdict) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Done operation cannot be performed in the control part.");
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Done operation cannot be performed on the null component reference.");
            }
            case 1: {
                throw new TtcnError("Done operation cannot be performed on the component reference of MTC.");
            }
            case 2: {
                throw new TtcnError("Done operation cannot be performed on the component reference of system.");
            }
            case -1: {
                return TTCN_Runtime.any_component_done();
            }
            case -2: {
                return TTCN_Runtime.all_component_done();
            }
        }
        return TTCN_Runtime.ptc_done(component_reference, ptc_verdict);
    }

    public static TitanAlt_Status component_done(int component_reference, String return_type, AtomicReference<Text_Buf> text_buf) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Done operation cannot be performed in the control part.");
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Done operation cannot be performed on the null component reference.");
            }
            case 1: {
                throw new TtcnError("Done operation cannot be performed on the component reference of MTC.");
            }
            case 2: {
                throw new TtcnError("Done operation cannot be performed on the component reference of system.");
            }
            case -1: {
                throw new TtcnError("Done operation with return value cannot be performed on 'any component'.");
            }
            case -2: {
                throw new TtcnError("Done operation with return value cannot be performed on 'all component'.");
            }
        }
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Done operation on a component reference cannot be performed in single mode.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            TtcnError.TtcnWarning("Done operation on the component reference of self will never succeed.");
            return TitanAlt_Status.ALT_NO;
        }
        int index = TTCN_Runtime.get_component_status_table_index(component_reference);
        ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
        component_status_table_struct indexed_status_table_element = local_status_table.get(index);
        switch (indexed_status_table_element.done_status) {
            case ALT_UNCHECKED: {
                switch (executorState.get()) {
                    case MTC_TESTCASE: {
                        executorState.set(executorStateEnum.MTC_DONE);
                        break;
                    }
                    case PTC_FUNCTION: {
                        executorState.set(executorStateEnum.PTC_DONE);
                        break;
                    }
                    default: {
                        throw new TtcnError("Internal error: Executing done operation in invalid state.");
                    }
                }
                TTCN_Communication.send_done_req(component_reference);
                indexed_status_table_element.done_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(component_reference);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                if (indexed_status_table_element.return_type == null) {
                    TTCN_Logger.log_matching_done(return_type, component_reference, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.done__failed__no__return);
                    return TitanAlt_Status.ALT_NO;
                }
                if (indexed_status_table_element.return_type.equals(return_type)) {
                    indexed_status_table_element.return_value.rewind();
                    text_buf.set(indexed_status_table_element.return_value);
                    return TitanAlt_Status.ALT_YES;
                }
                TTCN_Logger.log_matching_done(return_type, component_reference, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.done__failed__wrong__return__type);
                return TitanAlt_Status.ALT_NO;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static TitanAlt_Status component_killed(TitanComponent component_reference) {
        return TTCN_Runtime.component_killed(component_reference.get_component());
    }

    public static TitanAlt_Status component_killed(int component_reference) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Killed operation cannot be performed in the control part.");
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Killed operation cannot be performed on the null component reference.");
            }
            case 1: {
                throw new TtcnError("Killed operation cannot be performed on the component reference of MTC.");
            }
            case 2: {
                throw new TtcnError("Killed operation cannot be performed on the component reference of system.");
            }
            case -1: {
                return TTCN_Runtime.any_component_killed();
            }
            case -2: {
                return TTCN_Runtime.all_component_killed();
            }
        }
        return TTCN_Runtime.ptc_killed(component_reference);
    }

    public static boolean component_running(TitanComponent component_reference) {
        return TTCN_Runtime.component_running(component_reference.get_component());
    }

    public static boolean component_running(int component_reference) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Component running operation cannot be performed in the control part.");
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Running operation cannot be performed on the null component reference.");
            }
            case 1: {
                throw new TtcnError("Running operation cannot be performed on the component reference of MTC.");
            }
            case 2: {
                throw new TtcnError("Running operation cannot be performed on the component reference of system.");
            }
            case -1: {
                return TTCN_Runtime.any_component_running();
            }
            case -2: {
                return TTCN_Runtime.all_component_running();
            }
        }
        return TTCN_Runtime.ptc_running(component_reference);
    }

    public static boolean component_alive(TitanComponent component_reference) {
        return TTCN_Runtime.component_alive(component_reference.get_component());
    }

    public static boolean component_alive(int component_reference) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Alive operation cannot be performed in the control part.");
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Alive operation cannot be performed on the null component reference.");
            }
            case 1: {
                throw new TtcnError("Alive operation cannot be performed on the component reference of MTC.");
            }
            case 2: {
                throw new TtcnError("Alive operation cannot be performed on the component reference of system.");
            }
            case -1: {
                return TTCN_Runtime.any_component_alive();
            }
            case -2: {
                return TTCN_Runtime.all_component_alive();
            }
        }
        return TTCN_Runtime.ptc_alive(component_reference);
    }

    public static void stop_component(TitanComponent component_reference) {
        TTCN_Runtime.stop_component(component_reference.get_component());
    }

    public static void stop_component(int component_reference) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Component stop operation cannot be performed in the control part.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            TTCN_Runtime.stop_execution();
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Stop operation cannot be performed on the null component reference.");
            }
            case 1: {
                TTCN_Runtime.stop_mtc();
                break;
            }
            case 2: {
                throw new TtcnError("Stop operation cannot be performed on the component reference of system.");
            }
            case -1: {
                throw new TtcnError("Internal error: 'any component' cannot be stopped.");
            }
            case -2: {
                TTCN_Runtime.stop_all_component();
                break;
            }
            default: {
                TTCN_Runtime.stop_ptc(component_reference);
            }
        }
    }

    public static void stop_execution() {
        if (TTCN_Runtime.in_controlPart()) {
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.stopping__control__part__execution);
        } else {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "Stopping test component execution.");
            if (TTCN_Runtime.is_ptc()) {
                if (is_alive.get().booleanValue()) {
                    executorState.set(executorStateEnum.PTC_STOPPED);
                } else {
                    executorState.set(executorStateEnum.PTC_EXIT);
                }
            }
        }
        throw new TC_End();
    }

    public static void kill_component(TitanComponent component_reference) {
        TTCN_Runtime.kill_component(component_reference.get_component());
    }

    public static void kill_component(int component_reference) {
        if (TTCN_Runtime.in_controlPart()) {
            throw new TtcnError("Kill operation cannot be performed in the control part.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            TTCN_Runtime.kill_execution();
        }
        switch (component_reference) {
            case 0: {
                throw new TtcnError("Kill operation cannot be performed on the null component reference.");
            }
            case 1: {
                TTCN_Runtime.stop_mtc();
                break;
            }
            case 2: {
                throw new TtcnError("Kill operation cannot be performed on the component reference of system.");
            }
            case -1: {
                throw new TtcnError("Internal error: 'any component' cannot be killed.");
            }
            case -2: {
                TTCN_Runtime.kill_all_component();
                break;
            }
            default: {
                TTCN_Runtime.kill_ptc(component_reference);
            }
        }
    }

    public static void kill_execution() {
        TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "Terminating test component execution.");
        if (TTCN_Runtime.is_ptc()) {
            executorState.set(executorStateEnum.PTC_EXIT);
        }
        throw new TC_End();
    }

    public static TitanAlt_Status ptc_done(int component_reference, AtomicReference<TitanVerdictType.VerdictTypeEnum> ptc_verdict) {
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Done operation on a component reference cannot be performed in single mode.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            TtcnError.TtcnWarning("Done operation on the component reference of self will never succeed.");
            return TitanAlt_Status.ALT_NO;
        }
        int index = TTCN_Runtime.get_component_status_table_index(component_reference);
        ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
        component_status_table_struct indexed_status_table_element = local_status_table.get(index);
        if (indexed_status_table_element.killed_status == TitanAlt_Status.ALT_YES) {
            TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__done, null, null, component_reference, null, null, 0, 0);
            if (ptc_verdict != null) {
                ptc_verdict.set(indexed_status_table_element.local_verdict);
            }
            return TitanAlt_Status.ALT_YES;
        }
        switch (indexed_status_table_element.done_status) {
            case ALT_UNCHECKED: {
                switch (executorState.get()) {
                    case MTC_TESTCASE: {
                        executorState.set(executorStateEnum.MTC_DONE);
                        break;
                    }
                    case PTC_FUNCTION: {
                        executorState.set(executorStateEnum.PTC_DONE);
                        break;
                    }
                    default: {
                        throw new TtcnError("Internal error: Executing done operation in invalid state.");
                    }
                }
                TTCN_Communication.send_done_req(component_reference);
                indexed_status_table_element.done_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(component_reference);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__done, null, null, component_reference, null, null, 0, 0);
                if (ptc_verdict != null) {
                    ptc_verdict.set(indexed_status_table_element.local_verdict);
                }
                return TitanAlt_Status.ALT_YES;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static TitanAlt_Status any_component_done() {
        if (TTCN_Runtime.is_single()) {
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__done__failed);
            return TitanAlt_Status.ALT_NO;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'any component.done' can only be performed on the MTC.");
        }
        ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
        for (int i = 0; i < local_status_table.size(); ++i) {
            component_status_table_struct componentStatus = local_status_table.get(i);
            if (componentStatus.done_status != TitanAlt_Status.ALT_YES && componentStatus.killed_status != TitanAlt_Status.ALT_YES) continue;
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__done__successful);
            return TitanAlt_Status.ALT_YES;
        }
        if (any_component_killed_status == TitanAlt_Status.ALT_YES) {
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__done__successful);
            return TitanAlt_Status.ALT_YES;
        }
        switch (any_component_done_status) {
            case ALT_UNCHECKED: {
                if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
                    throw new TtcnError("Internal error: Executing 'any component.done' in invalid state.");
                }
                executorState.set(executorStateEnum.MTC_DONE);
                TTCN_Communication.send_done_req(-1);
                any_component_done_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(-1);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__done__successful);
                return TitanAlt_Status.ALT_YES;
            }
            case ALT_NO: {
                TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__done__failed);
                return TitanAlt_Status.ALT_NO;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static TitanAlt_Status all_component_done() {
        if (TTCN_Runtime.is_single()) {
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.all__component__done__successful);
            return TitanAlt_Status.ALT_YES;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'all component.done' can only be performed on the MTC.");
        }
        if (all_component_killed_status == TitanAlt_Status.ALT_YES) {
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.all__component__done__successful);
            return TitanAlt_Status.ALT_YES;
        }
        switch (all_component_done_status) {
            case ALT_UNCHECKED: {
                if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
                    throw new TtcnError("Internal error: Executing 'all component.done' in invalid state.");
                }
                executorState.set(executorStateEnum.MTC_DONE);
                TTCN_Communication.send_done_req(-2);
                all_component_done_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(-2);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.all__component__done__successful);
                return TitanAlt_Status.ALT_YES;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static TitanAlt_Status ptc_killed(int component_reference) {
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Killed operation on a component reference cannot be performed in single mode.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            TtcnError.TtcnWarning("Killed operation on the component reference of self will never succeed.");
            return TitanAlt_Status.ALT_NO;
        }
        int index = TTCN_Runtime.get_component_status_table_index(component_reference);
        switch (TTCN_Runtime.component_status_table.get().get((int)index).killed_status) {
            case ALT_UNCHECKED: {
                switch (executorState.get()) {
                    case MTC_TESTCASE: {
                        executorState.set(executorStateEnum.MTC_KILLED);
                        break;
                    }
                    case PTC_FUNCTION: {
                        executorState.set(executorStateEnum.PTC_KILLED);
                        break;
                    }
                    default: {
                        throw new TtcnError("Internal error: Executing killed operation in invalid state.");
                    }
                }
                TTCN_Communication.send_killed_req(component_reference);
                TTCN_Runtime.component_status_table.get().get((int)index).killed_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(component_reference);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__killed, null, null, component_reference, null, null, 0, 0);
                return TitanAlt_Status.ALT_YES;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static TitanAlt_Status any_component_killed() {
        if (TTCN_Runtime.is_single()) {
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__killed__failed);
            return TitanAlt_Status.ALT_NO;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'any component.killed' can only be performed on the MTC.");
        }
        ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
        for (int i = 0; i < local_status_table.size(); ++i) {
            if (local_status_table.get((int)i).killed_status != TitanAlt_Status.ALT_YES) continue;
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__killed__successful);
            return TitanAlt_Status.ALT_YES;
        }
        switch (any_component_killed_status) {
            case ALT_UNCHECKED: {
                if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
                    throw new TtcnError("Internal error: Executing 'any component.killed' in invalid state.");
                }
                executorState.set(executorStateEnum.MTC_KILLED);
                TTCN_Communication.send_killed_req(-1);
                any_component_killed_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(-1);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__killed__successful);
                return TitanAlt_Status.ALT_YES;
            }
            case ALT_NO: {
                TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.any__component__killed__failed);
                return TitanAlt_Status.ALT_NO;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static TitanAlt_Status all_component_killed() {
        if (TTCN_Runtime.is_single()) {
            TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.all__component__killed__successful);
            return TitanAlt_Status.ALT_YES;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'all component.killed' can only be performed on the MTC.");
        }
        switch (all_component_killed_status) {
            case ALT_UNCHECKED: {
                if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
                    throw new TtcnError("Internal error: Executing 'all component.killed' in invalid state.");
                }
                executorState.set(executorStateEnum.MTC_KILLED);
                TTCN_Communication.send_killed_req(-2);
                all_component_killed_status = TitanAlt_Status.ALT_MAYBE;
                create_done_killed_compref.set(-2);
                TTCN_Runtime.wait_for_state_change();
                return TitanAlt_Status.ALT_REPEAT;
            }
            case ALT_YES: {
                TTCN_Logger.log_matching_done(null, 0, null, TitanLoggerApi.MatchingDoneType_reason.enum_type.all__component__killed__successful);
                return TitanAlt_Status.ALT_YES;
            }
        }
        return TitanAlt_Status.ALT_MAYBE;
    }

    public static boolean ptc_running(int component_reference) {
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Running operation on a component reference cannot be performed in single mode.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            return true;
        }
        if (TTCN_Runtime.in_component_status_table(component_reference)) {
            int index = TTCN_Runtime.get_component_status_table_index(component_reference);
            ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
            component_status_table_struct tempComponent = local_status_table.get(index);
            if (tempComponent.done_status == TitanAlt_Status.ALT_YES || tempComponent.killed_status == TitanAlt_Status.ALT_YES) {
                return false;
            }
        }
        switch (executorState.get()) {
            case MTC_TESTCASE: {
                executorState.set(executorStateEnum.MTC_RUNNING);
                break;
            }
            case PTC_FUNCTION: {
                executorState.set(executorStateEnum.PTC_RUNNING);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing component running operation in invalid state.");
            }
        }
        TTCN_Communication.send_is_running(component_reference);
        TTCN_Runtime.wait_for_state_change();
        return running_alive_result.get();
    }

    public static boolean any_component_running() {
        if (TTCN_Runtime.is_single()) {
            return false;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'any component.running' can only be performed on the MTC.");
        }
        if (all_component_done_status == TitanAlt_Status.ALT_YES || all_component_killed_status == TitanAlt_Status.ALT_YES) {
            return false;
        }
        if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
            throw new TtcnError("Internal error: Executing 'any component.running' in invalid state.");
        }
        TTCN_Communication.send_is_running(-1);
        executorState.set(executorStateEnum.MTC_RUNNING);
        TTCN_Runtime.wait_for_state_change();
        if (!running_alive_result.get().booleanValue()) {
            all_component_done_status = TitanAlt_Status.ALT_YES;
        }
        return running_alive_result.get();
    }

    public static boolean all_component_running() {
        if (TTCN_Runtime.is_single()) {
            return true;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'all component.running' can only be performed on the MTC.");
        }
        if (all_component_done_status == TitanAlt_Status.ALT_NO) {
            return true;
        }
        if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
            throw new TtcnError("Internal error: Executing 'all component.running' in invalid state.");
        }
        TTCN_Communication.send_is_running(-2);
        executorState.set(executorStateEnum.MTC_RUNNING);
        TTCN_Runtime.wait_for_state_change();
        if (!running_alive_result.get().booleanValue()) {
            all_component_done_status = TitanAlt_Status.ALT_YES;
        }
        return running_alive_result.get();
    }

    public static boolean ptc_alive(int component_reference) {
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Alive operation on a component reference cannot be performed in single mode.");
        }
        if (TitanComponent.self.get().componentValue == component_reference) {
            TtcnError.TtcnWarning("Alive operation on the component reference of self always returns true.");
            return true;
        }
        if (TTCN_Runtime.in_component_status_table(component_reference) && TTCN_Runtime.get_killed_status(component_reference) == TitanAlt_Status.ALT_YES) {
            return false;
        }
        switch (executorState.get()) {
            case MTC_TESTCASE: {
                executorState.set(executorStateEnum.MTC_ALIVE);
                break;
            }
            case PTC_FUNCTION: {
                executorState.set(executorStateEnum.PTC_ALIVE);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing component alive operation in invalid state.");
            }
        }
        TTCN_Communication.send_is_alive(component_reference);
        TTCN_Runtime.wait_for_state_change();
        return running_alive_result.get();
    }

    public static boolean any_component_alive() {
        if (TTCN_Runtime.is_single()) {
            return false;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'any component.alive' can only be performed on the MTC.");
        }
        if (all_component_killed_status == TitanAlt_Status.ALT_YES) {
            return false;
        }
        if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
            throw new TtcnError("Internal error: Executing 'any component.alive' in invalid state.");
        }
        TTCN_Communication.send_is_alive(-1);
        executorState.set(executorStateEnum.MTC_ALIVE);
        TTCN_Runtime.wait_for_state_change();
        if (!running_alive_result.get().booleanValue()) {
            all_component_killed_status = TitanAlt_Status.ALT_YES;
        }
        return running_alive_result.get();
    }

    public static boolean all_component_alive() {
        if (TTCN_Runtime.is_single()) {
            return true;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'all component.alive' can only be performed on the MTC.");
        }
        if (all_component_killed_status == TitanAlt_Status.ALT_NO) {
            return true;
        }
        if (all_component_killed_status == TitanAlt_Status.ALT_YES) {
            return false;
        }
        ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
        for (int i = 0; i < local_status_table.size(); ++i) {
            if (local_status_table.get((int)i).killed_status != TitanAlt_Status.ALT_YES) continue;
            return false;
        }
        if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
            throw new TtcnError("Internal error: Executing 'all component.alive' in invalid state.");
        }
        TTCN_Communication.send_is_alive(-2);
        executorState.set(executorStateEnum.MTC_ALIVE);
        TTCN_Runtime.wait_for_state_change();
        return running_alive_result.get();
    }

    public static void stop_mtc() {
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.stopping__mtc, null, null, 0, null, null, 0, 0);
        TTCN_Communication.send_stop_req(1);
        TTCN_Runtime.stop_execution();
    }

    public static void stop_ptc(int component_reference) {
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Stop operation on a component reference cannot be performed in single mode.");
        }
        if (TTCN_Runtime.in_component_status_table(component_reference)) {
            int index = TTCN_Runtime.get_component_status_table_index(component_reference);
            ArrayList<component_status_table_struct> local_status_table = component_status_table.get();
            component_status_table_struct tempComponent = local_status_table.get(index);
            if (tempComponent.done_status == TitanAlt_Status.ALT_YES || tempComponent.killed_status == TitanAlt_Status.ALT_YES) {
                TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("PTC with component reference {0} is not running. Stop operation had no effect.", component_reference));
                return;
            }
        }
        switch (executorState.get()) {
            case MTC_TESTCASE: {
                executorState.set(executorStateEnum.MTC_STOP);
                break;
            }
            case PTC_FUNCTION: {
                executorState.set(executorStateEnum.PTC_STOP);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing component stop operation in invalid state.");
            }
        }
        TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("Stopping PTC with component reference {0}.", component_reference));
        TTCN_Communication.send_stop_req(component_reference);
        TTCN_Runtime.wait_for_state_change();
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__stopped, null, null, component_reference, null, null, 0, 0);
    }

    public static void stop_all_component() {
        if (TTCN_Runtime.is_single()) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "No PTCs are running. Operation 'all component.stop' had no effect.");
            return;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'all component.stop' can only be performed on the MTC.");
        }
        if (all_component_done_status == TitanAlt_Status.ALT_YES || all_component_killed_status == TitanAlt_Status.ALT_YES) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "No PTCs are running. Operation 'all component.stop' had no effect.");
            return;
        }
        if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
            throw new TtcnError("Internal error: Executing 'all component.stop' in invalid state.");
        }
        executorState.set(executorStateEnum.MTC_STOP);
        TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "Stopping all components.");
        TTCN_Communication.send_stop_req(-2);
        TTCN_Runtime.wait_for_state_change();
        all_component_done_status = TitanAlt_Status.ALT_YES;
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.all__comps__stopped, null, null, 0, null, null, 0, 0);
    }

    public static void kill_ptc(int component_reference) {
        if (TTCN_Runtime.is_single()) {
            throw new TtcnError("Kill operation on a component reference cannot be performed in single mode.");
        }
        if (TTCN_Runtime.in_component_status_table(component_reference) && TTCN_Runtime.get_killed_status(component_reference) == TitanAlt_Status.ALT_YES) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("PTC with component reference {0} is not alive anyomre. Kill operation had no effect.", component_reference));
            return;
        }
        switch (executorState.get()) {
            case MTC_TESTCASE: {
                executorState.set(executorStateEnum.MTC_KILL);
                break;
            }
            case PTC_FUNCTION: {
                executorState.set(executorStateEnum.PTC_KILL);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing kill operation in invalid state.");
            }
        }
        TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("Killing PTC with component reference {0}.", component_reference));
        TTCN_Communication.send_kill_req(component_reference);
        TTCN_Runtime.wait_for_state_change();
        int index = TTCN_Runtime.get_component_status_table_index(component_reference);
        TTCN_Runtime.component_status_table.get().get((int)index).killed_status = TitanAlt_Status.ALT_YES;
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__killed, null, null, component_reference, null, null, 0, 0);
    }

    public static void kill_all_component() {
        if (TTCN_Runtime.is_single()) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "There are no alive PTCs. Operation 'all component.kill' had no effect.");
            return;
        }
        if (!TTCN_Runtime.is_mtc()) {
            throw new TtcnError("Operation 'all component.kill' can only be performed on the MTC.");
        }
        if (all_component_killed_status == TitanAlt_Status.ALT_YES) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "There are no alive PTCs. Operation 'all component.kill' had no effect.");
            return;
        }
        if (executorState.get() != executorStateEnum.MTC_TESTCASE) {
            throw new TtcnError("Internal error: Executing 'all component.kill' in invalid state.");
        }
        executorState.set(executorStateEnum.MTC_KILL);
        TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "Killing all components.");
        TTCN_Communication.send_kill_req(-2);
        TTCN_Runtime.wait_for_state_change();
        all_component_done_status = TitanAlt_Status.ALT_YES;
        all_component_killed_status = TitanAlt_Status.ALT_YES;
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.all__comps__killed, null, null, 0, null, null, 0, 0);
    }

    private static void check_port_name(String portName, String operationName, String whichArgument) {
        if (portName == null) {
            throw new TtcnError(MessageFormat.format("Internal error: The port name in the {0} argument of {1} operation is a NULL pointer.", whichArgument, operationName));
        }
        if (portName.length() == 0) {
            throw new TtcnError(MessageFormat.format("Internal error: The {0} argument of {1} operation contains an empty string as port name.", whichArgument, operationName));
        }
    }

    public static void connect_port(TitanComponent sourceComponent, String sourePort, TitanComponent destinationComponent, String destinationPort) {
        TTCN_Runtime.check_port_name(sourePort, "connect", "first");
        TTCN_Runtime.check_port_name(destinationPort, "connect", "second");
        TTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED);
        TTCN_Logger.log_event_str("Connecting ports ");
        sourceComponent.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0} and ", sourePort));
        destinationComponent.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0}.", destinationPort));
        TTCN_Logger.end_event();
        sourceComponent.must_bound("The first argument of connect operation contains an unbound component reference.");
        switch (sourceComponent.get_component()) {
            case 0: {
                throw new TtcnError("The first argument of connect operation contains the null component reference.");
            }
            case 2: {
                throw new TtcnError("The first argument of connect operation refers to a system port.");
            }
        }
        destinationComponent.must_bound("The second argument of connect operation contains an unbound component reference.");
        switch (destinationComponent.get_component()) {
            case 0: {
                throw new TtcnError("The second argument of connect operation contains the null component reference.");
            }
            case 2: {
                throw new TtcnError("The second argument of connect operation refers to a system port.");
            }
        }
        switch (executorState.get()) {
            case SINGLE_TESTCASE: {
                if (sourceComponent.get_component() != 1 || destinationComponent.get_component() != 1) {
                    throw new TtcnError("Both endpoints of connect operation must refer to ports of mtc in single mode.");
                }
                TitanPort.make_local_connection(sourePort, destinationPort);
                break;
            }
            case MTC_TESTCASE: {
                TTCN_Communication.send_connect_req(sourceComponent.get_component(), sourePort, destinationComponent.get_component(), destinationPort);
                executorState.set(executorStateEnum.MTC_CONNECT);
                TTCN_Runtime.wait_for_state_change();
                break;
            }
            case PTC_FUNCTION: {
                TTCN_Communication.send_connect_req(sourceComponent.get_component(), sourePort, destinationComponent.get_component(), destinationPort);
                executorState.set(executorStateEnum.PTC_CONNECT);
                TTCN_Runtime.wait_for_state_change();
                break;
            }
            default: {
                if (TTCN_Runtime.in_controlPart()) {
                    throw new TtcnError("Connect operation cannot be performed in the control part.");
                }
                throw new TtcnError("Internal error: Executing connect operation in invalid state.");
            }
        }
        TTCN_Logger.log_portconnmap(TitanLoggerApi.ParPort_operation.enum_type.connect__, sourceComponent.get_component(), sourePort, destinationComponent.get_component(), destinationPort);
    }

    public static void disconnect_port(TitanComponent sourceComponent, String sourePort, TitanComponent destinationComponent, String destinationPort) {
        TTCN_Runtime.check_port_name(sourePort, "disconnect", "first");
        TTCN_Runtime.check_port_name(destinationPort, "disconnect", "second");
        TTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED);
        TTCN_Logger.log_event_str("Disconnecting ports ");
        sourceComponent.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0} and ", sourePort));
        destinationComponent.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0}.", destinationPort));
        TTCN_Logger.end_event();
        sourceComponent.must_bound("The first argument of disconnect operation contains an unbound component reference.");
        switch (sourceComponent.get_component()) {
            case 0: {
                throw new TtcnError("The first argument of disconnect operation contains the null component reference.");
            }
            case 2: {
                throw new TtcnError("The first argument of disconnect operation refers to a system port.");
            }
        }
        destinationComponent.must_bound("The second argument of disconnect operation contains an unbound component reference.");
        switch (destinationComponent.get_component()) {
            case 0: {
                throw new TtcnError("The second argument of disconnect operation contains the null component reference.");
            }
            case 2: {
                throw new TtcnError("The second argument of disconnect operation refers to a system port.");
            }
        }
        switch (executorState.get()) {
            case SINGLE_TESTCASE: {
                if (sourceComponent.get_component() != 1 || destinationComponent.get_component() != 1) {
                    throw new TtcnError("Both endpoints of disconnect operation must refer to ports of mtc in single mode.");
                }
                TitanPort.terminate_local_connection(sourePort, destinationPort);
                break;
            }
            case MTC_TESTCASE: {
                TTCN_Communication.send_disconnect_req(sourceComponent.get_component(), sourePort, destinationComponent.get_component(), destinationPort);
                executorState.set(executorStateEnum.MTC_DISCONNECT);
                TTCN_Runtime.wait_for_state_change();
                break;
            }
            case PTC_FUNCTION: {
                TTCN_Communication.send_disconnect_req(sourceComponent.get_component(), sourePort, destinationComponent.get_component(), destinationPort);
                executorState.set(executorStateEnum.PTC_DISCONNECT);
                TTCN_Runtime.wait_for_state_change();
                break;
            }
            default: {
                if (TTCN_Runtime.in_controlPart()) {
                    throw new TtcnError("Disconnect operation cannot be performed in the control part.");
                }
                throw new TtcnError("Internal error: Executing disconnect operation in invalid state.");
            }
        }
        TTCN_Logger.log_portconnmap(TitanLoggerApi.ParPort_operation.enum_type.disconnect__, sourceComponent.get_component(), sourePort, destinationComponent.get_component(), destinationPort);
    }

    public static void map_port(TitanComponent sourceComponentRef, String sourePort, TitanComponent destinationComponentRef, String destinationPort, TitanPort.Map_Params params, boolean translation) {
        String systemPort;
        String componentPort;
        TitanComponent componentReference;
        TTCN_Runtime.check_port_name(sourePort, "map", "first");
        TTCN_Runtime.check_port_name(destinationPort, "map", "second");
        TTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED);
        TTCN_Logger.log_event_str("Mapping ports ");
        sourceComponentRef.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0} to ", sourePort));
        destinationComponentRef.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0}.", destinationPort));
        TTCN_Logger.end_event();
        sourceComponentRef.must_bound("The first argument of map operation contains an unbound component reference.");
        TitanComponent sourceComponent = sourceComponentRef;
        if (sourceComponent.get_component() == 0) {
            throw new TtcnError("The first argument of map operation contains the null component reference.");
        }
        destinationComponentRef.must_bound("The second argument of map operation contains an unbound component reference.");
        TitanComponent destinationComponent = destinationComponentRef;
        if (destinationComponent.get_component() == 0) {
            throw new TtcnError("The second argument of map operation contains the null component reference.");
        }
        if (sourceComponent.get_component() == 2) {
            if (destinationComponent.get_component() == 2) {
                throw new TtcnError("Both arguments of map operation refer to system ports.");
            }
            componentReference = destinationComponent;
            componentPort = destinationPort;
            systemPort = sourePort;
        } else if (destinationComponent.get_component() == 2) {
            componentReference = sourceComponent;
            componentPort = sourePort;
            systemPort = destinationPort;
        } else {
            throw new TtcnError("Both arguments of map operation refer to test component ports.");
        }
        switch (executorState.get()) {
            case SINGLE_TESTCASE: {
                if (componentReference.componentValue != 1) {
                    throw new TtcnError("Only the ports of mtc can be mapped in single mode.");
                }
                TitanPort.map_port(componentPort, systemPort, params, false);
                if (!translation) break;
                TitanPort.map_port(componentPort, systemPort, params, true);
                break;
            }
            case MTC_TESTCASE: {
                TTCN_Communication.send_map_req(componentReference.componentValue, componentPort, systemPort, params, translation);
                executorState.set(executorStateEnum.MTC_MAP);
                TTCN_Runtime.wait_for_state_change();
                params.operator_assign(TitanPort.map_params_cache.get());
                break;
            }
            case PTC_FUNCTION: {
                TTCN_Communication.send_map_req(componentReference.componentValue, componentPort, systemPort, params, translation);
                executorState.set(executorStateEnum.PTC_MAP);
                TTCN_Runtime.wait_for_state_change();
                params.operator_assign(TitanPort.map_params_cache.get());
                break;
            }
            default: {
                if (TTCN_Runtime.in_controlPart()) {
                    throw new TtcnError("Map operation cannot be performed in the control part.");
                }
                throw new TtcnError("Internal error: Executing map operation in invalid state.");
            }
        }
        TTCN_Logger.log_portconnmap(TitanLoggerApi.ParPort_operation.enum_type.map__, sourceComponentRef.componentValue, sourePort, destinationComponentRef.componentValue, destinationPort);
    }

    public static void unmap_port(TitanComponent sourceComponentRef, String sourePort, TitanComponent destinationComponentRef, String destinationPort, TitanPort.Map_Params params, boolean translation) {
        String systemPort;
        String componentPort;
        TitanComponent componentReference;
        TTCN_Runtime.check_port_name(sourePort, "unmap", "first");
        TTCN_Runtime.check_port_name(destinationPort, "unmap", "second");
        TTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED);
        TTCN_Logger.log_event_str("Unmapping ports ");
        sourceComponentRef.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0} from ", sourePort));
        destinationComponentRef.log();
        TTCN_Logger.log_event_str(MessageFormat.format(":{0}.", destinationPort));
        TTCN_Logger.end_event();
        sourceComponentRef.must_bound("The first argument of unmap operation contains an unbound component reference.");
        TitanComponent sourceComponent = sourceComponentRef;
        if (sourceComponent.get_component() == 0) {
            throw new TtcnError("The first argument of unmap operation contains the null component reference.");
        }
        destinationComponentRef.must_bound("The second argument of unmap operation contains an unbound component reference.");
        TitanComponent destinationComponent = destinationComponentRef;
        if (destinationComponent.get_component() == 0) {
            throw new TtcnError("The second argument of unmap operation contains the null component reference.");
        }
        if (sourceComponent.get_component() == 2) {
            if (destinationComponent.get_component() == 2) {
                throw new TtcnError("Both arguments of unmap operation refer to system ports.");
            }
            componentReference = destinationComponent;
            componentPort = destinationPort;
            systemPort = sourePort;
        } else if (destinationComponent.get_component() == 2) {
            componentReference = sourceComponent;
            componentPort = sourePort;
            systemPort = destinationPort;
        } else {
            throw new TtcnError("Both arguments of unmap operation refer to test component ports.");
        }
        switch (executorState.get()) {
            case SINGLE_TESTCASE: {
                if (componentReference.componentValue != 1) {
                    throw new TtcnError("Only the ports of mtc can be unmapped in single mode.");
                }
                TitanPort.unmap_port(componentPort, systemPort, params, false);
                if (!translation) break;
                TitanPort.unmap_port(componentPort, systemPort, params, true);
                break;
            }
            case MTC_TESTCASE: {
                TTCN_Communication.send_unmap_req(componentReference.componentValue, componentPort, systemPort, params, translation);
                executorState.set(executorStateEnum.MTC_UNMAP);
                TTCN_Runtime.wait_for_state_change();
                params.operator_assign(TitanPort.map_params_cache.get());
                break;
            }
            case PTC_FUNCTION: {
                TTCN_Communication.send_unmap_req(componentReference.componentValue, componentPort, systemPort, params, translation);
                executorState.set(executorStateEnum.PTC_UNMAP);
                TTCN_Runtime.wait_for_state_change();
                params.operator_assign(TitanPort.map_params_cache.get());
                break;
            }
            default: {
                if (TTCN_Runtime.in_controlPart()) {
                    throw new TtcnError("Unmap operation cannot be performed in the control part.");
                }
                throw new TtcnError("Internal error: Executing unmap operation in invalid state.");
            }
        }
        TTCN_Logger.log_portconnmap(TitanLoggerApi.ParPort_operation.enum_type.unmap__, sourceComponentRef.componentValue, sourePort, destinationComponentRef.componentValue, destinationPort);
    }

    public static void begin_controlpart(String moduleName) {
        control_module_name = moduleName;
        TTCN_Logger.log_controlpart_start_stop(moduleName, false);
    }

    public static void end_controlpart() {
        TTCN_Default.deactivate_all();
        TTCN_Default.reset_counter();
        TitanTimer.all_stop();
        TTCN_Logger.log_controlpart_start_stop(control_module_name, true);
        control_module_name = null;
    }

    public static void check_begin_testcase(boolean hasTimer, TitanFloat timerValue) {
        if (!TTCN_Runtime.in_controlPart()) {
            if (TTCN_Runtime.is_single() || TTCN_Runtime.is_mtc()) {
                throw new TtcnError(MessageFormat.format("Test case cannot be executed while another one ({0}.{1}) is running.", testcaseModuleName, testcaseDefinitionName));
            }
            if (TTCN_Runtime.is_ptc()) {
                throw new TtcnError("Test case cannot be executed on a PTC.");
            }
            throw new TtcnError("Internal error: Executing a test case in an invalid state.");
        }
        if (hasTimer && timerValue.is_less_than(0.0)) {
            throw new TtcnError(MessageFormat.format("The test case supervisor timer has negative duration ({0} s).", timerValue.get_value()));
        }
    }

    public static void begin_testcase(String moduleName, String testcaseName, String mtc_comptype_module, String mtc_comptype_name, String system_comptype_module, String system_comptype_name, boolean hasTimer, TitanFloat timerValue) {
        switch (executorState.get()) {
            case SINGLE_CONTROLPART: {
                executorState.set(executorStateEnum.SINGLE_TESTCASE);
                break;
            }
            case MTC_CONTROLPART: {
                TTCN_Communication.send_testcase_started(moduleName, testcaseName, mtc_comptype_module, mtc_comptype_name, system_comptype_module, system_comptype_name);
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Executing a test case in an invalid state.");
            }
        }
        TitanTimer.save_control_timers();
        TTCN_Default.save_control_defaults();
        TTCN_Runtime.set_testcase_name(moduleName, testcaseName);
        TTCN_Runtime.set_system_type(system_comptype_module, system_comptype_name);
        TTCN_Logger.log_testcase_started(moduleName, testcaseName);
        if (hasTimer) {
            TitanTimer.testcaseTimer.start(timerValue.get_value());
        }
        TTCN_Runtime.set_component_type(mtc_comptype_module, mtc_comptype_name);
        TTCN_Runtime.initialize_component_type();
        any_component_done_status = TitanAlt_Status.ALT_NO;
        all_component_done_status = TitanAlt_Status.ALT_YES;
        any_component_killed_status = TitanAlt_Status.ALT_NO;
        all_component_killed_status = TitanAlt_Status.ALT_YES;
        startTime.set((double)System.currentTimeMillis() / 1000.0);
    }

    public static TitanVerdictType.VerdictTypeEnum end_testcase() {
        switch (executorState.get()) {
            case MTC_CREATE: 
            case MTC_START: 
            case MTC_STOP: 
            case MTC_KILL: 
            case MTC_RUNNING: 
            case MTC_ALIVE: 
            case MTC_DONE: 
            case MTC_KILLED: 
            case MTC_CONNECT: 
            case MTC_DISCONNECT: 
            case MTC_MAP: 
            case MTC_UNMAP: {
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TESTCASE: {
                break;
            }
            case SINGLE_TESTCASE: {
                break;
            }
            default: {
                throw new TtcnError("Internal error: Ending a testcase in an invalid state.");
            }
        }
        TitanTimer.testcaseTimer.stop();
        TTCN_Runtime.terminate_component_type();
        if (executorState.get() == executorStateEnum.MTC_TESTCASE) {
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.waiting__for__ptcs__to__finish);
            TTCN_Communication.send_testcase_finished(localVerdict.get(), verdictReason.get());
            executorState.set(executorStateEnum.MTC_TERMINATING_TESTCASE);
            TTCN_Runtime.wait_for_state_change();
        } else if (executorState.get() == executorStateEnum.SINGLE_TESTCASE) {
            executorState.set(executorStateEnum.SINGLE_CONTROLPART);
        }
        TTCN_Logger.log_testcase_finished(testcaseModuleName.get(), testcaseDefinitionName.get(), localVerdict.get(), verdictReason.get());
        int n = localVerdict.get().getValue();
        verdictCount[n] = verdictCount[n] + 1;
        testcaseModuleName.set(null);
        testcaseDefinitionName.set(null);
        TTCN_Runtime.clear_component_status_table();
        any_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
        all_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
        any_component_killed_status = TitanAlt_Status.ALT_UNCHECKED;
        all_component_killed_status = TitanAlt_Status.ALT_UNCHECKED;
        TTCN_Default.restore_control_defaults();
        TitanTimer.restore_control_timers();
        TTCN_EncDec_ErrorContext.reset_all_contexts();
        startTime.set(0.0);
        if (executorState.get() == executorStateEnum.MTC_PAUSED) {
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.user__paused__waiting__to__resume);
            TTCN_Runtime.wait_for_state_change();
            if (executorState.get() != executorStateEnum.MTC_TERMINATING_EXECUTION) {
                TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.resuming__execution);
            }
        }
        if (executorState.get() == executorStateEnum.MTC_TERMINATING_EXECUTION) {
            executorState.set(executorStateEnum.MTC_CONTROLPART);
            TTCN_Logger.log_executor_runtime(TitanLoggerApi.ExecutorRuntime_reason.enum_type.terminating__execution);
            throw new TC_End();
        }
        return localVerdict.get();
    }

    public static void log_verdict_statistics() {
        int totalTestcases = verdictCount[TitanVerdictType.VerdictTypeEnum.NONE.getValue()] + verdictCount[TitanVerdictType.VerdictTypeEnum.PASS.getValue()] + verdictCount[TitanVerdictType.VerdictTypeEnum.INCONC.getValue()] + verdictCount[TitanVerdictType.VerdictTypeEnum.FAIL.getValue()] + verdictCount[TitanVerdictType.VerdictTypeEnum.ERROR.getValue()];
        TitanVerdictType.VerdictTypeEnum overallVerdict = controlErrorCount > 0 || verdictCount[TitanVerdictType.VerdictTypeEnum.ERROR.getValue()] > 0 ? TitanVerdictType.VerdictTypeEnum.ERROR : (verdictCount[TitanVerdictType.VerdictTypeEnum.FAIL.getValue()] > 0 ? TitanVerdictType.VerdictTypeEnum.FAIL : (verdictCount[TitanVerdictType.VerdictTypeEnum.INCONC.getValue()] > 0 ? TitanVerdictType.VerdictTypeEnum.INCONC : (verdictCount[TitanVerdictType.VerdictTypeEnum.PASS.getValue()] > 0 ? TitanVerdictType.VerdictTypeEnum.PASS : TitanVerdictType.VerdictTypeEnum.NONE)));
        if (totalTestcases > 0) {
            TTCN_Logger.log_verdict_statistics(verdictCount[TitanVerdictType.VerdictTypeEnum.NONE.getValue()], 100.0 * (double)verdictCount[TitanVerdictType.VerdictTypeEnum.NONE.getValue()] / (double)totalTestcases, verdictCount[TitanVerdictType.VerdictTypeEnum.PASS.getValue()], 100.0 * (double)verdictCount[TitanVerdictType.VerdictTypeEnum.PASS.getValue()] / (double)totalTestcases, verdictCount[TitanVerdictType.VerdictTypeEnum.INCONC.getValue()], 100.0 * (double)verdictCount[TitanVerdictType.VerdictTypeEnum.INCONC.getValue()] / (double)totalTestcases, verdictCount[TitanVerdictType.VerdictTypeEnum.FAIL.getValue()], 100.0 * (double)verdictCount[TitanVerdictType.VerdictTypeEnum.FAIL.getValue()] / (double)totalTestcases, verdictCount[TitanVerdictType.VerdictTypeEnum.ERROR.getValue()], 100.0 * (double)verdictCount[TitanVerdictType.VerdictTypeEnum.ERROR.getValue()] / (double)totalTestcases);
        } else {
            TTCN_Logger.log_verdict_statistics(0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0, 0, 0.0);
        }
        if (controlErrorCount > 0) {
            TTCN_Logger.log_controlpart_errors(controlErrorCount);
        }
        TTCN_Logger.log_str(TTCN_Logger.Severity.STATISTICS_VERDICT, MessageFormat.format("Test execution summary: {0} test case{1} executed. Overall verdict: {2}", totalTestcases, totalTestcases > 1 ? "s were" : " was", overallVerdict.getName()));
        TTCN_Runtime.verdictCount[TitanVerdictType.VerdictTypeEnum.NONE.getValue()] = 0;
        TTCN_Runtime.verdictCount[TitanVerdictType.VerdictTypeEnum.PASS.getValue()] = 0;
        TTCN_Runtime.verdictCount[TitanVerdictType.VerdictTypeEnum.INCONC.getValue()] = 0;
        TTCN_Runtime.verdictCount[TitanVerdictType.VerdictTypeEnum.FAIL.getValue()] = 0;
        TTCN_Runtime.verdictCount[TitanVerdictType.VerdictTypeEnum.ERROR.getValue()] = 0;
        controlErrorCount = 0;
    }

    public static void begin_action() {
        TTCN_Logger.begin_event(TTCN_Logger.Severity.ACTION_UNQUALIFIED);
        TTCN_Logger.log_event_str("Action: ");
    }

    public static void end_action() {
        TTCN_Logger.end_event();
    }

    public static void setverdict(TitanVerdictType.VerdictTypeEnum newValue) {
        TTCN_Runtime.setverdict(newValue, "");
    }

    public static void setverdict(TitanVerdictType.VerdictTypeEnum newValue, String reason) {
        if (TTCN_Runtime.verdict_enabled()) {
            if (TitanVerdictType.VerdictTypeEnum.ERROR.equals((Object)newValue)) {
                throw new TtcnError("Error verdict cannot be set explicitly.");
            }
        } else {
            if (TTCN_Runtime.in_controlPart()) {
                throw new TtcnError("Verdict cannot be set in the control part.");
            }
            throw new TtcnError("Internal error: Setting the verdict in invalid state.");
        }
        TTCN_Runtime.setverdict_internal(newValue, reason);
    }

    public static void setverdict(TitanVerdictType newValue) {
        TTCN_Runtime.setverdict(newValue, "");
    }

    public static void setverdict(TitanVerdictType newValue, String reason) {
        newValue.must_bound("The argument of setverdict operation is an unbound verdict value.");
        TTCN_Runtime.setverdict(newValue.get_value(), reason);
    }

    public static void set_error_verdict() {
        if (TTCN_Runtime.verdict_enabled()) {
            TTCN_Runtime.setverdict_internal(TitanVerdictType.VerdictTypeEnum.ERROR, "");
        } else if (TTCN_Runtime.is_single() || TTCN_Runtime.is_mtc()) {
            ++controlErrorCount;
        }
    }

    public static TitanVerdictType get_verdict() {
        if (!TTCN_Runtime.verdict_enabled()) {
            if (TTCN_Runtime.in_controlPart()) {
                throw new TtcnError("Getverdict operation cannot be performed in the control part.");
            }
            throw new TtcnError("Internal error: Performing getverdict operation in invalid state.");
        }
        TTCN_Logger.log_getverdict(localVerdict.get());
        return new TitanVerdictType(localVerdict.get());
    }

    private static void setverdict_internal(TitanVerdictType.VerdictTypeEnum newValue, String reason) {
        if (newValue.getValue() < TitanVerdictType.VerdictTypeEnum.NONE.getValue() || newValue.getValue() > TitanVerdictType.VerdictTypeEnum.ERROR.getValue()) {
            throw new TtcnError(MessageFormat.format("Internal error: setting an invalid verdict value ({0}).", newValue.getValue()));
        }
        TitanVerdictType.VerdictTypeEnum oldVerdict = localVerdict.get();
        if (localVerdict.get().getValue() < newValue.getValue()) {
            verdictReason.set(reason);
            localVerdict.set(newValue);
            if (reason == null || reason.length() == 0) {
                TTCN_Logger.log_setverdict(newValue, oldVerdict, localVerdict.get(), null, null);
            } else {
                TTCN_Logger.log_setverdict(newValue, oldVerdict, localVerdict.get(), reason, reason);
            }
        } else if (localVerdict.get().getValue() == newValue.getValue()) {
            if (reason == null || reason.length() == 0) {
                TTCN_Logger.log_setverdict(newValue, oldVerdict, localVerdict.get(), null, null);
            } else {
                TTCN_Logger.log_setverdict(newValue, oldVerdict, localVerdict.get(), reason, reason);
            }
        }
    }

    public static void process_create_mtc() {
        switch (executorState.get()) {
            case HC_ACTIVE: 
            case HC_OVERLOADED: {
                break;
            }
            default: {
                TTCN_Communication.send_error("Message CREATE_MTC arrived in invalid state.");
                return;
            }
        }
        TTCN_Logger.ring_buffer_dump(false);
        Thread MTC = new Thread(){

            @Override
            public void run() {
                TTCN_Snapshot.re_open();
                TitanComponent.self.set(new TitanComponent(1));
                executorState.set(executorStateEnum.MTC_INITIAL);
                TitanComponent.clear_component_names();
                TTCN_Logger.close_file();
                TTCN_Logger.set_start_time();
                TTCN_Runtime.mtc_main();
            }
        };
        threads.add(MTC);
        MTC.start();
        TTCN_Logger.log_mtc_created(0L);
        TTCN_Runtime.add_component(1, MTC);
        TTCN_Runtime.successful_process_creation();
    }

    public static void process_create_ptc(final int component_reference, final String component_type_module, final String component_type_name, final String system_type_module, final String system_type_name, final String par_component_name, final boolean par_is_alive, final String current_testcase_module, final String current_testcase_name, final double testcase_start_time) {
        switch (executorState.get()) {
            case HC_ACTIVE: 
            case HC_OVERLOADED: {
                break;
            }
            default: {
                TTCN_Communication.send_error("Message CREATE_PTC arrived in invalid state.");
                return;
            }
        }
        TTCN_Logger.ring_buffer_dump(false);
        Thread PTC = new Thread(){

            @Override
            public void run() {
                TTCN_Snapshot.re_open();
                TitanComponent.self.set(new TitanComponent(component_reference));
                TTCN_Runtime.set_component_type(component_type_module, component_type_name);
                TTCN_Runtime.set_system_type(system_type_module, system_type_name);
                TTCN_Runtime.set_component_name(par_component_name);
                is_alive.set(par_is_alive);
                TTCN_Runtime.set_testcase_name(current_testcase_module, current_testcase_name);
                startTime.set(testcase_start_time);
                executorState.set(executorStateEnum.PTC_INITIAL);
                TitanComponent.clear_component_names();
                TTCN_Logger.close_file();
                TTCN_Logger.set_start_time();
                TTCN_Runtime.ptc_main();
            }
        };
        if (!StringUtils.isNullOrEmpty(par_component_name)) {
            try {
                PTC.setName(par_component_name);
            }
            catch (SecurityException e) {
                throw new TtcnError(e);
            }
        }
        threads.add(PTC);
        PTC.start();
        TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__created__pid, component_type_module, component_type_name, component_reference, par_component_name, current_testcase_name, 0, 0);
        TTCN_Runtime.add_component(component_reference, PTC);
        TitanComponent.register_component_name(component_reference, par_component_name);
        TTCN_Runtime.successful_process_creation();
    }

    public static void process_create_ack(int new_component) {
        switch (executorState.get()) {
            case MTC_CREATE: {
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_CREATE: {
                executorState.set(executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message CREATE_ACK arrived in invalid state.");
            }
        }
        create_done_killed_compref.set(new_component);
    }

    public static void process_running(boolean result_value) {
        switch (executorState.get()) {
            case MTC_RUNNING: {
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_RUNNING: {
                executorState.set(executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message RUNNING arrived in invalid state.");
            }
        }
        running_alive_result.set(result_value);
    }

    public static void process_alive(boolean result_value) {
        switch (executorState.get()) {
            case MTC_ALIVE: {
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_ALIVE: {
                executorState.set(executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message ALIVE arrived in invalid state.");
            }
        }
        running_alive_result.set(result_value);
    }

    public static void process_done_ack(boolean done_status, TitanVerdictType.VerdictTypeEnum ptc_verdict, String return_type, byte[] data, int return_value_len, int buffer_begin, int return_value_begin) {
        switch (executorState.get()) {
            case MTC_DONE: {
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_DONE: {
                executorState.set(executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message DONE_ACK arrived in invalid state.");
            }
        }
        if (done_status) {
            TTCN_Runtime.set_component_done(create_done_killed_compref.get(), ptc_verdict, return_type, data, return_value_len, buffer_begin, return_value_begin);
        }
        create_done_killed_compref.set(0);
    }

    public static void process_killed_ack(boolean killed_status) {
        switch (executorState.get()) {
            case MTC_KILLED: {
                executorState.set(executorStateEnum.MTC_TESTCASE);
                break;
            }
            case MTC_TERMINATING_TESTCASE: {
                break;
            }
            case PTC_KILLED: {
                executorState.set(executorStateEnum.PTC_FUNCTION);
                break;
            }
            default: {
                throw new TtcnError("Internal error: Message KILLED_ACK arrived in invalid state.");
            }
        }
        if (killed_status) {
            TTCN_Runtime.set_component_killed(create_done_killed_compref.get());
        }
        create_done_killed_compref.set(0);
    }

    public static void process_ptc_verdict(Text_Buf text_buf) {
        boolean continueExecution;
        if (executorState.get() != executorStateEnum.MTC_TERMINATING_TESTCASE) {
            throw new TtcnError("Internal error: Message PTC_VERDICT arrived in invalid state.");
        }
        TitanVerdictType.VerdictTypeEnum localVerdictEnum = localVerdict.get();
        TTCN_Logger.log_final_verdict(false, localVerdictEnum, localVerdictEnum, localVerdictEnum, verdictReason.get(), TitanLoggerApi.FinalVerdictType_choice_notification.enum_type.setting__final__verdict__of__the__test__case.ordinal(), -3, null);
        TTCN_Logger.log_final_verdict(false, localVerdictEnum, localVerdictEnum, localVerdictEnum, verdictReason.get(), -1, -3, null);
        int n_PTCS = text_buf.pull_int().get_int();
        if (n_PTCS > 0) {
            for (int i = 0; i < n_PTCS; ++i) {
                int ptc_compref = text_buf.pull_int().get_int();
                String ptc_name = text_buf.pull_string();
                int verdictInt = text_buf.pull_int().get_int();
                String ptc_verdict_reason = text_buf.pull_string();
                if (verdictInt < TitanVerdictType.VerdictTypeEnum.NONE.ordinal() || verdictInt > TitanVerdictType.VerdictTypeEnum.ERROR.ordinal()) {
                    throw new TtcnError(MessageFormat.format("Internal error: Invalid PTC verdict was received from MC: {0}.", verdictInt));
                }
                TitanVerdictType.VerdictTypeEnum ptc_verdict = TitanVerdictType.VerdictTypeEnum.values()[verdictInt];
                TitanVerdictType.VerdictTypeEnum newVerdict = localVerdictEnum;
                if (ptc_verdict.ordinal() > localVerdictEnum.ordinal()) {
                    newVerdict = ptc_verdict;
                    verdictReason.set(ptc_verdict_reason);
                }
                TTCN_Logger.log_final_verdict(true, ptc_verdict, localVerdictEnum, newVerdict, ptc_verdict_reason, -1, ptc_compref, ptc_name);
                localVerdict.set(newVerdict);
                localVerdictEnum = newVerdict;
            }
        } else {
            TTCN_Logger.log_final_verdict(false, localVerdictEnum, localVerdictEnum, localVerdictEnum, verdictReason.get(), TitanLoggerApi.FinalVerdictType_choice_notification.enum_type.no__ptcs__were__created.ordinal(), -3, null);
        }
        boolean bl = continueExecution = text_buf.pull_int().get_int() != 0;
        if (continueExecution) {
            executorState.set(executorStateEnum.MTC_CONTROLPART);
        } else {
            executorState.set(executorStateEnum.MTC_PAUSED);
        }
    }

    public static void process_kill() {
        if (!TTCN_Runtime.is_ptc()) {
            throw new TtcnError("Internal error: Message KILL arrived in invalid state.");
        }
        switch (executorState.get()) {
            case PTC_IDLE: 
            case PTC_STOPPED: {
                TTCN_Logger.log_par_ptc(TitanLoggerApi.ParallelPTC_reason.enum_type.kill__request__frm__mc, null, null, 0, null, null, 0, 0);
                TTCN_Runtime.terminate_component_type();
                TTCN_Communication.send_killed(localVerdict.get(), verdictReason.get());
                TTCN_Logger.log_final_verdict(true, localVerdict.get(), localVerdict.get(), localVerdict.get(), verdictReason.get(), -1, -3, null);
                executorState.set(executorStateEnum.PTC_EXIT);
                break;
            }
            case PTC_EXIT: {
                break;
            }
            default: {
                TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, "Kill was requested from MC.");
                TTCN_Runtime.kill_execution();
            }
        }
    }

    public static void process_kill_process(int component_reference) {
        if (!TTCN_Runtime.is_hc()) {
            throw new TtcnError("Internal error: Message KILL_PROCESS arrived in invalid state.");
        }
        component_thread_struct comp = TTCN_Runtime.get_component_by_compref(component_reference);
        if (comp == null) {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("Component with component reference {0} does not exist. Request for killing was ignored.", component_reference));
        } else {
            TTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED, MessageFormat.format("Killing component with component reference {0}, thread id: {1}.", component_reference, comp.thread.getId()));
            if (comp.thread_killed) {
                TtcnError.TtcnWarning(MessageFormat.format("Process with process id {0} has been already killed. Killing it again.", comp.thread.getId()));
            }
            comp.thread.stop();
            comp.thread_killed = true;
        }
    }

    public static void set_component_done(int component_reference, TitanVerdictType.VerdictTypeEnum ptc_verdict, String return_type, byte[] data, int return_value_len, int buffer_begin, int return_value_begin) {
        switch (component_reference) {
            case -1: {
                if (TTCN_Runtime.is_mtc()) {
                    any_component_done_status = TitanAlt_Status.ALT_YES;
                    break;
                }
                throw new TtcnError("Internal error: TTCN_Runtime.set_component_done(ANY_COMPREF): can be used only on MTC.");
            }
            case -2: {
                if (TTCN_Runtime.is_mtc()) {
                    all_component_done_status = TitanAlt_Status.ALT_YES;
                    break;
                }
                throw new TtcnError("Internal error: TTCN_Runtime.set_component_done(ALL_COMPREF): can be used only on MTC.");
            }
            case 0: 
            case 1: 
            case 2: {
                throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.set_component_done: invalid component reference: {0}.", component_reference));
            }
            default: {
                int index = TTCN_Runtime.get_component_status_table_index(component_reference);
                component_status_table_struct temp_struct = component_status_table.get().get(index);
                temp_struct.done_status = TitanAlt_Status.ALT_YES;
                temp_struct.local_verdict = ptc_verdict;
                if (return_type != null && return_type.length() > 0) {
                    temp_struct.return_type = return_type;
                    temp_struct.return_value = new Text_Buf();
                    byte[] temp = new byte[return_value_len];
                    System.arraycopy(data, buffer_begin + return_value_begin, temp, 0, return_value_len);
                    temp_struct.return_value.push_raw(temp);
                    break;
                }
                temp_struct.return_type = null;
                temp_struct.return_value = null;
            }
        }
    }

    public static void set_component_killed(int component_reference) {
        switch (component_reference) {
            case -1: {
                if (TTCN_Runtime.is_mtc()) {
                    any_component_killed_status = TitanAlt_Status.ALT_YES;
                    break;
                }
                throw new TtcnError("Internal error: TTCN_Runtime.set_component_killed(ANY_COMPREF): can be used only on MTC.");
            }
            case -2: {
                if (TTCN_Runtime.is_mtc()) {
                    all_component_killed_status = TitanAlt_Status.ALT_YES;
                    break;
                }
                throw new TtcnError("Internal error: TTCN_Runtime.set_component_killed(ALL_COMPREF): can be used only on MTC.");
            }
            case 0: 
            case 1: 
            case 2: {
                throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.set_component_killed: invalid component reference: {0}.", component_reference));
            }
            default: {
                int index = TTCN_Runtime.get_component_status_table_index(component_reference);
                TTCN_Runtime.component_status_table.get().get((int)index).killed_status = TitanAlt_Status.ALT_YES;
            }
        }
    }

    public static void cancel_component_done(int component_reference) {
        switch (component_reference) {
            case -1: {
                if (TTCN_Runtime.is_mtc()) {
                    any_component_done_status = TitanAlt_Status.ALT_UNCHECKED;
                    break;
                }
                throw new TtcnError("Internal error: TTCN_Runtime.cancel_component_done(ANY_COMPREF): can be used only on MTC.");
            }
            case -2: 
            case 0: 
            case 1: 
            case 2: {
                throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.cancel_component_done: invalid component reference: {0}.", component_reference));
            }
            default: {
                if (!TTCN_Runtime.in_component_status_table(component_reference)) break;
                int index = TTCN_Runtime.get_component_status_table_index(component_reference);
                component_status_table_struct temp = component_status_table.get().get(index);
                temp.done_status = TitanAlt_Status.ALT_UNCHECKED;
                temp.return_type = null;
                temp.return_value = null;
            }
        }
    }

    private static int get_component_status_table_index(int component_reference) {
        if (component_reference < 3) {
            throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.get_component_status_table_index: invalid component reference: {0}.", component_reference));
        }
        ArrayList<component_status_table_struct> localTables = component_status_table.get();
        if (localTables.isEmpty()) {
            component_status_table_struct temp = new component_status_table_struct();
            temp.done_status = TitanAlt_Status.ALT_UNCHECKED;
            temp.killed_status = TitanAlt_Status.ALT_UNCHECKED;
            temp.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
            temp.return_type = null;
            temp.return_value = null;
            localTables.add(temp);
            component_status_table_offset.set(component_reference);
            return 0;
        }
        if (component_reference >= component_status_table_offset.get()) {
            int component_index = component_reference - component_status_table_offset.get();
            if (component_index >= localTables.size()) {
                localTables.ensureCapacity(component_index);
                for (int i = localTables.size(); i <= component_index; ++i) {
                    component_status_table_struct temp = new component_status_table_struct();
                    temp.done_status = TitanAlt_Status.ALT_UNCHECKED;
                    temp.killed_status = TitanAlt_Status.ALT_UNCHECKED;
                    temp.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
                    temp.return_type = null;
                    temp.return_value = null;
                    localTables.add(i, temp);
                }
            }
            return component_index;
        }
        int offset_diff = component_status_table_offset.get() - component_reference;
        ArrayList<component_status_table_struct> temp_table = new ArrayList<component_status_table_struct>(offset_diff);
        for (int i = 0; i < offset_diff; ++i) {
            component_status_table_struct temp = new component_status_table_struct();
            temp.done_status = TitanAlt_Status.ALT_UNCHECKED;
            temp.killed_status = TitanAlt_Status.ALT_UNCHECKED;
            temp.local_verdict = TitanVerdictType.VerdictTypeEnum.NONE;
            temp.return_type = null;
            temp.return_value = null;
            temp_table.add(i, temp);
        }
        localTables.addAll(0, temp_table);
        component_status_table_offset.set(component_reference);
        return 0;
    }

    private static TitanAlt_Status get_killed_status(int component_reference) {
        int index = TTCN_Runtime.get_component_status_table_index(component_reference);
        return TTCN_Runtime.component_status_table.get().get((int)index).killed_status;
    }

    private static boolean in_component_status_table(int component_reference) {
        return component_reference >= component_status_table_offset.get() && component_reference < component_status_table.get().size() + component_status_table_offset.get();
    }

    private static void clear_component_status_table() {
        component_status_table.get().clear();
        component_status_table_offset.set(3);
    }

    private static void initialize_component_process_tables() {
        components_by_compref = new HashMap(97);
        components_by_thread = new HashMap(97);
    }

    private static void add_component(int component_reference, Thread thread) {
        if (component_reference != 1 && TTCN_Runtime.get_component_by_compref(component_reference) != null) {
            throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.add_component: duplicated component reference ({0})", component_reference));
        }
        if (TTCN_Runtime.get_component_by_thread(thread) != null) {
            throw new TtcnError(MessageFormat.format("Internal error: TTCN_Runtime.add_component: duplicated thread ({0})", thread));
        }
        component_thread_struct newComp = new component_thread_struct();
        newComp.component_reference = component_reference;
        newComp.thread = thread;
        newComp.thread_killed = false;
        components_by_compref.put(component_reference, newComp);
        components_by_thread.put(thread, newComp);
    }

    private static void remove_component(component_thread_struct comp) {
        components_by_compref.remove(comp.component_reference);
        components_by_thread.remove(comp.thread);
    }

    private static component_thread_struct get_component_by_compref(int component_reference) {
        return components_by_compref.get(component_reference);
    }

    private static component_thread_struct get_component_by_thread(Thread thread) {
        return components_by_thread.get(thread);
    }

    private static void clear_component_process_tables() {
        if (components_by_compref == null) {
            return;
        }
        components_by_compref.clear();
        components_by_thread.clear();
    }

    private static void successful_process_creation() {
        if (TTCN_Runtime.is_overloaded()) {
            TTCN_Communication.send_hc_ready();
            TTCN_Communication.disable_periodic_call();
            executorState.set(executorStateEnum.HC_ACTIVE);
        }
    }

    private static void failed_process_creation() {
        if (executorState.get() == executorStateEnum.HC_ACTIVE) {
            TTCN_Communication.enable_periodic_call();
            executorState.set(executorStateEnum.HC_OVERLOADED);
        }
    }

    public static void wait_terminated_processes() {
        if (!TTCN_Runtime.is_hc()) {
            return;
        }
        int i = 0;
        while (i < threads.size()) {
            if (threads.get(i).getState() == Thread.State.TERMINATED) {
                TitanLoggerApi.ParallelPTC_reason.enum_type reason;
                Thread thread = threads.get(i);
                threads.remove(i);
                component_thread_struct comp = TTCN_Runtime.get_component_by_thread(thread);
                if (comp == null) {
                    TtcnError.TtcnWarning(MessageFormat.format("wait_terminated_processes found unknown thread {0}.", thread));
                    continue;
                }
                String componentName = null;
                if (comp.component_reference == 1) {
                    reason = TitanLoggerApi.ParallelPTC_reason.enum_type.mtc__finished;
                } else {
                    reason = TitanLoggerApi.ParallelPTC_reason.enum_type.ptc__finished;
                    componentName = TitanComponent.get_component_name(comp.component_reference);
                }
                TTCN_Logger.log_par_ptc(reason, null, null, comp.component_reference, componentName, null, 0, 0);
                TTCN_Runtime.remove_component(comp);
                continue;
            }
            ++i;
        }
    }

    static {
        threads = new ArrayList();
        translation_count = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        port = new ThreadLocal<TitanPort>(){

            @Override
            protected TitanPort initialValue() {
                return null;
            }
        };
    }

    private static class component_thread_struct {
        int component_reference;
        Thread thread;
        boolean thread_killed;

        private component_thread_struct() {
        }
    }

    private static class component_status_table_struct {
        TitanAlt_Status done_status;
        TitanAlt_Status killed_status;
        TitanVerdictType.VerdictTypeEnum local_verdict;
        String return_type;
        Text_Buf return_value;

        private component_status_table_struct() {
        }
    }

    public static enum executorStateEnum {
        UNDEFINED_STATE,
        SINGLE_CONTROLPART,
        SINGLE_TESTCASE,
        HC_INITIAL,
        HC_IDLE,
        HC_CONFIGURING,
        HC_ACTIVE,
        HC_OVERLOADED,
        HC_OVERLOADED_TIMEOUT,
        HC_EXIT,
        MTC_INITIAL,
        MTC_IDLE,
        MTC_CONTROLPART,
        MTC_TESTCASE,
        MTC_TERMINATING_TESTCASE,
        MTC_TERMINATING_EXECUTION,
        MTC_PAUSED,
        MTC_CREATE,
        MTC_START,
        MTC_STOP,
        MTC_KILL,
        MTC_RUNNING,
        MTC_ALIVE,
        MTC_DONE,
        MTC_KILLED,
        MTC_CONNECT,
        MTC_DISCONNECT,
        MTC_MAP,
        MTC_UNMAP,
        MTC_CONFIGURING,
        MTC_EXIT,
        PTC_INITIAL,
        PTC_IDLE,
        PTC_FUNCTION,
        PTC_CREATE,
        PTC_START,
        PTC_STOP,
        PTC_KILL,
        PTC_RUNNING,
        PTC_ALIVE,
        PTC_DONE,
        PTC_KILLED,
        PTC_CONNECT,
        PTC_DISCONNECT,
        PTC_MAP,
        PTC_UNMAP,
        PTC_STOPPED,
        PTC_EXIT;

    }
}

