/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.views.DetailsView;
import org.eclipse.titan.log.viewer.views.ILogViewerView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static void closeAssociatedViews(IWorkbenchPage activePage, IViewReference[] viewReferences, IResource resource) {
        switch (resource.getType()) {
            case 4: {
                ActionUtils.closeViewsForProject((IProject)resource, activePage, viewReferences);
                break;
            }
            case 1: {
                ActionUtils.closeViewsForFiles((IFile)resource, activePage, viewReferences);
                break;
            }
            case 2: {
                ActionUtils.closeViewsInclInFolder((IFolder)resource, activePage, viewReferences);
                break;
            }
        }
    }

    public static void refreshLogFileInProjectsViewer(final IFile logFile) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
                if (view instanceof CommonNavigator) {
                    CommonViewer viewer = ((CommonNavigator)view).getCommonViewer();
                    viewer.refresh((Object)logFile, true);
                    viewer.expandToLevel((Object)logFile, -1);
                }
            }
        });
    }

    private static void closeViewsForProject(IProject project, IWorkbenchPage activePage, IViewReference[] viewReferences) {
        for (IViewReference reference : viewReferences) {
            IViewPart view = reference.getView(false);
            ActionUtils.closeView(project, activePage, reference, view);
        }
    }

    private static void closeView(IProject project, IWorkbenchPage activePage, IViewReference reference, IViewPart view) {
        if (view == null) {
            activePage.hideView(reference);
            return;
        }
        if (!(view instanceof ILogViewerView)) {
            return;
        }
        ILogViewerView logViewerView = (ILogViewerView)view;
        LogFileMetaData metaData = logViewerView.getLogFileMetaData();
        if (metaData == null) {
            activePage.hideView(reference);
            return;
        }
        if (project.getName().equals(metaData.getProjectName())) {
            activePage.hideView(reference);
        }
    }

    private static void closeViewsForFiles(IFile file, IWorkbenchPage activePage, IViewReference[] viewReferences) {
        for (IViewReference reference : viewReferences) {
            ActionUtils.closeView(file, activePage, reference);
        }
        LogFileCacheHandler.clearCache(file);
    }

    private static void closeView(IFile file, IWorkbenchPage activePage, IViewReference reference) {
        IViewPart view = reference.getView(false);
        if (view == null) {
            activePage.hideView(reference);
            return;
        }
        if (!(view instanceof ILogViewerView)) {
            return;
        }
        ILogViewerView logViewerView = (ILogViewerView)view;
        LogFileMetaData metadata = logViewerView.getLogFileMetaData();
        if (metadata == null) {
            activePage.hideView(reference);
            return;
        }
        if (file.getLocationURI().equals(metadata.getFilePath())) {
            if (logViewerView instanceof DetailsView) {
                ((DetailsView)logViewerView).setData(null, false);
            }
            activePage.hideView(reference);
        }
    }

    private static void closeViewsInclInFolder(IFolder folder, IWorkbenchPage activePage, IViewReference[] viewReferences) {
        if (folder.isAccessible()) {
            try {
                IResource[] resource = folder.members();
                ActionUtils.closeViewsOfLogFiles(activePage, viewReferences, resource);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        LogFileCacheHandler.clearLogFolderCache(folder);
    }

    private static void closeViewsOfLogFiles(IWorkbenchPage activePage, IViewReference[] viewReferences, IResource[] resource) {
        for (IResource aResource : resource) {
            if (aResource instanceof IFile) {
                ActionUtils.closeViewsForFiles((IFile)aResource, activePage, viewReferences);
                continue;
            }
            if (!(aResource instanceof IFolder)) continue;
            ActionUtils.closeViewsInclInFolder((IFolder)aResource, activePage, viewReferences);
        }
    }
}

