/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.modulepar;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.modulepar.ExtractModuleParRefactoring;
import org.eclipse.titanium.refactoring.modulepar.ExtractModuleParWizard;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExtractModuleParActionFromBrowser
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.performExtractModulePar();
        return null;
    }

    public void run(IAction action) {
        this.performExtractModulePar();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void performExtractModulePar() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        Set<IProject> sourceProjs = Utils.findAllProjectsInSelection((IStructuredSelection)this.selection);
        if (sourceProjs.isEmpty()) {
            return;
        }
        IProject sourceProj = sourceProjs.iterator().next();
        StructuredSelection ssel = new StructuredSelection((Object)sourceProj);
        HashSet<IProject> projsToUpdate = new HashSet<IProject>();
        projsToUpdate.add(sourceProj);
        Utils.updateASTBeforeRefactoring(projsToUpdate, "ExtractModulePar");
        Activator.getDefault().pauseHandlingResourceChanges();
        final ExtractModuleParRefactoring refactoring = new ExtractModuleParRefactoring(sourceProj);
        ExtractModuleParWizard wiz = new ExtractModuleParWizard();
        wiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)ssel);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wiz);
        dialog.open();
        boolean saveModuleParsOption = wiz.getSaveModuleParsOption();
        IProject newProj = wiz.getProject();
        if (newProj == null) {
            ErrorReporter.logError((String)"ExtractModuleParActionFromBrowser: Wizard returned a null project. ");
            return;
        }
        refactoring.setTargetProject(newProj);
        refactoring.setOption_saveModuleParList(saveModuleParsOption);
        ProjectFileHandler pfh = new ProjectFileHandler(sourceProj);
        if (pfh.projectFileExists()) {
            IFile settingsFile = sourceProj.getFile("/.TITAN_properties");
            IFile settingsCopy = newProj.getFile("/.TITAN_properties");
            try {
                if (settingsCopy.exists()) {
                    settingsCopy.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                settingsFile.copy(settingsCopy.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                ErrorReporter.logError((String)"ExtractModuleParActionFromEditor: Copying project settings to new project failed.");
            }
        }
        WorkspaceJob job = new WorkspaceJob("ExtractModulePar: writing to target project"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                refactoring.perform();
                Activator.getDefault().resumeHandlingResourceChanges();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

