/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class TITANInstallationValidator {
    private static final String CORRECTION_STRING = "Please check that the \"TITAN installation path\" field on the Window / Preferences / TITAN preferences page is set correctly.";
    private static boolean wasChecked = false;
    private static boolean wasCorrect = false;

    private TITANInstallationValidator() {
    }

    public static boolean check(boolean forceDialog) {
        File tempFile;
        if (!forceDialog && wasChecked) {
            return wasCorrect;
        }
        final String installationPath = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", null, null);
        wasChecked = true;
        wasCorrect = true;
        if (installationPath == null || "".equals(installationPath)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InstallationErrorDialog dialog = new InstallationErrorDialog(null, "Checking for installed TITAN failed", "The installation path of TITAN is not set.\n\nPlease check that the \"TITAN installation path\" field on the Window / Preferences / TITAN preferences page is set correctly.");
                    dialog.open();
                }
            });
            wasCorrect = false;
            return false;
        }
        String compilerPath = installationPath + File.separatorChar + "bin" + File.separatorChar + "compiler";
        if ("win32".equals(Platform.getOS())) {
            compilerPath = compilerPath + ".exe";
        }
        if (!(tempFile = new File(compilerPath)).exists()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InstallationErrorDialog dialog = new InstallationErrorDialog(null, "Checking for installed TITAN failed", "No TITAN was found at " + installationPath + "\n\n" + TITANInstallationValidator.CORRECTION_STRING);
                    dialog.open();
                }
            });
            wasCorrect = false;
        }
        return wasCorrect;
    }

    public static void clear() {
        wasChecked = false;
    }

    private static class InstallationErrorDialog
    extends MessageDialog {
        public InstallationErrorDialog(Shell parent, String title, String message) {
            super(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL, "Open TITAN Preferences"}, 0);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1) {
                PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.titan.designer.preferences.pages.TITANPreferencePage", null, null).open();
            }
        }
    }
}

