/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ControlPart;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnusedLocalDefinition
extends BaseModuleCodeSmellSpotter {
    public UnusedLocalDefinition() {
        super(CodeSmellType.UNUSED_LOCAL_DEFINITION);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        HashSet<Assignment> unused = new HashSet<Assignment>();
        LocalDefinitionCheck chek = new LocalDefinitionCheck();
        node.accept((ASTVisitor)chek);
        unused.addAll(chek.getDefinitions());
        LocalUsedDefinitionCheck chekUsed = new LocalUsedDefinitionCheck();
        node.accept((ASTVisitor)chekUsed);
        unused.removeAll(chekUsed.getDefinitions());
        for (Assignment ass : unused) {
            String name = ass.getIdentifier().getDisplayName();
            String msg = MessageFormat.format("The {0} `{1}'' seems to be never used locally (new)", ass.getAssignmentName(), name);
            problems.report(ass.getIdentifier().getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(4);
        ret.add(Def_Altstep.class);
        ret.add(Def_Function.class);
        ret.add(Def_Testcase.class);
        ret.add(ControlPart.class);
        return ret;
    }

    class LocalUsedDefinitionCheck
    extends ASTVisitor {
        private final Set<Assignment> setOfDefinition = new HashSet<Assignment>();

        public LocalUsedDefinitionCheck() {
            this.setOfDefinition.clear();
        }

        public Set<Assignment> getDefinitions() {
            return this.setOfDefinition;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                if (((Reference)node).getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                    return 3;
                }
                Assignment assignment = ((Reference)node).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
                if (assignment != null && assignment.isLocal()) {
                    this.setOfDefinition.add(assignment);
                }
            }
            return 3;
        }
    }

    class LocalDefinitionCheck
    extends ASTVisitor {
        private final Set<Assignment> setOfDefinition = new HashSet<Assignment>();

        public LocalDefinitionCheck() {
            this.setOfDefinition.clear();
        }

        public Set<Assignment> getDefinitions() {
            return this.setOfDefinition;
        }

        public int visit(IVisitableNode node) {
            Assignment assignment;
            if (node instanceof Assignment && (assignment = (Assignment)node).isLocal()) {
                this.setOfDefinition.add(assignment);
            }
            return 3;
        }
    }
}

