/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Value_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Done_Statement
extends Statement {
    private static final String ANYOROMITWITHOUTMATCHINGTAMPLE = "'*' cannot be used as a matching template for a `done' operation";
    private static final String FULLNAMEPART1 = "componentreference";
    private static final String FULLNAMEPART2 = "donematch";
    private static final String FULLNAMEPART3 = "redirection";
    private static final String FULLNAMEPART4 = ".redirectIndex";
    private static final String STATEMENT_NAME = "done";
    private final Value componentreference;
    private final TemplateInstance doneMatch;
    private final Value_Redirection redirectValue;
    private final boolean isAny;
    private final boolean any_from;
    private final Reference redirectIndex;

    public Done_Statement(Value componentreference, TemplateInstance doneMatch, Value_Redirection redirectValue, boolean isAny, boolean any_from, Reference redirectIndex) {
        this.componentreference = componentreference;
        this.doneMatch = doneMatch;
        this.redirectValue = redirectValue;
        this.isAny = isAny;
        this.any_from = any_from;
        this.redirectIndex = redirectIndex;
        if (componentreference != null) {
            componentreference.setFullNameParent(this);
        }
        if (doneMatch != null) {
            doneMatch.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectIndex != null) {
            redirectIndex.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_DONE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentreference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.doneMatch == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.redirectIndex == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentreference != null) {
            this.componentreference.setMyScope(scope);
        }
        if (this.doneMatch != null) {
            this.doneMatch.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.componentreference != null) {
            this.componentreference.setCodeSection(codeSection);
        }
        if (this.doneMatch != null) {
            this.doneMatch.setCodeSection(codeSection);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setCodeSection(codeSection);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        IType referencedType = Port_Utility.checkComponentReference(timestamp, this, this.componentreference, false, false, this.any_from);
        if (this.componentreference == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if (this.doneMatch != null) {
            IType returnType = Port_Utility.getMessageSignatureType(timestamp, this.doneMatch);
            if (returnType == null) {
                this.doneMatch.getLocation().reportSemanticError("Cannot determine the return type for value returning done");
                if (this.redirectValue != null) {
                    this.redirectValue.checkErroneous(timestamp);
                }
            } else {
                IType lastType = returnType;
                boolean returnTypeCorrect = false;
                while (!returnTypeCorrect) {
                    if (lastType.hasDoneAttribute()) {
                        returnTypeCorrect = true;
                        break;
                    }
                    if (!(lastType instanceof IReferencingType)) break;
                    ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IType refd = ((IReferencingType)((Object)lastType)).getTypeRefd(timestamp, refChain);
                    refChain.release();
                    if (lastType == refd) break;
                    lastType = refd;
                }
                if (!returnTypeCorrect) {
                    this.location.reportSemanticError(MessageFormat.format("Return type `{0}'' does not have `done'' extension attibute", returnType.getTypename()));
                    returnType.setIsErroneous(true);
                }
                if (this.any_from) {
                    returnType.getTypeRefdLast(timestamp).set_needs_any_from_done();
                }
                this.doneMatch.check(timestamp, returnType);
                if (this.doneMatch.getTemplateBody().getTemplateReferencedLast(timestamp).getTemplatetype() == ITTCN3Template.Template_type.ANY_OR_OMIT) {
                    this.doneMatch.getLocation().reportSemanticError(ANYOROMITWITHOUTMATCHINGTAMPLE);
                }
                if (this.redirectValue != null) {
                    this.redirectValue.check(timestamp, returnType);
                }
            }
        } else if (this.redirectValue != null) {
            this.redirectValue.checkVerdictOnly(timestamp);
        }
        if (this.redirectIndex != null && referencedType != null) {
            referencedType = referencedType.getTypeRefdLast(timestamp);
            ArrayDimensions temp = new ArrayDimensions();
            while (referencedType.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                temp.add(((Array_Type)referencedType).getDimension());
                referencedType = ((Array_Type)referencedType).getElementType();
            }
            Done_Statement.checkIndexRedirection(timestamp, this.redirectIndex, temp, this.any_from, "component");
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectValue != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(253);
        if (this.doneMatch != null) {
            return result;
        }
        result.add(297);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentreference != null) {
            this.componentreference.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentreference.getLocation());
        }
        if (this.doneMatch != null) {
            this.doneMatch.updateSyntax(reparser, false);
            reparser.updateLocation(this.doneMatch.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectIndex.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentreference != null) {
            this.componentreference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.doneMatch != null) {
            this.doneMatch.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentreference != null && !this.componentreference.accept(v)) {
            return false;
        }
        if (this.doneMatch != null && !this.doneMatch.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        return this.redirectIndex == null || this.redirectIndex.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        aData.addBuiltinTypeImport("TitanComponent");
        if (this.componentreference != null) {
            String lastGenExpression = null;
            if (this.doneMatch != null) {
                IType t = this.doneMatch.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
                if (t == null) {
                    ErrorReporter.INTERNAL_ERROR((String)("Encountered a done with unknown governor `" + this.getFullName() + "''"));
                    return;
                }
                while (t instanceof Referenced_Type && !t.hasDoneAttribute()) {
                    ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    t = ((IReferencingType)((Object)t)).getTypeRefd(CompilationTimeStamp.getBaseTimestamp(), refChain);
                    refChain.release();
                }
                if (!t.hasDoneAttribute()) {
                    ErrorReporter.INTERNAL_ERROR((String)("Encountered a done return type without done attribute `" + this.getFullName() + "''"));
                    return;
                }
                Module t_module = t.getMyScope().getModuleScopeGen();
                if (t_module != this.myStatementBlock.getModuleScopeGen()) {
                    expression.expression.append(MessageFormat.format("{0}.", t_module.getIdentifier().getName()));
                }
                expression.expression.append("done(");
                this.componentreference.generateCodeExpression(aData, expression, true);
                expression.expression.append(", ");
                boolean hasDecodedRedirect = this.redirectValue != null && this.redirectValue.hasDecodedModifier();
                int expressionStart = expression.expression.length();
                this.doneMatch.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE, hasDecodedRedirect);
                lastGenExpression = expression.expression.substring(expressionStart);
                expression.expression.append(", ");
            } else {
                this.componentreference.generateCodeExpressionMandatory(aData, expression, true);
                expression.expression.append(".done(");
            }
            if (this.redirectValue == null) {
                expression.expression.append("null");
            } else {
                this.redirectValue.generateCode(aData, expression, this.doneMatch, lastGenExpression);
            }
            expression.expression.append(", ");
            if (this.redirectIndex == null) {
                expression.expression.append("null");
            } else {
                Done_Statement.generateCodeIndexRedirect(aData, expression, this.redirectIndex, this.getMyScope());
            }
            expression.expression.append(')');
        } else if (this.isAny) {
            expression.expression.append("TTCN_Runtime.component_done(TitanComponent.ANY_COMPREF, null)");
        } else {
            expression.expression.append("TTCN_Runtime.component_done(TitanComponent.ALL_COMPREF, null)");
        }
    }
}

