/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class DefinitionContainer
implements Iterable<Definition> {
    private final List<Definition> definitions = new CopyOnWriteArrayList<Definition>();
    private final ConcurrentHashMap<String, Definition> definitionMap = new ConcurrentHashMap();

    public ConcurrentHashMap<String, Definition> getDefinitionMap() {
        return this.definitionMap;
    }

    public void checkAll(CompilationTimeStamp timestamp) {
        for (Definition def : this.definitions) {
            def.check(timestamp);
        }
    }

    public void checkObjectMethodOverride(CompilationTimeStamp timestamp) {
        block4: for (Definition def : this.definitions) {
            String name = def.getIdentifier().getName();
            FormalParameterList fplist = Class_Type.getObjectMethodFormalParameterList(name);
            if (fplist == null) continue;
            switch (def.getAssignmentType()) {
                case A_FUNCTION_RVAL: 
                case A_EXT_FUNCTION_RVAL: {
                    Def_Function func;
                    if (def instanceof Def_Function) {
                        func = (Def_Function)def;
                        FormalParameterList funclist = func.getFormalParameterList();
                        FormalParameterList.IsIdenticalResult inres = funclist.isIdentical(timestamp, fplist);
                        if (fplist != null && funclist != null && inres != FormalParameterList.IsIdenticalResult.RES_DIFFERS && func.getType(timestamp).isIdentical(timestamp, Class_Type.getObjectMethodReturnType(name)) && !func.isAbstract()) {
                            if (inres != FormalParameterList.IsIdenticalResult.RES_NAME_DIFFERS) continue block4;
                            func.getSignatureLocation().reportSemanticWarning("One or more parameter names differ from previous definition");
                            continue block4;
                        }
                    }
                }
                case A_FUNCTION: 
                case A_FUNCTION_RTEMP: 
                case A_EXT_FUNCTION: 
                case A_EXT_FUNCTION_RTEMP: {
                    if (!(def instanceof Def_Function)) continue block4;
                    Def_Function func = (Def_Function)def;
                    func.getSignatureLocation().reportSemanticError(MessageFormat.format("The prototype of method `{0}' is not identical to that of the method inherited from the 'object' class", def.getIdentifier().getName()));
                    continue block4;
                }
            }
            def.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("`{0}' shadows a method inherited from the 'object' class", def.getDescription()));
        }
    }

    public int size() {
        return this.definitions.size();
    }

    public boolean hasDefinition(String id) {
        return this.definitionMap.containsKey(id);
    }

    public Definition getDefinition(String id) {
        return this.definitionMap.get(id);
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public boolean contains(Definition definition) {
        return this.definitions.contains(definition);
    }

    @Override
    public Iterator<Definition> iterator() {
        return this.definitions.iterator();
    }

    public void add(Definition definition) {
        this.definitions.add(definition);
        String definitionName = definition.getIdentifier().getName();
        if (this.definitionMap.containsKey(definitionName)) {
            this.definitionMap.get(definitionName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate field name `{0}'' was first declared here", definition.getIdentifier().getDisplayName()));
            definition.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate field name `{0}'' was declared here again", definition.getIdentifier().getDisplayName()));
        } else {
            this.definitionMap.put(definitionName, definition);
        }
    }

    public void checkUniqueness() {
        this.definitionMap.clear();
        for (Definition definition : this.definitions) {
            String definitionName = definition.getIdentifier().getName();
            if (this.definitionMap.containsKey(definitionName)) {
                this.definitionMap.get(definitionName).getIdentifier().getLocation().reportSingularSemanticError(MessageFormat.format("Duplicate field name `{0}'' was first declared here", definition.getIdentifier().getDisplayName()));
                definition.getIdentifier().getLocation().reportSemanticError(MessageFormat.format("Duplicate field name `{0}'' was declared here again", definition.getIdentifier().getDisplayName()));
                continue;
            }
            this.definitionMap.put(definitionName, definition);
        }
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }
}

