/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.declarationsearch.IdentifierFinderVisitor;
import org.eclipse.titan.designer.editors.EditorUtils;
import org.eclipse.titan.designer.editors.IEditorWithCarretOffset;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class GenerateDocComment
extends AbstractHandler
implements IEditorActionDelegate {
    public void run(IAction action) {
        this.generateDocComment();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.generateDocComment();
        return null;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    private void generateDocComment() {
        int offset;
        IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (targetEditor == null || !(targetEditor instanceof TTCN3Editor) && !(targetEditor instanceof TTCNPPEditor)) {
            return;
        }
        IDocument document = ((ISemanticTITANEditor)targetEditor).getDocument();
        ITextSelection selection = TextSelection.emptySelection();
        IFile file = (IFile)targetEditor.getEditorInput().getAdapter(IFile.class);
        if (selection instanceof TextSelection && !selection.isEmpty() && !((TextSelection)selection).getText().isEmpty()) {
            TextSelection tSelection = (TextSelection)selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((IEditorWithCarretOffset)targetEditor).getCarretOffset();
        }
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module module = projectSourceParser.containedModule(file);
        if (module == null) {
            return;
        }
        IdentifierFinderVisitor visitor = new IdentifierFinderVisitor(offset);
        module.accept(visitor);
        Declaration declaration = visitor.getReferencedDeclaration();
        if (declaration == null) {
            return;
        }
        ICommentable commentable = declaration.getCommentable();
        Location location = declaration.getLocation();
        if (commentable == null || commentable.hasDocumentComment() || location == null) {
            return;
        }
        String declFilePath = ((IFile)location.getFile()).getFullPath().toString();
        if (file.getFullPath().toString().equals(declFilePath) && location.containsOffset(offset)) {
            int startOffset = location.getOffset();
            StringBuilder sb = new StringBuilder();
            int realOffset = EditorUtils.getLeadingWhitespace(document, startOffset, sb);
            MultiTextEdit multiEdit = new MultiTextEdit(realOffset, 0);
            RewriteSessionEditProcessor processor = new RewriteSessionEditProcessor(document, (TextEdit)multiEdit, 3);
            String docComment = commentable.generateDocComment(sb.toString());
            multiEdit.addChild((TextEdit)new InsertEdit(realOffset, docComment));
            try {
                processor.performEdits();
                ((ISemanticTITANEditor)targetEditor).analyzeCurrentFile(file);
            }
            catch (BadLocationException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }
}

