/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetServerOptionsConverter;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;

@DataObject(generateConverter=true)
public class NetServerOptions
extends TCPSSLOptions {
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "0.0.0.0";
    public static final int DEFAULT_ACCEPT_BACKLOG = -1;
    public static final ClientAuth DEFAULT_CLIENT_AUTH = ClientAuth.NONE;
    private int port;
    private String host;
    private int acceptBacklog;
    private ClientAuth clientAuth = DEFAULT_CLIENT_AUTH;

    public NetServerOptions() {
        this.init();
    }

    public NetServerOptions(NetServerOptions other) {
        super(other);
        this.port = other.getPort();
        this.host = other.getHost();
        this.acceptBacklog = other.getAcceptBacklog();
        this.clientAuth = other.getClientAuth();
    }

    public NetServerOptions(JsonObject json) {
        super(json);
        this.init();
        NetServerOptionsConverter.fromJson(json, this);
    }

    @Override
    public NetServerOptions setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    @Override
    public NetServerOptions setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    @Override
    public NetServerOptions setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    @Override
    public NetServerOptions setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    @Override
    public NetServerOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    @Override
    public NetServerOptions setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    @Override
    public NetServerOptions setUsePooledBuffers(boolean usePooledBuffers) {
        super.setUsePooledBuffers(usePooledBuffers);
        return this;
    }

    @Override
    public NetServerOptions setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    @Override
    public NetServerOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    @Override
    public NetServerOptions setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    @Override
    public NetServerOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    @Override
    public NetServerOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (NetServerOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetServerOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (NetServerOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    public NetServerOptions setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setPfxKeyCertOptions(PfxOptions options) {
        return (NetServerOptions)super.setPfxKeyCertOptions(options);
    }

    @Override
    public NetServerOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (NetServerOptions)super.setPemKeyCertOptions(options);
    }

    @Override
    public NetServerOptions setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    @Override
    public NetServerOptions setPfxTrustOptions(PfxOptions options) {
        return (NetServerOptions)super.setPfxTrustOptions(options);
    }

    @Override
    public NetServerOptions setPemTrustOptions(PemTrustOptions options) {
        return (NetServerOptions)super.setPemTrustOptions(options);
    }

    @Override
    public NetServerOptions addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    @Override
    public NetServerOptions addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    @Override
    public NetServerOptions addCrlPath(String crlPath) throws NullPointerException {
        return (NetServerOptions)super.addCrlPath(crlPath);
    }

    @Override
    public NetServerOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (NetServerOptions)super.addCrlValue(crlValue);
    }

    public int getAcceptBacklog() {
        return this.acceptBacklog;
    }

    public NetServerOptions setAcceptBacklog(int acceptBacklog) {
        this.acceptBacklog = acceptBacklog;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetServerOptions setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port p must be in range 0 <= p <= 65535");
        }
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public NetServerOptions setHost(String host) {
        this.host = host;
        return this;
    }

    @Deprecated
    public boolean isClientAuthRequired() {
        return this.clientAuth == ClientAuth.REQUIRED;
    }

    @Deprecated
    public NetServerOptions setClientAuthRequired(boolean clientAuthRequired) {
        this.clientAuth = clientAuthRequired ? ClientAuth.REQUIRED : ClientAuth.NONE;
        return this;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public NetServerOptions setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @Override
    public NetServerOptions setLogActivity(boolean logEnabled) {
        return (NetServerOptions)super.setLogActivity(logEnabled);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetServerOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetServerOptions that = (NetServerOptions)o;
        if (this.acceptBacklog != that.acceptBacklog) {
            return false;
        }
        if (this.clientAuth != that.clientAuth) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(that.host) : that.host != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.acceptBacklog;
        result = 31 * result + this.clientAuth.hashCode();
        return result;
    }

    private void init() {
        this.port = 0;
        this.host = DEFAULT_HOST;
        this.acceptBacklog = -1;
        this.clientAuth = DEFAULT_CLIENT_AUTH;
    }
}

