/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.display;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.dltk.mod.compiler.util.Util;
import org.eclipse.dltk.mod.console.IScriptConsoleIO;
import org.eclipse.dltk.mod.console.IScriptExecResult;
import org.eclipse.dltk.mod.console.IScriptInterpreter;
import org.eclipse.dltk.mod.console.ScriptExecResult;
import org.eclipse.dltk.mod.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.mod.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.mod.debug.core.model.IScriptThread;
import org.eclipse.dltk.mod.debug.core.model.IScriptValue;
import org.eclipse.dltk.mod.debug.ui.display.Messages;
import org.eclipse.dltk.mod.internal.debug.ui.ScriptEvaluationContextManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class DebugScriptInterpreter
implements IScriptInterpreter {
    private final IViewPart part;

    public DebugScriptInterpreter(IViewPart part) {
        this.part = part;
    }

    public void addInitialListenerOperation(Runnable runnable) {
    }

    public InputStream getInitialOutputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public boolean isValid() {
        return true;
    }

    public void close() throws IOException {
    }

    public List getCompletions(String commandLine, int position) throws IOException {
        return null;
    }

    public String getDescription(String commandLine, int position) throws IOException {
        return null;
    }

    public String[] getNames(String type) throws IOException {
        return null;
    }

    public IScriptExecResult exec(String command) throws IOException {
        IScriptEvaluationResult result;
        IScriptThread thread;
        IScriptStackFrame frame = ScriptEvaluationContextManager.getEvaluationContext((IWorkbenchPart)this.part);
        if (frame != null && (thread = frame.getScriptThread()) != null && (result = thread.getEvaluationEngine().syncEvaluate(command, frame)) != null) {
            IScriptValue value = result.getValue();
            if (value != null) {
                String output = value.getDetailsString();
                if (output == null) {
                    output = Messages.DebugScriptInterpreter_null;
                }
                if (!output.endsWith("\n")) {
                    output = String.valueOf(output) + "\n";
                }
                return new ScriptExecResult(output);
            }
            StringBuffer buffer = new StringBuffer();
            String[] errors = result.getErrorMessages();
            int i = 0;
            while (i < errors.length) {
                buffer.append(errors[i]);
                buffer.append(Util.LINE_SEPARATOR);
                ++i;
            }
            if (errors.length == 0) {
                buffer.append(Messages.DebugScriptInterpreter_unknownEvaluationError);
                buffer.append(Util.LINE_SEPARATOR);
            }
            return new ScriptExecResult(buffer.toString(), true);
        }
        return new ScriptExecResult(String.valueOf(Messages.DebugScriptInterpreter_NoDebugger) + Util.LINE_SEPARATOR, true);
    }

    public int getState() {
        return 0;
    }

    public void consoleConnected(IScriptConsoleIO protocol) {
    }
}

