/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpDataTypeCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.commands.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpDataTypeCommands
extends DbgpBaseCommands
implements IDbgpDataTypeCommands {
    private static final String TYPEMAP_GET_COMMAND = "typemap_get";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NAME = "name";
    private static final String TAG_MAP = "map";
    private final Map converter = new HashMap();

    private Integer typeToInteger(String type) {
        return (Integer)this.converter.get(type);
    }

    public DbgpDataTypeCommands(IDbgpCommunicator communicator) {
        super(communicator);
        this.converter.put("bool", new Integer(0));
        this.converter.put("int", new Integer(1));
        this.converter.put("float", new Integer(2));
        this.converter.put("string", new Integer(3));
        this.converter.put("null", new Integer(4));
        this.converter.put("array", new Integer(5));
        this.converter.put("hash", new Integer(6));
        this.converter.put("object", new Integer(8));
        this.converter.put("resource", new Integer(9));
    }

    @Override
    public Map getTypeMap() throws DbgpException {
        DbgpRequest request = this.createRequest(TYPEMAP_GET_COMMAND);
        Element element = this.communicate(request);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        NodeList maps = element.getElementsByTagName(TAG_MAP);
        int i = 0;
        while (i < maps.getLength()) {
            Element map = (Element)maps.item(i);
            String type = map.getAttribute(ATTR_TYPE);
            Integer intType = this.typeToInteger(type);
            if (intType == null) {
                throw new DbgpException(Messages.DbgpDataTypeCommands_invalidTypeAttribute);
            }
            String name = map.getAttribute(ATTR_NAME);
            result.put(name, intType);
            ++i;
        }
        return result;
    }
}

