/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.core.eval;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.dltk.mod.debug.core.eval.IScriptEvaluationResult;

public class EvaluatedScriptExpression
extends PlatformObject
implements IErrorReportingExpression {
    private final IScriptEvaluationResult result;

    public static String[] getErrorMessages(IScriptEvaluationResult result) {
        if (result == null) {
            return new String[0];
        }
        String[] messages = result.getErrorMessages();
        if (messages.length > 0) {
            return messages;
        }
        DebugException exception = result.getException();
        if (exception != null) {
            return new String[]{exception.getMessage()};
        }
        return new String[0];
    }

    public EvaluatedScriptExpression(IScriptEvaluationResult result) {
        if (result == null) {
            throw new IllegalArgumentException();
        }
        this.result = result;
    }

    public String[] getErrorMessages() {
        return EvaluatedScriptExpression.getErrorMessages(this.result);
    }

    public boolean hasErrors() {
        return this.result.hasErrors();
    }

    public IDebugTarget getDebugTarget() {
        return this.result.getThread().getDebugTarget();
    }

    public String getExpressionText() {
        return this.result.getSnippet();
    }

    public IValue getValue() {
        return this.result.getValue();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public void dispose() {
    }
}

