/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.core.model;

import org.eclipse.dltk.mod.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.mod.debug.core.model.IScriptValue;

public class StringScriptType
extends AtomicScriptType {
    public StringScriptType(String name) {
        super(name);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String formatValue(IScriptValue value) {
        String string = value.getRawValue();
        if (string == null) {
            return null;
        }
        return StringScriptType.escapeString(string);
    }

    private static String escapeString(String string) {
        boolean alreadyQuoted = StringScriptType.isQuoted(string);
        boolean escapeNeed = StringScriptType.isEscapeNeeded(string, alreadyQuoted);
        if (!escapeNeed) {
            if (alreadyQuoted) {
                return string;
            }
            return String.valueOf('\"') + string + '\"';
        }
        StringBuffer escaped = new StringBuffer(string.length() + 8);
        if (!alreadyQuoted) {
            escaped.append('\"');
        }
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    escaped.append("\\\"");
                    break;
                }
                default: {
                    escaped.append(c);
                }
            }
            ++i;
        }
        if (!alreadyQuoted) {
            escaped.append('\"');
        }
        return escaped.toString();
    }

    private static boolean isQuoted(String string) {
        if (string.length() >= 2) {
            char firstChar = string.charAt(0);
            char lastChar = string.charAt(string.length() - 1);
            if (firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"') {
                return true;
            }
        }
        return false;
    }

    private static boolean isEscapeNeeded(String string, boolean isQuoted) {
        int i = 0;
        int len = string.length();
        if (isQuoted) {
            ++i;
            --len;
        }
        while (i < len) {
            if (string.charAt(i) == '\"') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

