/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.core.model;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.internal.debug.core.model.IScriptBreakpointPathMapper;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptBreakpointPathMapper
implements IScriptBreakpointPathMapper {
    private HashMap cache;
    private String mapTo;
    private IScriptProject scriptProject;
    private boolean stripSrcFolders;

    ScriptBreakpointPathMapper(IScriptProject project, String mapTo, boolean stripSrcFolders) {
        this.mapTo = mapTo;
        this.scriptProject = project;
        this.stripSrcFolders = stripSrcFolders;
        this.cache = new HashMap();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public URI map(URI uri) {
        String path = uri.getPath();
        if (this.mapTo == null || "".equals(this.mapTo)) {
            return uri;
        }
        if (this.cache.containsKey(uri)) {
            return (URI)this.cache.get(uri);
        }
        String projectPath = this.scriptProject.getProject().getLocation().toOSString();
        String outgoing = path;
        if (path.startsWith(projectPath)) {
            path = path.substring(projectPath.length() + 1);
            if (this.stripSrcFolders) {
                path = this.stripSourceFolders(path);
            }
            outgoing = String.valueOf(this.mapTo) + File.separator + path;
        }
        URI outgoingUri = ScriptLineBreakpoint.makeUri((IPath)new Path(outgoing));
        this.cache.put(uri, outgoingUri);
        return outgoingUri;
    }

    private String stripSourceFolders(String path) {
        try {
            IProjectFragment[] fragments = this.scriptProject.getProjectFragments();
            int i = 0;
            while (i < fragments.length) {
                String name;
                IProjectFragment frag = fragments[i];
                if (!frag.isExternal() && !frag.isArchive() && path.startsWith(name = frag.getElementName())) {
                    path = path.substring(name.length() + 1);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return path;
    }
}

