/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.statistics;

import java.util.concurrent.ConcurrentMap;
import org.eclipse.vjet.dsf.common.statistics.DarwinStatisticsCtx;
import org.eclipse.vjet.dsf.common.statistics.V4StatisticsContainer;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;

public class DarwinStatisticsCtxHelper {
    private static V4StatisticsContainer s_con = V4StatisticsContainer.getInstance();

    public static void countCssRef(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getCssStatistics();
            DarwinStatisticsCtxHelper.countRef(id, map);
        }
    }

    public static void countImageRef(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getImageStatistics();
            DarwinStatisticsCtxHelper.countRef(id, map);
        }
    }

    public static void countLinkRef(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getLinkStatistics();
            if (id.indexOf("/") == 0) {
                id = id.substring(1);
            }
            DarwinStatisticsCtxHelper.countRef(id, map);
        }
    }

    public static void countComponentStatistics(String cmpName) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getComponentStatistics();
            DarwinStatisticsCtxHelper.countUsage(cmpName, map);
        }
    }

    public static void countContentStatistics(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getContentStatistics();
            DarwinStatisticsCtxHelper.countUsage(id, map);
        }
    }

    public static void countJsStatistics(String cmpName) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getJavascriptStatistics();
            if (cmpName != null) {
                cmpName = String.valueOf(cmpName) + "Jsr";
            }
            DarwinStatisticsCtxHelper.countUsage(cmpName, map);
        }
    }

    public static void countCssStatistics(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getCssStatistics();
            DarwinStatisticsCtxHelper.countUsage(id, map);
        }
    }

    public static void countImageStatistics(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getImageStatistics();
            DarwinStatisticsCtxHelper.countUsage(id, map);
        }
    }

    public static void countLinkStatistics(String id) {
        if (s_con.doStatistics()) {
            ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getLinkStatistics();
            if (id.indexOf("/") == 0) {
                id = id.substring(1);
            }
            DarwinStatisticsCtxHelper.countUsage(id, map);
        }
    }

    public static void countEsfTemplateUsageStatistics(String uri) {
        ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getEsfTemplateStatistics();
        try {
            DarwinStatisticsCtxHelper.countUsageIncre1(uri, map);
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    public static void countEsfTemplateUsageFailureStatistics(String uri) {
        ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getEsfTemplateFailureStatistics();
        try {
            DarwinStatisticsCtxHelper.countUsageIncre1(uri, map);
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    public static void countEsfTemplateRefStatistics(String uri) {
        DarwinStatisticsCtx ctx = DarwinStatisticsCtx.ctx();
        ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = ctx.getEsfTemplateStatistics();
        try {
            DarwinStatisticsCtxHelper.countRefIncre1(uri, map);
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    public static void countEsfTemplateRefFailureStatistics(String uri) {
        ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getEsfTemplateFailureStatistics();
        try {
            DarwinStatisticsCtxHelper.countRefIncre1(uri, map);
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    public static void countBizMoUsageStatistics(String uri) {
        ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getBizMoStatistics();
        try {
            DarwinStatisticsCtxHelper.countUsageIncre1(uri, map);
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    public static void countBizOpUsageStatistics(String uri) {
        ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map = DarwinStatisticsCtx.ctx().getBizOpStatistics();
        try {
            DarwinStatisticsCtxHelper.countUsageIncre1(uri, map);
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    private static void countUsage(String id, ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map) {
        try {
            if (id != null && id.length() > 0) {
                DarwinStatisticsCtx.DarwinStatisticsCount old;
                DarwinStatisticsCtx.DarwinStatisticsCount count = (DarwinStatisticsCtx.DarwinStatisticsCount)map.get(id);
                if (count == null && (old = map.putIfAbsent(id, count = new DarwinStatisticsCtx.DarwinStatisticsCount())) != null) {
                    count = old;
                }
                count.incrementUsage(s_con.getIncrement());
            }
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    private static void countUsageIncre1(String uri, ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map) {
        if (uri != null && uri.length() > 0) {
            DarwinStatisticsCtx.DarwinStatisticsCount old;
            DarwinStatisticsCtx.DarwinStatisticsCount count = (DarwinStatisticsCtx.DarwinStatisticsCount)map.get(uri);
            if (count == null && (old = map.putIfAbsent(uri, count = new DarwinStatisticsCtx.DarwinStatisticsCount())) != null) {
                count = old;
            }
            count.incrementUsage(1L);
        }
    }

    private static void countRef(String id, ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map) {
        try {
            if (id != null && id.length() > 0) {
                DarwinStatisticsCtx.DarwinStatisticsCount old;
                DarwinStatisticsCtx.DarwinStatisticsCount count = (DarwinStatisticsCtx.DarwinStatisticsCount)map.get(id);
                if (count == null && (old = map.putIfAbsent(id, count = new DarwinStatisticsCtx.DarwinStatisticsCount())) != null) {
                    count = old;
                }
                count.incrementRef(s_con.getIncrement());
            }
        }
        catch (Exception ex) {
            Logger.getInstance(DarwinStatisticsCtxHelper.class).log(LogLevel.ERROR, (Throwable)ex);
        }
    }

    private static void countRefIncre1(String uri, ConcurrentMap<String, DarwinStatisticsCtx.DarwinStatisticsCount> map) {
        if (uri != null && uri.length() > 0) {
            DarwinStatisticsCtx.DarwinStatisticsCount old;
            DarwinStatisticsCtx.DarwinStatisticsCount count = (DarwinStatisticsCtx.DarwinStatisticsCount)map.get(uri);
            if (count == null && (old = map.putIfAbsent(uri, count = new DarwinStatisticsCtx.DarwinStatisticsCount())) != null) {
                count = old;
            }
            count.incrementRef(1L);
        }
    }
}

