/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.debug.ui.interpreters;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.mod.launching.LibraryLocation;

public final class LibraryStandin {
    private IPath fLibraryLocation;

    public LibraryStandin(LibraryLocation libraryLocation) {
        this.fLibraryLocation = libraryLocation.getLibraryPath();
    }

    public LibraryStandin(IPath path) {
        this.fLibraryLocation = path;
    }

    public String getLibraryPathString() {
        return EnvironmentPathUtils.getLocalPathString((IPath)this.fLibraryLocation);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LibraryStandin) {
            LibraryStandin lib = (LibraryStandin)obj;
            return this.fLibraryLocation.equals((Object)lib.fLibraryLocation);
        }
        return false;
    }

    public int hashCode() {
        return this.fLibraryLocation.hashCode();
    }

    protected boolean equals(IPath path1, IPath path2) {
        return this.equalsOrNull(path1, path2);
    }

    private boolean equalsOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public LibraryLocation toLibraryLocation() {
        return new LibraryLocation(this.fLibraryLocation);
    }

    public IStatus validate() {
        IFileHandle f = EnvironmentPathUtils.getFile((IPath)this.fLibraryLocation);
        if (!f.exists()) {
            return new Status(4, "org.eclipse.dltk.mod.debug.ui", 0, MessageFormat.format(InterpretersMessages.LibraryStandin_0, f.toString()), null);
        }
        return Status.OK_STATUS;
    }
}

