/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleDeclaration;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class DCssStyleRule
extends DCssRule
implements CSSStyleRule,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private SelectorList m_selectors = null;
    private CSSStyleDeclaration m_style = null;

    public DCssStyleRule(CSSStyleSheet parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.m_selectors = selectors;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public String getCssText() {
        return String.valueOf(this.getSelectorText()) + " " + this.getStyle().toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 1) {
                throw new DCssException(13, 4);
            }
            this.m_selectors = ((DCssStyleRule)r).m_selectors;
            this.m_style = ((DCssStyleRule)r).m_style;
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.m_parentRule;
    }

    @Override
    public String getSelectorText() {
        return this.m_selectors.toString();
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(selectorText));
            DCssBuilder parser = new DCssBuilder();
            this.m_selectors = parser.parseSelectors(is);
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return this.m_style;
    }

    public CSSStyleRule setStyle(CSSStyleDeclaration style) {
        this.m_style = style;
        return this;
    }

    public String toString() {
        return this.getCssText();
    }

    public SelectorList getSelectors() {
        return this.m_selectors;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DCssStyleRule clone = (DCssStyleRule)super.clone();
        clone.m_style = (CSSStyleDeclaration)((DCssStyleDeclaration)this.m_style).clone();
        return clone;
    }
}

