/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.trace.IDsfInstrumenter;
import org.eclipse.vjet.dsf.common.trace.IInstrumentDElement;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DElement;
import org.w3c.dom.Node;

public class DefaultInstrumenter
implements IDsfInstrumenter {
    private List<IInstrumentDElement> m_instrumentationHandlers;

    @Override
    public boolean addInstrumenter(IInstrumentDElement handler) {
        if (this.m_instrumentationHandlers == null) {
            this.m_instrumentationHandlers = new ArrayList<IInstrumentDElement>(1);
            return this.m_instrumentationHandlers.add(handler);
        }
        if (!this.m_instrumentationHandlers.contains(handler)) {
            return this.m_instrumentationHandlers.add(handler);
        }
        return false;
    }

    @Override
    public void resetInstrumenter() {
        this.m_instrumentationHandlers = null;
    }

    public boolean hasHandler() {
        return this.m_instrumentationHandlers != null;
    }

    @Override
    public void runStartInstrumenters(DElement component, IXmlStreamWriter writer) {
        if (!this.hasHandler()) {
            return;
        }
        int i = 0;
        while (i < this.m_instrumentationHandlers.size()) {
            this.m_instrumentationHandlers.get(i).startElement(component, writer);
            ++i;
        }
    }

    @Override
    public void runEndInstrumenters(DElement component, IXmlStreamWriter writer) {
        if (!this.hasHandler()) {
            return;
        }
        int i = 0;
        while (i < this.m_instrumentationHandlers.size()) {
            this.m_instrumentationHandlers.get(i).endElement(component, writer);
            ++i;
        }
    }

    @Override
    public void runStartSelfRenderInstrumenters(DElement component, IXmlStreamWriter writer) {
        if (!this.hasHandler()) {
            return;
        }
        int i = 0;
        while (i < this.m_instrumentationHandlers.size()) {
            this.m_instrumentationHandlers.get(i).startSelfRender(component, writer);
            ++i;
        }
    }

    @Override
    public void runEndSelfRenderInstrumenters(DElement component, IXmlStreamWriter writer) {
        if (!this.hasHandler()) {
            return;
        }
        int i = 0;
        while (i < this.m_instrumentationHandlers.size()) {
            this.m_instrumentationHandlers.get(i).endSelfRender(component, writer);
            ++i;
        }
    }

    @Override
    public void runAppendInstrumenters(Node parent, Node component) {
        if (!this.hasHandler()) {
            return;
        }
        int i = 0;
        while (i < this.m_instrumentationHandlers.size()) {
            this.m_instrumentationHandlers.get(i).appendElement(parent, component);
            ++i;
        }
    }

    @Override
    public void runAttributeInstrumenters(DElement component, DAttr attr, String value) {
        if (!this.hasHandler()) {
            return;
        }
        int i = 0;
        while (i < this.m_instrumentationHandlers.size()) {
            this.m_instrumentationHandlers.get(i).setAttributeValue(component, attr, value);
            ++i;
        }
    }

    @Override
    public boolean hasInstrumenter(Class clz) {
        if (!this.hasHandler()) {
            return false;
        }
        for (IInstrumentDElement instrumenter : this.m_instrumentationHandlers) {
            if (!instrumenter.getClass().equals(clz)) continue;
            return true;
        }
        return false;
    }
}

