/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.debug.core.ScriptDebugManager;
import org.eclipse.dltk.mod.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.mod.debug.core.model.IScriptExceptionBreakpoint;
import org.eclipse.dltk.mod.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.mod.debug.ui.actions.AddExceptionTypeDialogExtension;
import org.eclipse.dltk.mod.debug.ui.actions.Messages;
import org.eclipse.dltk.mod.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.mod.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AddExceptionAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String CAUGHT_CHECKED = "caughtChecked";
    public static final String UNCAUGHT_CHECKED = "uncaughtChecked";
    public static final String DIALOG_SETTINGS = "AddExceptionDialog";
    private IDLTKUILanguageToolkit fToolkit;

    public void run(IAction action) {
        Object[] types;
        String natureId = ScriptDebugManager.getInstance().getNatureByDebugModel(this.getDebugModelId());
        this.fToolkit = DLTKUILanguageManager.getLanguageToolkit((String)natureId);
        IDialogSettings settings = this.getDialogSettings();
        AddExceptionTypeDialogExtension ext = new AddExceptionTypeDialogExtension(null, settings.getBoolean(CAUGHT_CHECKED), settings.getBoolean(UNCAUGHT_CHECKED));
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(DLTKUIPlugin.getActiveWorkbenchShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit.getCoreToolkit()), 0, (TypeSelectionExtension)ext, this.fToolkit);
        dialog.setMessage(Messages.AddExceptionAction_search);
        dialog.setTitle(Messages.AddExceptionAction_addExceptionBreakpoint);
        if (dialog.open() == 0 && (types = dialog.getResult()) != null && types.length > 0) {
            boolean caught = ext.shouldHandleCaughtExceptions();
            boolean uncaught = ext.shouldHandleUncaughtExceptions();
            Object[] results = dialog.getResult();
            if (results != null && results.length > 0) {
                try {
                    this.createBreakpoint(caught, uncaught, (IType)results[0]);
                    settings.put(CAUGHT_CHECKED, caught);
                    settings.put(UNCAUGHT_CHECKED, uncaught);
                }
                catch (CoreException e) {
                    DLTKDebugUIPlugin.errorDialog(Messages.AddExceptionAction_unableToCreateBreakpoint, e.getStatus());
                }
            }
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings allSetttings = DLTKDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = allSetttings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = allSetttings.addNewSection(DIALOG_SETTINGS);
            section.put(CAUGHT_CHECKED, true);
            section.put(UNCAUGHT_CHECKED, true);
        }
        return section;
    }

    private void createBreakpoint(final boolean caught, final boolean uncaught, final IType type) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getDebugModelId());
        boolean exists = false;
        int j = 0;
        while (j < breakpoints.length) {
            IScriptExceptionBreakpoint exceptBreak;
            IScriptBreakpoint breakpoint = (IScriptBreakpoint)breakpoints[j];
            if (breakpoint instanceof IScriptExceptionBreakpoint && (exceptBreak = (IScriptExceptionBreakpoint)breakpoint).getTypeName().equals(type.getFullyQualifiedName())) {
                exists = true;
                break;
            }
            ++j;
        }
        if (!exists) {
            new Job(Messages.AddExceptionAction_scriptToggleExceptionBreakpoint){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        BreakpointUtils.addExceptionBreakpoint(AddExceptionAction.this.getDebugModelId(), caught, uncaught, type);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
            }.schedule();
        }
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    protected abstract String getDebugModelId();
}

