/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.mod.debug.ui.actions.ActionMessages;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class BreakpointToggleAction
implements IObjectActionDelegate,
IBreakpointsListener,
IPartListener {
    private IStructuredSelection fSelection;
    private IAction fAction;
    private IWorkbenchPart fPart;

    public void run(IAction action) {
        IStructuredSelection selection = this.getStructuredSelection();
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            try {
                IScriptBreakpoint breakpoint = (IScriptBreakpoint)itr.next();
                this.doAction(breakpoint);
            }
            catch (CoreException e) {
                String title = ActionMessages.BreakpointAction_Breakpoint_configuration_1;
                String message = ActionMessages.BreakpointAction_Exceptions_occurred_attempting_to_modify_breakpoint__2;
                ExceptionHandler.handle((CoreException)e, (String)title, (String)message);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
        if (selection.isEmpty()) {
            this.setStructuredSelection(null);
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IBreakpoint breakpoint;
            this.setStructuredSelection((IStructuredSelection)selection);
            boolean enabled = this.isEnabledFor(this.getStructuredSelection());
            action.setEnabled(enabled);
            if (enabled && this.isToggleAction() && (breakpoint = (IBreakpoint)this.getStructuredSelection().getFirstElement()) instanceof IScriptBreakpoint) {
                try {
                    action.setChecked(this.getToggleState((IScriptBreakpoint)breakpoint));
                }
                catch (CoreException e) {
                    DLTKDebugPlugin.log((Throwable)e);
                }
            }
        }
    }

    protected boolean isToggleAction() {
        return true;
    }

    public abstract void doAction(IScriptBreakpoint var1) throws CoreException;

    protected abstract boolean getToggleState(IScriptBreakpoint var1) throws CoreException;

    protected IStructuredSelection getStructuredSelection() {
        return this.fSelection;
    }

    protected void setStructuredSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public abstract boolean isEnabledFor(IStructuredSelection var1);

    protected IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return this.getBreakpointManager().getBreakpoint(marker);
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        IStructuredSelection selection;
        if (this.getAction() != null && (selection = this.getStructuredSelection()) != null) {
            IBreakpoint selectedBreakpoint = (IBreakpoint)selection.getFirstElement();
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (selectedBreakpoint.equals(breakpoint)) {
                    this.selectionChanged(this.getAction(), (ISelection)selection);
                    return;
                }
                ++i;
            }
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    protected IWorkbenchPart getPart() {
        return this.fPart;
    }

    protected void setPart(IWorkbenchPart part) {
        this.fPart = part;
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getPart()) {
            this.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
            part.getSite().getPage().removePartListener((IPartListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        IWorkbenchPart oldPart = this.getPart();
        if (oldPart != null) {
            this.getPart().getSite().getPage().removePartListener((IPartListener)this);
        }
        this.getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        this.setPart(targetPart);
        targetPart.getSite().getPage().addPartListener((IPartListener)this);
    }
}

