/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.display;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.mod.compiler.util.Util;
import org.eclipse.dltk.mod.console.IScriptConsoleIO;
import org.eclipse.dltk.mod.console.IScriptExecResult;
import org.eclipse.dltk.mod.console.IScriptInterpreter;
import org.eclipse.dltk.mod.console.ScriptExecResult;
import org.eclipse.dltk.mod.debug.ui.display.Messages;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;

public class JDTScriptInterpreterAdapter
implements IScriptInterpreter,
IEvaluationListener {
    private IJavaStackFrame m_javaStackFrame;
    private IEvaluationResult m_jdtResult;

    public void addInitialListenerOperation(Runnable runnable) {
    }

    public InputStream getInitialOutputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public boolean isValid() {
        return true;
    }

    public void close() throws IOException {
    }

    public List getCompletions(String commandLine, int position) throws IOException {
        return null;
    }

    public String getDescription(String commandLine, int position) throws IOException {
        return null;
    }

    public String[] getNames(String type) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptExecResult exec(String command) throws IOException {
        IProject project = LaunchConfigurationUtils.getProject((ILaunchConfiguration)this.m_javaStackFrame.getLaunch().getLaunchConfiguration());
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IAstEvaluationEngine evaluationEngine = JDIDebugPlugin.getDefault().getEvaluationEngine(javaProject, (IJavaDebugTarget)this.m_javaStackFrame.getDebugTarget());
        boolean hitBreakpoints = JDIDebugModel.getPreferences().getBoolean(JDIDebugModel.PREF_SUSPEND_FOR_BREAKPOINTS_DURING_EVALUATION);
        try {
            evaluationEngine.evaluate(command, this.m_javaStackFrame, (IEvaluationListener)this, 64, hitBreakpoints);
            JDTScriptInterpreterAdapter jDTScriptInterpreterAdapter = this;
            synchronized (jDTScriptInterpreterAdapter) {
                this.wait();
                return this.getResult();
            }
        }
        catch (Exception e) {
            return new ScriptExecResult(String.valueOf(e.getLocalizedMessage()) + Util.LINE_SEPARATOR, true);
        }
    }

    private IScriptExecResult getResult() throws DebugException {
        IJavaValue value = this.m_jdtResult.getValue();
        if (this.m_jdtResult == null) {
            return new ScriptExecResult(String.valueOf(Messages.DebugScriptInterpreter_NoDebugger) + Util.LINE_SEPARATOR, true);
        }
        if (value != null) {
            String output = MessageFormat.format(Messages.JDTScriptInterpreterAdapter_ValuePattern, value.getReferenceTypeName(), value.getValueString());
            if (output == null) {
                output = Messages.DebugScriptInterpreter_null;
            }
            if (!output.endsWith(Util.LINE_SEPARATOR)) {
                output = String.valueOf(output) + Util.LINE_SEPARATOR;
            }
            return new ScriptExecResult(output);
        }
        StringBuffer buffer = new StringBuffer();
        String[] errors = this.m_jdtResult.getErrorMessages();
        int i = 0;
        while (i < errors.length) {
            buffer.append(errors[i]);
            buffer.append(Util.LINE_SEPARATOR);
            ++i;
        }
        if (errors.length == 0) {
            buffer.append(Messages.DebugScriptInterpreter_unknownEvaluationError);
            buffer.append(Util.LINE_SEPARATOR);
        }
        return new ScriptExecResult(buffer.toString(), true);
    }

    public int getState() {
        return 0;
    }

    public void consoleConnected(IScriptConsoleIO protocol) {
    }

    public IJavaStackFrame getStackFrame() {
        return this.m_javaStackFrame;
    }

    public void setStackFrame(IJavaStackFrame javaStackFrame) {
        this.m_javaStackFrame = javaStackFrame;
    }

    public synchronized void evaluationComplete(IEvaluationResult result) {
        this.m_jdtResult = result;
        this.notify();
    }
}

