/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.mod.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.mod.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;

public class UnincludeOperation
extends BuildpathModifierOperation {
    public UnincludeOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Uninclude_tooltip, 9);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List elements = this.getSelectedElements();
            IScriptProject project = this.fInformationProvider.getScriptProject();
            result = this.unInclude(elements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        if (types.length == 0) {
            return false;
        }
        int i = 0;
        while (i < types.length) {
            int type = types[i];
            if (type != 10 && type != 11) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getDescription(int type) {
        if (type == 3 || type == 11) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_UnincludeFolder;
        }
        if (type == 4 || type == 10) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_UnincludeFile;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Uninclude;
    }
}

