/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.editor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.environment.EnvironmentManager;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.internal.core.BuiltinSourceModule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;

public class ExternalStorageEditorInput
extends PlatformObject
implements IEditorInput,
IStorageEditorInput,
ILocationProvider {
    private String m_name;
    private IStorage fStorage;

    public ExternalStorageEditorInput(IStorage storage) {
        this.fStorage = storage;
    }

    public boolean exists() {
        return this.fStorage != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.fStorage.getName());
    }

    public String getName() {
        if (this.m_name == null && this.fStorage != null) {
            this.m_name = this.fStorage.getName();
        }
        return this.m_name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        IEnvironment environment;
        IPath path = this.fStorage.getFullPath();
        if (path == null) {
            return "";
        }
        if (this.fStorage instanceof IModelElement && (environment = EnvironmentManager.getEnvironment((IModelElement)((IModelElement)this.fStorage))) != null) {
            return environment.convertPathToString(path);
        }
        return path.toOSString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (!(this.fStorage instanceof BuiltinSourceModule || adapter != ((Object)((Object)this)).getClass() && adapter != ILocationProvider.class)) {
            return this;
        }
        if (adapter.isAssignableFrom(this.fStorage.getClass())) {
            return this.fStorage;
        }
        if (adapter == IModelElement.class && this.fStorage instanceof IModelElement) {
            return this.fStorage;
        }
        return super.getAdapter(adapter);
    }

    public IStorage getStorage() {
        return this.fStorage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalStorageEditorInput)) {
            return false;
        }
        ExternalStorageEditorInput other = (ExternalStorageEditorInput)((Object)obj);
        boolean flag = this.fStorage.equals(other.fStorage);
        if (flag) {
            return true;
        }
        IPath fullPath = this.fStorage.getFullPath();
        if (fullPath != null) {
            return fullPath.equals((Object)other.fStorage.getFullPath());
        }
        return false;
    }

    public int hashCode() {
        return this.fStorage.hashCode();
    }

    public IPath getPath(Object element) {
        return this.fStorage.getFullPath();
    }
}

