/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.viewsupport;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SelectionProviderMediator
implements IPostSelectionProvider {
    private StructuredViewer[] fViewers;
    private StructuredViewer fViewerInFocus;
    private ListenerList fSelectionChangedListeners;
    private ListenerList fPostSelectionChangedListeners;

    public SelectionProviderMediator(StructuredViewer[] viewers, StructuredViewer viewerInFocus) {
        this.fViewers = viewers;
        InternalListener listener = new InternalListener();
        this.fSelectionChangedListeners = new ListenerList();
        this.fPostSelectionChangedListeners = new ListenerList();
        this.fViewerInFocus = viewerInFocus;
        int i = 0;
        while (i < this.fViewers.length) {
            StructuredViewer viewer = this.fViewers[i];
            viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
            viewer.addPostSelectionChangedListener((ISelectionChangedListener)new InternalPostSelectionListener());
            Control control = viewer.getControl();
            control.addFocusListener((FocusListener)listener);
            ++i;
        }
    }

    private void doFocusChanged(Widget control) {
        int i = 0;
        while (i < this.fViewers.length) {
            if (this.fViewers[i].getControl() == control) {
                this.propagateFocusChanged(this.fViewers[i]);
                return;
            }
            ++i;
        }
    }

    final void doPostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.firePostSelectionChanged();
        }
    }

    final void doSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.fireSelectionChanged();
        }
    }

    final void propagateFocusChanged(StructuredViewer viewer) {
        if (viewer != this.fViewerInFocus) {
            this.fViewerInFocus = viewer;
            this.fireSelectionChanged();
            this.firePostSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] listeners = this.fSelectionChangedListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }

    private void firePostSelectionChanged() {
        if (this.fPostSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] listeners = this.fPostSelectionChangedListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.fViewerInFocus != null) {
            return this.fViewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(selection);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(selection, reveal);
        }
    }

    public StructuredViewer getViewerInFocus() {
        return this.fViewerInFocus;
    }

    private class InternalListener
    implements ISelectionChangedListener,
    FocusListener {
        private InternalListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doSelectionChanged(event);
        }

        public void focusGained(FocusEvent e) {
            SelectionProviderMediator.this.doFocusChanged(e.widget);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class InternalPostSelectionListener
    implements ISelectionChangedListener {
        private InternalPostSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doPostSelectionChanged(event);
        }
    }
}

