/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.internal.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.validators.core.IValidator;
import org.eclipse.dltk.mod.validators.core.ValidatorRuntime;
import org.eclipse.dltk.mod.validators.internal.core.ValidatorDefinitionsContainer;
import org.eclipse.dltk.mod.validators.internal.ui.ValidatorMessages;
import org.eclipse.dltk.mod.validators.internal.ui.ValidatorsUI;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ValidatorUpdater {
    public boolean updateValidatorSettings(IValidator[] validators) {
        ValidatorDefinitionsContainer container = new ValidatorDefinitionsContainer();
        container.addValidators(validators);
        this.saveValidatorDefinitions(container);
        return true;
    }

    private void saveValidatorDefinitions(final ValidatorDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Loose catch block
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(ValidatorMessages.ValidatorUpdater_0, 100);
                        String xml = container.getAsXML();
                        monitor.worked(40);
                        ValidatorRuntime.getPreferences().setValue("org.eclipse.dltk.mod.validators.core.PREF_VALIDATOR_XML", xml);
                        monitor.worked(30);
                        ValidatorRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        ValidatorsUI.log(ioe);
                        monitor.done();
                    }
                    catch (ParserConfigurationException e) {
                        ValidatorsUI.log(e);
                        monitor.done();
                    }
                    catch (TransformerException e) {
                        ValidatorsUI.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            ValidatorsUI.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            ValidatorsUI.log(e);
        }
        catch (InterruptedException e) {
            ValidatorsUI.log(e);
        }
    }
}

