/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.commands;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.VJETPluginClassloader;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.WorkspaceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ClassloaderUtils {
    private static final String ORG_ECLIPSE_VJET_ECLIPSE_JAVATOJS_UI = "org.eclipse.vjet.eclipse.javatojs.core";
    private static volatile ClassLoaderRegistry m_registry = new ClassLoaderRegistry();

    public static Object getWorkspaceObject(String workspaceClassNameWithPackage, IProject ... additionalProjectList) {
        if (additionalProjectList.length != 0) {
            ClassloaderUtils.addProjectsToClassLoader(additionalProjectList);
        }
        VJETPluginClassloader classLoader = ClassloaderUtils.getDefaultClassLoader();
        return ClassloaderUtils.getWorkspaceObject(workspaceClassNameWithPackage, classLoader);
    }

    public static URL[] getProjectDependencyUrls(List<IJavaProject> javaProjectList, List<URL> currentUrlList, HashMap<String, String> projectMap) throws JavaModelException, MalformedURLException {
        List<URL> projectDependencyUrlList = currentUrlList;
        if (projectDependencyUrlList == null) {
            projectDependencyUrlList = new ArrayList<URL>();
        }
        for (IJavaProject project : javaProjectList) {
            IClasspathEntry[] entries;
            if (projectMap.containsKey(project.getElementName())) continue;
            projectMap.put(project.getElementName(), project.getElementName());
            IClasspathEntry[] iClasspathEntryArray = entries = project.getResolvedClasspath(true);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                File f = path.toFile();
                URL entryUrl = f.toURL();
                switch (entry.getEntryKind()) {
                    case 1: {
                        if (projectDependencyUrlList.contains(entryUrl)) break;
                        projectDependencyUrlList.add(entryUrl);
                        break;
                    }
                    case 2: {
                        IProject subProject;
                        IJavaProject subJavaProject;
                        ArrayList<IJavaProject> subjavaProjectList = new ArrayList<IJavaProject>();
                        IResource subResource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath());
                        if (subResource == null) {
                            entry.getPath().toString();
                            project.getElementName();
                        }
                        if (subResource.getType() != 4 || (subJavaProject = JavaCore.create((IProject)(subProject = (IProject)subResource))) == null || !subJavaProject.exists()) break;
                        subjavaProjectList.add(subJavaProject);
                        ClassloaderUtils.getProjectDependencyUrls(subjavaProjectList, projectDependencyUrlList, projectMap);
                        break;
                    }
                }
                ++n2;
            }
            IPath path = project.getOutputLocation();
            IPath projectResourceLocation = project.getResource().getLocation();
            File projectFilePath = projectResourceLocation.append(path.removeFirstSegments(1)).toFile();
            URL projectOutputUrl = projectFilePath.toURL();
            if (projectDependencyUrlList.contains(projectOutputUrl)) continue;
            projectDependencyUrlList.add(projectOutputUrl);
        }
        URL[] arrayList = new URL[projectDependencyUrlList.size()];
        URL[] returnURLArray = projectDependencyUrlList.toArray(arrayList);
        return returnURLArray;
    }

    public static VJETPluginClassloader getDefaultClassLoader() {
        return ClassloaderUtils.findClassLoaderByKey(ClassLoaderKey.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VJETPluginClassloader findClassLoaderByKey(ClassLoaderKey key) {
        ClassLoaderRegistry classLoaderRegistry = m_registry;
        synchronized (classLoaderRegistry) {
            VJETPluginClassloader cl = m_registry.get((Object)key);
            if (cl == null) {
                cl = ClassloaderUtils.createClassLoader(key);
                m_registry.register(key, cl);
            }
            return cl;
        }
    }

    private static VJETPluginClassloader createClassLoader(ClassLoaderKey key) {
        try {
            URL[] classloaderUrls = null;
            ArrayList<String> classPath = new ArrayList<String>();
            HashSet<String> visitedBundles = new HashSet<String>();
            Bundle bundle = Platform.getBundle((String)ORG_ECLIPSE_VJET_ECLIPSE_JAVATOJS_UI);
            visitedBundles.add(ORG_ECLIPSE_VJET_ECLIPSE_JAVATOJS_UI);
            ClassloaderUtils.extractClassPath(bundle, classPath, visitedBundles);
            ArrayList<URL> classList = new ArrayList<URL>();
            for (String path : classPath) {
                classList.add(new File(path).toURL());
            }
            classloaderUrls = classList.toArray(new URL[classList.size()]);
            return ClassloaderUtils.createEclipseClassLoader(classloaderUrls);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void extractClassPath(Bundle bundle, List<String> classPath, Set<String> visitedBundles) {
        int iter;
        String baseLoc = ClassloaderUtils.getLocation(bundle);
        Dictionary dic = bundle.getHeaders();
        if (baseLoc.endsWith("jar")) {
            classPath.add(baseLoc);
        } else {
            classPath.add(String.valueOf(baseLoc) + File.separatorChar + "bin");
            try {
                ManifestElement[] cp = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)dic.get("Bundle-ClassPath")));
                iter = 0;
                while (cp != null && iter < cp.length) {
                    classPath.add(String.valueOf(baseLoc) + File.separatorChar + cp[iter].getValue());
                    ++iter;
                }
            }
            catch (BundleException be) {
                be.printStackTrace();
            }
        }
        try {
            ManifestElement[] mfEls = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)dic.get("Require-Bundle")));
            iter = 0;
            while (mfEls != null && iter < mfEls.length) {
                Bundle bundle2;
                String bundleName = mfEls[iter].getValue();
                if (!visitedBundles.contains(bundleName) && (bundle2 = Platform.getBundle((String)bundleName)) != null) {
                    visitedBundles.add(bundleName);
                    ClassloaderUtils.extractClassPath(bundle2, classPath, visitedBundles);
                }
                ++iter;
            }
        }
        catch (BundleException bundleException) {}
    }

    private static String getLocation(Bundle bundle) {
        String location = bundle.getLocation();
        int tempIndex = (location = location.substring(location.indexOf("@") + 1)).indexOf("reference:file:");
        if (tempIndex > -1) {
            location = location.substring(location.indexOf("file:") + 5);
        }
        if (!new File(location).isAbsolute()) {
            location = new File(Platform.getInstallLocation().getURL().getFile(), location).getAbsolutePath();
        }
        return location;
    }

    private static VJETPluginClassloader createEclipseClassLoader(URL[] urls) {
        ClassLoader eclipse = VJETPluginClassloader.class.getClassLoader();
        VJETPluginClassloader classLoader = null;
        try {
            classLoader = new VJETPluginClassloader(urls, eclipse);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {}
        return classLoader;
    }

    private static Object getWorkspaceObject(String workspaceClassNameWithPackage, VJETPluginClassloader classLoader) {
        if (classLoader == null) {
            return null;
        }
        Class<?> codegenClass = null;
        try {
            codegenClass = classLoader.loadClass(workspaceClassNameWithPackage);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ClassNotFoundException:" + workspaceClassNameWithPackage, e);
        }
        Object targetObject = null;
        try {
            targetObject = codegenClass.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        return targetObject;
    }

    private static void addProjectsToClassLoader(IProject[] additionalProjectList) {
    }

    public static Object getWorkspaceObject(String workspaceClassNameWithPackage, ClassLoaderKey classLoaderKey) {
        VJETPluginClassloader classLoader = ClassloaderUtils.findClassLoaderByKey(classLoaderKey);
        return ClassloaderUtils.getWorkspaceObject(workspaceClassNameWithPackage, classLoader);
    }

    public static enum ClassLoaderKey {
        APPLICATION_EXPLORER("ApplicationExplorer"),
        DEFAULT("Default"),
        COMPONENT("Component"),
        WORKSPACE("Workspace"),
        WORKSPACECODEGEN("WorkspaceCodeGen"),
        WORKSPACEPLUSMEGAJAR("WorkspacePlusMegajar"),
        WIZARD("Wizard");

        private String m_name;

        private ClassLoaderKey(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }
    }

    private static final class ClassLoaderRegistry {
        private Map<ClassLoaderKey, VJETPluginClassloader> m_loaderMap = new HashMap<ClassLoaderKey, VJETPluginClassloader>();
        VJETPluginClassloader wizardClassLoaderCache = null;

        private ClassLoaderRegistry() {
        }

        public void register(ClassLoaderKey key, VJETPluginClassloader cl) {
            if (this.m_loaderMap.get((Object)key) != null) {
                throw new ClassLoaderRegistryException("Key already exists");
            }
            this.m_loaderMap.put(key, cl);
        }

        public VJETPluginClassloader get(Object key) {
            if (ClassLoaderKey.WIZARD == key && this.m_loaderMap.get(key) != null) {
                if (this.wizardClassLoaderCache == null) {
                    VJETPluginClassloader loader = this.m_loaderMap.get(key);
                    List<IJavaProject> javaProjectList = null;
                    try {
                        javaProjectList = WorkspaceUtil.getAllProjects();
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    HashMap<String, String> projectMap = new HashMap<String, String>();
                    URL[] projectUrls = null;
                    try {
                        projectUrls = ClassloaderUtils.getProjectDependencyUrls(javaProjectList, null, projectMap);
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    URL[] currentUrlList = loader.getURLs();
                    HashSet<URL> currentUrlSet = new HashSet<URL>(Arrays.asList(currentUrlList));
                    URL[] uRLArray = projectUrls;
                    int n = projectUrls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URL url = uRLArray[n2];
                        if (!currentUrlSet.contains(url)) {
                            try {
                                loader.addWorkspaceUrl(url);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n2;
                    }
                    this.wizardClassLoaderCache = loader;
                }
                return this.wizardClassLoaderCache;
            }
            return this.m_loaderMap.get(key);
        }

        public void clear() {
            this.m_loaderMap.clear();
        }

        public void remove(ClassLoaderKey key) {
            if (!this.m_loaderMap.containsKey((Object)key)) {
                return;
            }
            this.m_loaderMap.remove((Object)key);
        }
    }

    private static class ClassLoaderRegistryException
    extends RuntimeException {
        public ClassLoaderRegistryException() {
        }

        public ClassLoaderRegistryException(String message) {
            super(message);
        }

        public ClassLoaderRegistryException(String message, Throwable cause) {
            super(message, cause);
        }

        public ClassLoaderRegistryException(Throwable cause) {
            super(cause);
        }
    }
}

