/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.commands;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.ClassloaderUrlFilter;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.UrlProcessor;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.jar.JarClassData;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.jar.JarDictionary;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.jar.JarDictionaryUtil;

public class VJETPluginClassloader
extends URLClassLoader {
    Set<JarDictionary> m_jarFiles = new HashSet<JarDictionary>();
    private static VJETPluginClassloader classLoader = null;
    private long m_creationTime = System.currentTimeMillis();
    private String m_packageFragment = null;
    private String m_packageMustLiveInThisJar = null;

    public VJETPluginClassloader(URL[] urls, ClassLoader parent) throws IOException {
        super(new UrlProcessor(null, new ClassloaderUrlFilter()).getFilteredUrls(urls), parent);
        URL[] jarUrls = null;
        URL[] uRLArray = jarUrls = new UrlProcessor(new ClassloaderUrlFilter(), null).getFilteredUrls(urls);
        int n = jarUrls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            JarDictionary jarDictionary = new JarDictionary(url);
            JarDictionaryUtil.fillJarDictionary(url, jarDictionary);
            this.m_jarFiles.add(jarDictionary);
            ++n2;
        }
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    @Override
    public URL[] getURLs() {
        URL[] baseUrls = super.getURLs();
        ArrayList<URL> urls = new ArrayList<URL>(baseUrls.length + this.m_jarFiles.size());
        URL[] uRLArray = baseUrls;
        int n = baseUrls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            urls.add(url);
            ++n2;
        }
        for (JarDictionary jarDictionary : this.m_jarFiles) {
            urls.add(jarDictionary.getUrl());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    @Override
    public URL findResource(String name) {
        URL systemURL = this.getParent().getResource(name);
        if (systemURL != null) {
            return systemURL;
        }
        URL jarURL = super.findResource(name);
        if (jarURL != null) {
            return jarURL;
        }
        JarClassData jarClassData = this.getJarClassData(name);
        if (jarClassData != null) {
            jarClassData.getUrl().toExternalForm();
            jarURL = jarClassData.getUrl();
        }
        return jarURL;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        List<JarClassData> jarClassData = this.getJarResources(name);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (JarClassData jar : jarClassData) {
            urls.add(jar.getUrl());
        }
        final Iterator it = urls.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)it.next();
            }
        };
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        try {
            Class<?> systemClass = this.getParent().loadClass(name);
            if (systemClass != null) {
                return systemClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            Class<?> jarClass = super.findClass(name);
            if (jarClass != null) {
                return jarClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        String path = name.replace('.', '/').concat(".class");
        JarClassData jarClassData = this.getJarClassData(path);
        if (jarClassData != null) {
            try {
                return this.defineClass(name, jarClassData);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        throw new ClassNotFoundException(name);
    }

    JarClassData getJarClassData(String className) {
        for (JarDictionary jarDictionary : this.m_jarFiles) {
            if (!jarDictionary.jarContainsClass(className)) continue;
            return jarDictionary.getJarClassData(className);
        }
        return null;
    }

    List<JarClassData> getJarResources(String resName) {
        ArrayList<JarClassData> resources = new ArrayList<JarClassData>();
        for (JarDictionary jarDictionary : this.m_jarFiles) {
            if (!jarDictionary.jarContainsClass(resName)) continue;
            resources.add(jarDictionary.getJarClassData(resName));
        }
        return resources;
    }

    private Class defineClass(String name, JarClassData jarClassData) throws IOException, ClassNotFoundException {
        byte[] bb;
        int i = name.lastIndexOf(46);
        URL url = jarClassData.getCodeSourceURL();
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = null;
            if (pkg != null) {
                if (pkg.isSealed()) {
                    if (!pkg.isSealed(url)) {
                        throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                    }
                } else if (man != null && this.isSealed(pkgname, man)) {
                    throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
                }
            } else if (man != null) {
                this.definePackage(pkgname, man, url);
            } else {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
        }
        if ((bb = jarClassData.getZipEntryData()) != null) {
            CodeSigner[] signers = jarClassData.getCodeSigners();
            CodeSource cs = new CodeSource(url, signers);
            return this.defineClass(name, bb, 0, bb.length, cs);
        }
        byte[] b = jarClassData.getBytes();
        CodeSigner[] signers = jarClassData.getCodeSigners();
        CodeSource cs = new CodeSource(url, signers);
        return this.defineClass(name, b, 0, b.length, cs);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    public void addWorkspaceUrl(URL url) throws IOException {
        ClassloaderUrlFilter urlFilter = new ClassloaderUrlFilter();
        if (urlFilter.filter(url)) {
            JarDictionary jarDictionary = new JarDictionary(url);
            if (!this.m_jarFiles.contains(jarDictionary)) {
                JarDictionaryUtil.fillJarDictionary(url, jarDictionary);
                this.m_jarFiles.add(jarDictionary);
            } else {
                System.out.println("Skipping");
            }
        } else {
            this.addURL(url);
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        String path;
        JarClassData jarClassData;
        if (this.m_packageFragment != null && className.startsWith(this.m_packageFragment) && (jarClassData = this.getJarClassData(path = className.replace('.', '/').concat(".class"))) != null && jarClassData.getUrl().getFile().contains(this.m_packageMustLiveInThisJar)) {
            try {
                return this.defineClass(className, jarClassData);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
        return super.loadClass(className);
    }

    @Override
    public URL getResource(String resName) {
        JarClassData jarClassData;
        if (this.m_packageFragment != null && resName.startsWith(this.m_packageFragment.replace('.', '/')) && (jarClassData = this.getJarClassData(resName)) != null && jarClassData.getUrl().getFile().contains(this.m_packageMustLiveInThisJar)) {
            jarClassData.getUrl().toExternalForm();
            URL jarURL = jarClassData.getUrl();
            return jarURL;
        }
        return super.getResource(resName);
    }

    public void enableWorkspaceFirstLoading(String packageFragment, String jarFileName) {
        this.m_packageFragment = packageFragment;
        this.m_packageMustLiveInThisJar = jarFileName;
    }

    public void disableWorkspaceFirstLoading() {
        this.m_packageFragment = null;
        this.m_packageMustLiveInThisJar = null;
    }
}

