/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class BrowserService {
    public static final String PARM_WEB_URL = "webUrl";
    public static final String PARM_BROWSER_TYPE = "bType";
    private int m_port = 1000;
    private Server m_webServer = null;
    private static final BrowserService s_instance = new BrowserService();

    private BrowserService() {
        try {
            this.startWebServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BrowserService getInstance() {
        return s_instance;
    }

    public int getPort() {
        return this.m_port;
    }

    void startWebServer() throws Exception {
        this.m_port = 10090;
        while (this.m_port <= 65535) {
            try {
                this.m_webServer = new Server(this.m_port);
                this.m_webServer.setHandler((Handler)new WebHandler());
                this.m_webServer.start();
                break;
            }
            catch (IOException iOException) {
                if (this.m_webServer != null) {
                    this.m_webServer.stop();
                }
                this.m_webServer = null;
                ++this.m_port;
            }
        }
    }

    void stopWebServer() {
        if (this.m_webServer != null) {
            try {
                this.m_webServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.m_webServer.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_webServer = null;
        }
    }

    public void finalize() {
        this.stopWebServer();
    }

    private class WebHandler
    extends AbstractHandler {
        private WebHandler() {
        }

        public void handle(String arg0, Request arg1, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setCharacterEncoding("UTF8");
            String webUrl = request.getParameter(BrowserService.PARM_WEB_URL);
            request.getParameter(BrowserService.PARM_BROWSER_TYPE);
            if (webUrl == null || webUrl.isEmpty()) {
                response.sendError(400);
            }
            try {
                IWorkbenchBrowserSupport wbSupport = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser browser = wbSupport.getExternalBrowser();
                if (browser == null) {
                    browser = wbSupport.createBrowser("internal");
                }
                browser.openURL(new URL(webUrl));
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            response.setStatus(200);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(1);
            outputStream.close();
        }
    }
}

