/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vjet.dsf.jst.ts.util.ISdkEnvironment;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.sdk.ISdkEnvironmentType;
import org.eclipse.vjet.eclipse.core.sdk.VjetSdkRuntime;

public class InstalledSdksBlock
implements ISelectionProvider {
    private Composite fControl;
    private List fVMs = new ArrayList();
    private CheckboxTableViewer fVMList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fCopyButton;
    private Button fSearchButton;
    private int fSortColumn = 0;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;
    private static String fgLastUsedID;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.fVMList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object jre = ((IStructuredSelection)selection).getFirstElement();
            if (jre == null) {
                this.fVMList.setCheckedElements(new Object[0]);
            } else {
                this.fVMList.setCheckedElements(new Object[]{jre});
                this.fVMList.reveal(jre);
            }
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText("VJET SKD");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        tableLabel.setFont(font);
        this.fTable = new Table(parent, 67618);
        data = new GridData(1808);
        data.widthHint = 450;
        this.fTable.setLayoutData((Object)data);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.fTable, 0);
        column1.setText("name");
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledSdksBlock.this.sortByName();
            }
        });
        TableColumn column2 = new TableColumn(this.fTable, 0);
        column2.setText("Location");
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledSdksBlock.this.sortByLocation();
            }
        });
        TableColumn column3 = new TableColumn(this.fTable, 0);
        column3.setText("type");
        column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledSdksBlock.this.sortByType();
            }
        });
        this.fVMList = new CheckboxTableViewer(this.fTable);
        this.fVMList.setLabelProvider((IBaseLabelProvider)new VMLabelProvider());
        this.fVMList.setContentProvider((IContentProvider)new JREsContentProvider());
        this.sortByName();
        this.fVMList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledSdksBlock.this.enableButtons();
            }
        });
        this.fVMList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledSdksBlock.this.setCheckedJRE((ISdkEnvironment)event.getElement());
                } else {
                    InstalledSdksBlock.this.setCheckedJRE(null);
                }
            }
        });
        this.fVMList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledSdksBlock.this.fVMList.getSelection().isEmpty()) {
                    InstalledSdksBlock.this.editVM();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    InstalledSdksBlock.this.removeVMs();
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.fAddButton = this.createPushButton(buttons, "add");
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSdksBlock.this.addVM();
            }
        });
        this.fEditButton = this.createPushButton(buttons, "edit");
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSdksBlock.this.editVM();
            }
        });
        this.fCopyButton = this.createPushButton(buttons, "push");
        this.fCopyButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSdksBlock.this.copyVM();
            }
        });
        this.fRemoveButton = this.createPushButton(buttons, "remove");
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSdksBlock.this.removeVMs();
            }
        });
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSearchButton = this.createPushButton(buttons, "Install");
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledSdksBlock.this.search();
            }
        });
        this.fillWithWorkspaceJREs();
        this.enableButtons();
        this.fAddButton.setEnabled(VjetSdkRuntime.getSdkEnviromentTypes().length > 0);
    }

    protected void copyVM() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        Iterator it = selection.iterator();
        ArrayList newEntries = new ArrayList();
        while (it.hasNext()) {
            ISdkEnvironment cfr_ignored_0 = (ISdkEnvironment)it.next();
        }
        this.fVMList.refresh();
        this.fVMList.setSelection((ISelection)new StructuredSelection(newEntries.toArray()));
    }

    public String generateName(String name) {
        if (!this.isDuplicateName(name)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = String.valueOf(name.substring(0, start + 1)) + (numericValue + 1) + ")";
            return this.generateName(newName);
        }
        return this.generateName(String.valueOf(name) + " (1)");
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    private void sortByType() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ISdkEnvironment && e2 instanceof ISdkEnvironment) {
                    String rightType;
                    ISdkEnvironment left = (ISdkEnvironment)e1;
                    ISdkEnvironment right = (ISdkEnvironment)e2;
                    String leftType = left.getSdkName();
                    int res = leftType.compareToIgnoreCase(rightType = right.getSdkName());
                    if (res != 0) {
                        return res;
                    }
                    return left.getSdkName().compareToIgnoreCase(right.getSdkName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ISdkEnvironment && e2 instanceof ISdkEnvironment) {
                    ISdkEnvironment left = (ISdkEnvironment)e1;
                    ISdkEnvironment right = (ISdkEnvironment)e2;
                    return left.getSdkName().compareToIgnoreCase(right.getSdkName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByLocation() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ISdkEnvironment && e2 instanceof ISdkEnvironment) {
                    ISdkEnvironment left = (ISdkEnvironment)e1;
                    ISdkEnvironment right = (ISdkEnvironment)e2;
                    return left.getSdkName().compareToIgnoreCase(right.getSdkName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fCopyButton.setEnabled(selectionCount > 0);
        if (selectionCount > 0 && selectionCount < this.fVMList.getTable().getItemCount()) {
            for (ISdkEnvironment install : selection) {
                if (!this.isContributed(install)) continue;
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    private boolean isContributed(ISdkEnvironment install) {
        return VjetSdkRuntime.isContributedVMInstall((String)install.getSdkName());
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTFactory.createPushButton((Composite)parent, (String)label, null);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setJREs(ISdkEnvironment[] vms) {
        this.fVMs.clear();
        int i = 0;
        while (i < vms.length) {
            this.fVMs.add(vms[i]);
            ++i;
        }
        this.fVMList.setInput((Object)this.fVMs);
        this.fVMList.refresh();
    }

    public ISdkEnvironment[] getJREs() {
        return this.fVMs.toArray(new ISdkEnvironment[this.fVMs.size()]);
    }

    private void addVM() {
        this.fVMList.refresh();
    }

    public void vmAdded(ISdkEnvironment vm) {
        this.fVMs.add(vm);
        this.fVMList.refresh();
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fVMs.size()) {
            ISdkEnvironment vm = (ISdkEnvironment)this.fVMs.get(i);
            if (vm.getSdkName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void editVM() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        ISdkEnvironment vm = (ISdkEnvironment)selection.getFirstElement();
        if (vm == null) {
            return;
        }
    }

    private void removeVMs() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        ISdkEnvironment[] vms = new ISdkEnvironment[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            vms[i] = (ISdkEnvironment)iter.next();
            ++i;
        }
        this.removeJREs(vms);
    }

    public void removeJREs(ISdkEnvironment[] vms) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < vms.length) {
            this.fVMs.remove(vms[i]);
            ++i;
        }
        this.fVMList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            ISdkEnvironment[] installs = this.getJREs();
            if (curr.size() == 0 && installs.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected void search() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Temp code");
        dialog.setText("Temp code");
        String path = dialog.open();
        if (path == null) {
            return;
        }
        final HashSet<String[]> exstingLocations = new HashSet<String[]>();
        Iterator iter = this.fVMs.iterator();
        while (iter.hasNext()) {
            exstingLocations.add(((ISdkEnvironment)iter.next()).getSdkPaths());
        }
        final File rootDir = new File(path);
        final ArrayList locations = new ArrayList();
        final ArrayList types = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Temp code", -1);
                InstalledSdksBlock.this.search(rootDir, locations, types, exstingLocations, monitor);
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell()){

                protected void createCancelButton(Composite parent) {
                    this.cancel = this.createButton(parent, 1, IDialogConstants.STOP_LABEL, true);
                    if (this.arrowCursor == null) {
                        this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
                    }
                    this.cancel.setCursor(this.arrowCursor);
                    this.setOperationCancelButtonEnabled(this.enableCancelButton);
                }
            };
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            VjetPlugin.error((String)"Error", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (!locations.isEmpty()) {
            iter = locations.iterator();
            types.iterator();
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private String createUniqueId(ISdkEnvironmentType vmType) {
        String id = null;
        while (vmType.findSdkInstall(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    protected void search(File directory, List found, List types, Set ignore, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String[] names = directory.list();
        if (names == null) {
            return;
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        int i = 0;
        while (i < names.length) {
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, names[i]);
            try {
                monitor.subTask("Temp code");
            }
            catch (Exception exception) {}
            ISdkEnvironmentType[] vmTypes = VjetSdkRuntime.getSdkEnviromentTypes();
            if (file.isDirectory() && !ignore.contains(file)) {
                boolean validLocation = false;
                int j = 0;
                while (j < vmTypes.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ISdkEnvironmentType type = vmTypes[j];
                    IStatus status = type.validateInstallLocation(file);
                    if (status.isOK()) {
                        found.add(file);
                        types.add(type);
                        validLocation = true;
                        break;
                    }
                    ++j;
                }
                if (!validLocation) {
                    subDirs.add(file);
                }
            }
            ++i;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            this.search(subDir, found, types, ignore, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    public void setCheckedJRE(ISdkEnvironment vm) {
        if (vm == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)vm));
        }
    }

    public ISdkEnvironment getCheckedJRE() {
        Object[] objects = this.fVMList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (ISdkEnvironment)objects[0];
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put(String.valueOf(qualifier) + ".columnWidth" + i, this.fTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fVMList.getTable().layout(true);
        this.restoreColumnWidths(settings, qualifier);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByLocation();
                break;
            }
            case 3: {
                this.sortByType();
            }
        }
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width <= 0) {
                this.fTable.getColumn(i).pack();
            } else {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    protected void fillWithWorkspaceJREs() {
        ArrayList standins = new ArrayList();
        ISdkEnvironmentType[] types = VjetSdkRuntime.getSdkEnviromentTypes();
        int i = 0;
        while (i < types.length) {
            ISdkEnvironmentType type = types[i];
            ISdkEnvironment[] installs = type.getSdkInstalls();
            int j = 0;
            while (j < installs.length) {
                ISdkEnvironment cfr_ignored_0 = installs[j];
                ++j;
            }
            ++i;
        }
        this.setJREs(standins.toArray(new ISdkEnvironment[standins.size()]));
    }

    class JREsContentProvider
    implements IStructuredContentProvider {
        JREsContentProvider() {
        }

        public Object[] getElements(Object input) {
            return InstalledSdksBlock.this.fVMs.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class VMLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VMLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ISdkEnvironment) {
                ISdkEnvironment vm = (ISdkEnvironment)element;
                switch (columnIndex) {
                    case 0: {
                        if (InstalledSdksBlock.this.isContributed(vm)) {
                            return "Default";
                        }
                        return vm.getSdkName();
                    }
                    case 1: {
                        return vm.getSdkPaths().toString();
                    }
                    case 2: {
                        return "type";
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

