/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.vjet.eclipse.internal.ui.preferences.VjetPreferenceMessages;
import org.eclipse.vjet.eclipse.ui.VjoElementImageDescriptor;
import org.eclipse.vjet.eclipse.ui.VjoElementImageProvider;

public class VJOMembersOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_ID = "org.eclipse.jdt.ui.preferences.MembersOrderPreferencePage";
    private static final String ALL_SORTMEMBER_ENTRIES = "T,SI,SF,SM,I,F,C,M";
    private static final String ALL_VISIBILITY_ENTRIES = "B,V,R,D";
    private static final String PREF_OUTLINE_SORT_OPTION = "outlinesortoption";
    private static final String PREF_VISIBILITY_SORT_OPTION = "org.eclipse.jdt.ui.visibility.order";
    private static final String PREF_USE_VISIBILITY_SORT_OPTION = "org.eclipse.jdt.ui.enable.visibility.order";
    public static final String CONSTRUCTORS = "C";
    public static final String FIELDS = "F";
    public static final String METHODS = "M";
    public static final String STATIC_METHODS = "SM";
    public static final String STATIC_FIELDS = "SF";
    public static final String INIT = "I";
    public static final String STATIC_INIT = "SI";
    public static final String TYPES = "T";
    public static final String PUBLIC = "B";
    public static final String PRIVATE = "V";
    public static final String PROTECTED = "R";
    public static final String DEFAULT = "D";
    private boolean fUseVisibilitySort;
    private ListDialogField fSortOrderList;
    private ListDialogField fVisibilityOrderList;
    private SelectionButtonDialogField fUseVisibilitySortField;

    private static boolean isValidEntries(List entries, String entryString) {
        StringTokenizer tokenizer = new StringTokenizer(entryString, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!entries.contains(token)) {
                return false;
            }
            ++i;
        }
        return i == entries.size();
    }

    public VJOMembersOrderPreferencePage() {
        this.setPreferenceStore(DLTKUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(VjetPreferenceMessages.MembersOrderPreferencePage_label_description);
        String memberSortString = this.getPreferenceStore().getString(PREF_OUTLINE_SORT_OPTION);
        String upLabel = VjetPreferenceMessages.MembersOrderPreferencePage_category_button_up;
        String downLabel = VjetPreferenceMessages.MembersOrderPreferencePage_category_button_down;
        this.fSortOrderList = new ListDialogField(null, new String[]{upLabel, downLabel}, (ILabelProvider)new MemberSortLabelProvider());
        this.fSortOrderList.setDownButtonIndex(1);
        this.fSortOrderList.setUpButtonIndex(0);
        List entries = VJOMembersOrderPreferencePage.parseList(memberSortString);
        if (!VJOMembersOrderPreferencePage.isValidEntries(entries, ALL_SORTMEMBER_ENTRIES)) {
            memberSortString = this.getPreferenceStore().getDefaultString(PREF_OUTLINE_SORT_OPTION);
            entries = VJOMembersOrderPreferencePage.parseList(memberSortString);
        }
        this.fSortOrderList.setElements((Collection)entries);
        this.fUseVisibilitySort = this.getPreferenceStore().getBoolean(PREF_USE_VISIBILITY_SORT_OPTION);
        String visibilitySortString = this.getPreferenceStore().getString(PREF_VISIBILITY_SORT_OPTION);
        upLabel = VjetPreferenceMessages.MembersOrderPreferencePage_visibility_button_up;
        downLabel = VjetPreferenceMessages.MembersOrderPreferencePage_visibility_button_down;
        this.fVisibilityOrderList = new ListDialogField(null, new String[]{upLabel, downLabel}, (ILabelProvider)new VisibilitySortLabelProvider());
        this.fVisibilityOrderList.setDownButtonIndex(1);
        this.fVisibilityOrderList.setUpButtonIndex(0);
        entries = VJOMembersOrderPreferencePage.parseList(visibilitySortString);
        if (!VJOMembersOrderPreferencePage.isValidEntries(entries, ALL_VISIBILITY_ENTRIES)) {
            visibilitySortString = this.getPreferenceStore().getDefaultString(PREF_VISIBILITY_SORT_OPTION);
            entries = VJOMembersOrderPreferencePage.parseList(visibilitySortString);
        }
        this.fVisibilityOrderList.setElements((Collection)entries);
    }

    private static List parseList(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        ArrayList<String> entries = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            entries.add(token);
        }
        return entries;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite sortComposite = new Composite(parent, 0);
        sortComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        sortComposite.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 768;
        sortComposite.setLayoutData((Object)gd);
        this.createListDialogField(sortComposite, this.fSortOrderList);
        this.fUseVisibilitySortField = new SelectionButtonDialogField(32);
        this.fUseVisibilitySortField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                VJOMembersOrderPreferencePage.this.fVisibilityOrderList.setEnabled(VJOMembersOrderPreferencePage.this.fUseVisibilitySortField.isSelected());
            }
        });
        this.fUseVisibilitySortField.setLabelText(VjetPreferenceMessages.MembersOrderPreferencePage_usevisibilitysort_label);
        this.fUseVisibilitySortField.doFillIntoGrid(sortComposite, 2);
        this.fUseVisibilitySortField.setSelection(this.fUseVisibilitySort);
        this.createListDialogField(sortComposite, this.fVisibilityOrderList);
        this.fVisibilityOrderList.setEnabled(this.fUseVisibilitySortField.isSelected());
        Dialog.applyDialogFont((Control)sortComposite);
        return sortComposite;
    }

    private void createListDialogField(Composite composite, ListDialogField dialogField) {
        Control list = dialogField.getListControl(composite);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        list.setLayoutData((Object)gd);
        Composite buttons = dialogField.getButtonBox(composite);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        buttons.setLayoutData((Object)gd);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore prefs = DLTKUIPlugin.getDefault().getPreferenceStore();
        String str = prefs.getDefaultString(PREF_OUTLINE_SORT_OPTION);
        if (str != null) {
            this.fSortOrderList.setElements((Collection)VJOMembersOrderPreferencePage.parseList(str));
        } else {
            this.fSortOrderList.setElements((Collection)VJOMembersOrderPreferencePage.parseList(ALL_SORTMEMBER_ENTRIES));
        }
        str = prefs.getDefaultString(PREF_VISIBILITY_SORT_OPTION);
        if (str != null) {
            this.fVisibilityOrderList.setElements((Collection)VJOMembersOrderPreferencePage.parseList(str));
        } else {
            this.fVisibilityOrderList.setElements((Collection)VJOMembersOrderPreferencePage.parseList(ALL_VISIBILITY_ENTRIES));
        }
        this.fUseVisibilitySortField.setSelection(prefs.getDefaultBoolean(PREF_USE_VISIBILITY_SORT_OPTION));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        this.updateList(store, this.fSortOrderList, PREF_OUTLINE_SORT_OPTION);
        this.updateList(store, this.fVisibilityOrderList, PREF_VISIBILITY_SORT_OPTION);
        store.setValue(PREF_USE_VISIBILITY_SORT_OPTION, this.fUseVisibilitySortField.isSelected());
        DLTKUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void updateList(IPreferenceStore store, ListDialogField list, String str) {
        StringBuffer buf = new StringBuffer();
        List curr = list.getElements();
        for (String s : curr) {
            buf.append(s);
            buf.append(',');
        }
        store.setValue(str, buf.toString());
    }

    private class MemberSortLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = DLTKUIPlugin.getImageDescriptorRegistry();
            Object descriptor = null;
            if (element instanceof String) {
                int visibility = 1;
                String s = (String)element;
                if (s.equals(VJOMembersOrderPreferencePage.FIELDS)) {
                    descriptor = VjoElementImageProvider.getFieldImageDescriptor(visibility);
                } else if (s.equals(VJOMembersOrderPreferencePage.CONSTRUCTORS)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(visibility);
                    descriptor = new VjoElementImageDescriptor((ImageDescriptor)descriptor, 512, VjoElementImageProvider.SMALL_SIZE);
                } else if (s.equals(VJOMembersOrderPreferencePage.METHODS)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(visibility);
                } else if (s.equals(VJOMembersOrderPreferencePage.STATIC_FIELDS)) {
                    descriptor = VjoElementImageProvider.getFieldImageDescriptor(visibility);
                    descriptor = new VjoElementImageDescriptor((ImageDescriptor)descriptor, 8, VjoElementImageProvider.SMALL_SIZE);
                } else if (s.equals(VJOMembersOrderPreferencePage.STATIC_METHODS)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(visibility);
                    descriptor = new VjoElementImageDescriptor((ImageDescriptor)descriptor, 8, VjoElementImageProvider.SMALL_SIZE);
                } else if (s.equals(VJOMembersOrderPreferencePage.INIT)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(visibility);
                } else if (s.equals(VJOMembersOrderPreferencePage.STATIC_INIT)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(visibility);
                    descriptor = new VjoElementImageDescriptor((ImageDescriptor)descriptor, 8, VjoElementImageProvider.SMALL_SIZE);
                } else {
                    descriptor = s.equals(VJOMembersOrderPreferencePage.TYPES) ? VjoElementImageProvider.getTypeImageDescriptor(1, false) : VjoElementImageProvider.getMethodImageDescriptor(1);
                }
                return registry.get(descriptor);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(VJOMembersOrderPreferencePage.FIELDS)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_fields_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.METHODS)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_methods_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.STATIC_FIELDS)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_staticfields_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.STATIC_METHODS)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_staticmethods_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.CONSTRUCTORS)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_constructors_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.INIT)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_initialisers_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.STATIC_INIT)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_staticinitialisers_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.TYPES)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_types_label;
                }
            }
            return "";
        }
    }

    private class VisibilitySortLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            ImageDescriptorRegistry registry = DLTKUIPlugin.getImageDescriptorRegistry();
            ImageDescriptor descriptor = null;
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(VJOMembersOrderPreferencePage.PUBLIC)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(1);
                } else if (s.equals(VJOMembersOrderPreferencePage.PRIVATE)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(2);
                } else if (s.equals(VJOMembersOrderPreferencePage.PROTECTED)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(4);
                } else if (s.equals(VJOMembersOrderPreferencePage.DEFAULT)) {
                    descriptor = VjoElementImageProvider.getMethodImageDescriptor(0);
                }
                return registry.get(descriptor);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof String) {
                String s = (String)element;
                if (s.equals(VJOMembersOrderPreferencePage.PUBLIC)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_public_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.PRIVATE)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_private_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.PROTECTED)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_protected_label;
                }
                if (s.equals(VJOMembersOrderPreferencePage.DEFAULT)) {
                    return VjetPreferenceMessages.MembersOrderPreferencePage_default_label;
                }
            }
            return "";
        }
    }
}

