/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.core.search.SearchRequestor;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.mod.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.mod.internal.corext.util.SearchUtils;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.mod.ui.search.PatternQuerySpecification;
import org.eclipse.dltk.mod.ui.search.QuerySpecification;
import org.eclipse.ltk.core.refactoring.IRefactoringStatusEntryComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoSearchEngine;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.CollectingSearchRequestor;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.core.SearchResultGroup;

public class RefactoringSearchEngine {
    private RefactoringSearchEngine() {
    }

    public static ISourceModule[] findAffectedSourceModules(QuerySpecification querySpecification, IProgressMonitor pm, RefactoringStatus status, boolean tolerateInAccurateMatches) throws ModelException {
        boolean hasNonCuMatches = false;
        class ResourceSearchRequestor
        extends SearchRequestor {
            boolean hasPotentialMatches = false;
            Set resources = new HashSet(5);
            private IResource fLastResource;
            private final /* synthetic */ boolean val$tolerateInAccurateMatches;

            ResourceSearchRequestor(boolean bl) {
                this.val$tolerateInAccurateMatches = bl;
            }

            public void acceptSearchMatch(SearchMatch match) {
                if (!this.val$tolerateInAccurateMatches && match.getAccuracy() == 1) {
                    this.hasPotentialMatches = true;
                }
                if (this.fLastResource != match.getResource()) {
                    this.fLastResource = match.getResource();
                    this.resources.add(this.fLastResource);
                }
            }
        }
        ResourceSearchRequestor requestor = new ResourceSearchRequestor(tolerateInAccurateMatches);
        new VjoSearchEngine().search(RefactoringSearchEngine.createQueryParameters(querySpecification));
        ArrayList<IModelElement> result = new ArrayList<IModelElement>(requestor.resources.size());
        for (IResource resource : requestor.resources) {
            IModelElement element = DLTKCore.create((IResource)resource);
            if (element instanceof ISourceModule) {
                result.add(element);
                continue;
            }
            hasNonCuMatches = true;
        }
        RefactoringSearchEngine.addStatusErrors(status, requestor.hasPotentialMatches, hasNonCuMatches);
        return result.toArray(new ISourceModule[result.size()]);
    }

    private static SearchQueryParameters createQueryParameters(QuerySpecification specification) {
        SearchPattern pattern;
        String stringPattern;
        IDLTKLanguageToolkit toolkit = specification.getScope().getLanguageToolkit();
        SearchQueryParameters parameters = new SearchQueryParameters();
        if (specification instanceof ElementQuerySpecification) {
            IModelElement element = ((ElementQuerySpecification)specification).getElement();
            stringPattern = ScriptElementLabels.getDefault().getElementLabel(element, ScriptElementLabels.ALL_DEFAULT);
            if (!element.exists()) {
                return new SearchQueryParameters(null, stringPattern);
            }
            pattern = SearchPattern.createPattern((IModelElement)element, (int)specification.getLimitTo(), (int)24, (IDLTKLanguageToolkit)toolkit);
            ElementQuerySpecification elSpecification = (ElementQuerySpecification)specification;
            parameters.setElementSpecification(true);
            parameters.setElement((Object)elSpecification.getElement());
        } else {
            PatternQuerySpecification patternSpec = (PatternQuerySpecification)specification;
            stringPattern = patternSpec.getPattern();
            int matchMode = RefactoringSearchEngine.getMatchMode(stringPattern) | 0x10;
            if (patternSpec.isCaseSensitive()) {
                matchMode |= 8;
            }
            pattern = SearchPattern.createPattern((String)patternSpec.getPattern(), (int)patternSpec.getSearchFor(), (int)patternSpec.getLimitTo(), (int)matchMode, (IDLTKLanguageToolkit)toolkit);
        }
        parameters.setStringPattern(stringPattern);
        parameters.setPattern(pattern);
        parameters.setScope(specification.getScope());
        parameters.setLimitTo(specification.getLimitTo());
        return parameters;
    }

    private static int getMatchMode(String pattern) {
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            return 2;
        }
        if (SearchUtils.isCamelCasePattern((String)pattern)) {
            return 128;
        }
        return 0;
    }

    public static ISourceModule[] findAffectedSourceModules(QuerySpecification querySpecification, IProgressMonitor pm, RefactoringStatus status) throws ModelException {
        return RefactoringSearchEngine.findAffectedSourceModules(querySpecification, pm, status, false);
    }

    public static SearchResultGroup[] search(QuerySpecification querySpecification, IProgressMonitor monitor, RefactoringStatus status) throws ModelException {
        return RefactoringSearchEngine.internalSearch(new VjoSearchEngine(), querySpecification, new CollectingSearchRequestor(), monitor, status);
    }

    public static SearchResultGroup[] search(QuerySpecification querySpecification, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws ModelException {
        return RefactoringSearchEngine.internalSearch(new VjoSearchEngine(), querySpecification, requestor, monitor, status);
    }

    private static SearchResultGroup[] internalSearch(VjoSearchEngine searchEngine, QuerySpecification querySpecification, CollectingSearchRequestor requestor, IProgressMonitor monitor, RefactoringStatus status) throws ModelException {
        List matches = searchEngine.search(RefactoringSearchEngine.createQueryParameters(querySpecification));
        for (VjoMatch vjoMatch : matches) {
            try {
                requestor.acceptSearchMatch(new VJOMatchWrapper(vjoMatch));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return RefactoringSearchEngine.groupByCu(requestor.getResults(), status);
    }

    public static SearchResultGroup[] groupByCu(SearchMatch[] matches, RefactoringStatus status) {
        return RefactoringSearchEngine.groupByCu(Arrays.asList(matches), status);
    }

    public static SearchResultGroup[] groupByCu(List matchList, RefactoringStatus status) {
        HashMap grouped = new HashMap();
        boolean hasPotentialMatches = false;
        boolean hasNonCuMatches = false;
        for (SearchMatch searchMatch : matchList) {
            if (searchMatch.getAccuracy() == 1) {
                hasPotentialMatches = true;
            }
            if (!grouped.containsKey(searchMatch.getResource())) {
                grouped.put(searchMatch.getResource(), new ArrayList(1));
            }
            ((List)grouped.get(searchMatch.getResource())).add(searchMatch);
        }
        Iterator<Object> iter = grouped.keySet().iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IModelElement element = DLTKCore.create((IResource)resource);
            if (element instanceof ISourceModule) continue;
            iter.remove();
            hasNonCuMatches = true;
        }
        SearchResultGroup[] result = new SearchResultGroup[grouped.keySet().size()];
        int i = 0;
        for (IResource resource : grouped.keySet()) {
            List searchMatches = (List)grouped.get(resource);
            SearchMatch[] matchArray = searchMatches.toArray(new SearchMatch[searchMatches.size()]);
            result[i] = new SearchResultGroup(resource, matchArray);
            ++i;
        }
        RefactoringSearchEngine.addStatusErrors(status, hasPotentialMatches, hasNonCuMatches);
        return result;
    }

    private static boolean containsStatusEntry(RefactoringStatus status, RefactoringStatusEntry other) {
        return status.getEntries(new IRefactoringStatusEntryComparator(){

            public final int compare(RefactoringStatusEntry entry1, RefactoringStatusEntry entry2) {
                return entry1.getMessage().compareTo(entry2.getMessage());
            }
        }, other).length > 0;
    }

    private static void addStatusErrors(RefactoringStatus status, boolean hasPotentialMatches, boolean hasNonCuMatches) {
        RefactoringStatusEntry entry;
        if (hasPotentialMatches && !RefactoringSearchEngine.containsStatusEntry(status, entry = new RefactoringStatusEntry(3, RefactoringCoreMessages.RefactoringSearchEngine_potential_matches))) {
            status.addEntry(entry);
        }
        if (hasNonCuMatches && !RefactoringSearchEngine.containsStatusEntry(status, entry = new RefactoringStatusEntry(3, RefactoringCoreMessages.RefactoringSearchEngine_non_cu_matches))) {
            status.addEntry(entry);
        }
    }

    static class VJOMatchWrapper
    extends SearchMatch {
        public VJOMatchWrapper(IModelElement element, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
            super(element, accuracy, offset, length, participant, resource);
        }

        public VJOMatchWrapper(VjoMatch vjoMatch) throws ModelException {
            super((IModelElement)vjoMatch.getElement(), vjoMatch.getAccuracy(), vjoMatch.getOffset(), vjoMatch.getLength(), null, VJOMatchWrapper.getResource((IModelElement)vjoMatch.getElement()));
        }

        private static IResource getResource(IModelElement modelElement) {
            if (modelElement.getAdapter(IResource.class) != null) {
                return (IResource)modelElement.getAdapter(IResource.class);
            }
            if (modelElement instanceof IMember) {
                return ResourceUtil.getResource((Object)modelElement);
            }
            return null;
        }
    }
}

