/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.CompletionProposal;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class TypeCompletionProposal
extends CompletionProposal {
    private int needsPosition;
    private String typeName;

    public TypeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int needsPosition, String typeName) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition);
        this.needsPosition = needsPosition;
        this.typeName = typeName;
    }

    public TypeCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int needsPosition, String typeName, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.needsPosition = needsPosition;
        this.typeName = typeName;
    }

    @Override
    protected void postApply(IDocument document) {
        super.postApply(document);
        if (this.needsPosition == -1) {
            return;
        }
        try {
            this.performChange((IEditorPart)this.getVjoEditor(), document, (Change)this.createTextChange(document));
        }
        catch (CoreException e) {
            VjetUIPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    protected TextChange createTextChange(IDocument document) throws CoreException {
        String name = this.getReplacementString();
        DocumentChange change = new DocumentChange(name, document);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        InsertEdit edit = new InsertEdit(this.needsPosition, this.typeName);
        rootEdit.addChild((TextEdit)edit);
        return change;
    }
}

