/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.ast;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.mod.ui.util.PixelConverter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.compiler.IProblem;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vjet.dsf.jstojava.parser.SyntaxTreeFactory2;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.INodePrinter;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.NodePrinterFactory;
import org.eclipse.vjet.eclipse.internal.ui.text.SimpleVjoSourceViewerConfiguration;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoTextTools;
import org.eclipse.vjet.eclipse.internal.ui.view.ast.ASTTreeContentProvider;
import org.eclipse.vjet.eclipse.internal.ui.view.ast.ASTTreeLabelProvider;
import org.eclipse.vjet.eclipse.internal.ui.view.ast.SkipDocumentChangeAction;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class ASTView
extends ViewPart
implements ISelectionListener {
    private TreeViewer leftTreeViewer;
    private TreeViewer rightTreeViewer;
    private VjoEditor vjoEditor;
    private IPartListener partListener = new PartListener();
    private IDocumentListener documentListener = new DocumentListener();
    private IDoubleClickListener doubleClickListener = new DoubleClickListener();
    private CompilationUnitDeclaration orignalAst;
    private CompilationUnitDeclaration recoveryAst;
    private ScriptSourceViewer leftSourceViewer;
    private ScriptSourceViewer rightSourceViewer;
    private SkipDocumentChangeAction skipAction = new SkipDocumentChangeAction();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.fillActionBar();
        SashForm fullForm = new SashForm(parent, 256);
        fullForm.setLayoutData((Object)new GridData(1808));
        SashForm leftForm = new SashForm((Composite)fullForm, 512);
        leftForm.setLayoutData((Object)new GridData(1808));
        this.leftTreeViewer = this.createTreeViewer((Composite)leftForm, false);
        this.leftSourceViewer = this.createSourceViewer((Composite)leftForm);
        this.leftTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangeListener(this.leftSourceViewer));
        SashForm rightForm = new SashForm((Composite)fullForm, 512);
        rightForm.setLayoutData((Object)new GridData(1808));
        this.rightTreeViewer = this.createTreeViewer((Composite)rightForm, true);
        this.rightSourceViewer = this.createSourceViewer((Composite)rightForm);
        this.rightTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangeListener(this.rightSourceViewer));
        this.getSite().setSelectionProvider((ISelectionProvider)this.leftTreeViewer);
    }

    private void fillActionBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)this.skipAction);
    }

    private TreeViewer createTreeViewer(Composite parent, boolean isRecovery) {
        TreeViewer treeViewer = new TreeViewer(parent);
        treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        treeViewer.setContentProvider((IContentProvider)new ASTTreeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new ASTTreeLabelProvider(isRecovery));
        treeViewer.addDoubleClickListener(this.doubleClickListener);
        this.initContextMenu(treeViewer);
        return treeViewer;
    }

    private ScriptSourceViewer createSourceViewer(Composite parent) {
        Document document = new Document();
        IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((String)"org.eclipse.vjet.core.nature");
        VjoTextTools textTools = VjetUIPlugin.getDefault().getTextTools();
        textTools.setupDocumentPartitioner((IDocument)document, "__javascript_partitioning");
        IPreferenceStore store = toolkit.getPreferenceStore();
        ScriptSourceViewer viewer = new ScriptSourceViewer(parent, null, null, false, 2816, store);
        SimpleVjoSourceViewerConfiguration configuration = new SimpleVjoSourceViewerConfiguration(toolkit.getTextTools().getColorManager(), toolkit.getPreferenceStore(), null, "__javascript_partitioning", false);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Control control = viewer.getControl();
        GridData data = new GridData(768);
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(3);
        control.setLayoutData((Object)data);
        return viewer;
    }

    private void initContextMenu(TreeViewer viewer) {
        MenuManager popupMenuManager = new MenuManager("#PopupMenu");
        popupMenuManager.add((IAction)new CopyStructureAction(viewer));
        popupMenuManager.add((IAction)new CopyPropertiesAction(viewer));
        Menu popupMenu = popupMenuManager.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(popupMenu);
        this.getSite().registerContextMenu(popupMenuManager, (ISelectionProvider)viewer);
    }

    private String copyStructure(Object node, int tier) {
        ILabelProvider labelProvider = (ILabelProvider)this.leftTreeViewer.getLabelProvider();
        StringBuilder structureBuilder = new StringBuilder(labelProvider.getText(node));
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.leftTreeViewer.getContentProvider();
        Object[] children = contentProvider.getChildren(node);
        ++tier;
        int i = 0;
        while (i < children.length) {
            String childrenStructure = this.copyStructure(children[i], tier);
            structureBuilder.append("\n");
            int j = 0;
            while (j < tier) {
                structureBuilder.append("\t");
                ++j;
            }
            structureBuilder.append(childrenStructure);
            ++i;
        }
        return structureBuilder.toString();
    }

    private String copyProperties(Object node) {
        INodePrinter nodePrinter = NodePrinterFactory.getNodePrinter(node);
        if (nodePrinter == null) {
            return "";
        }
        String[] names = nodePrinter.getPropertyNames(node);
        if (names.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] values = nodePrinter.getPropertyValuies(node);
        int i = 0;
        while (i < names.length) {
            stringBuilder.append(String.valueOf(names[i]) + ":" + values[i]);
            if (i != names.length - 1) {
                stringBuilder.append("\n");
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof IEditorPart)) {
            return;
        }
        if (!(part instanceof VjoEditor)) {
            this.cleanUp();
            return;
        }
        if (this.vjoEditor != part) {
            IModelElement modelElement = ((VjoEditor)part).getInputModelElement();
            if (!(modelElement instanceof VjoSourceModule)) {
                this.cleanUp();
                return;
            }
            VjoSourceModule sourceModule = (VjoSourceModule)modelElement;
            CompilationUnitDeclaration ast = this.getASTUnit(sourceModule, (VjoEditor)part);
            if (ast == null) {
                return;
            }
            CompilationUnitDeclaration recoveryAST = this.getRecoveryASTUnit(ast, sourceModule, (VjoEditor)part);
            this.orignalAst = ast;
            this.recoveryAst = recoveryAST;
            this.leftTreeViewer.setInput((Object)new Object[]{ast});
            this.rightTreeViewer.setInput((Object)new Object[]{recoveryAST});
            this.vjoEditor = (VjoEditor)part;
            this.vjoEditor.getScriptSourceViewer().getDocument().addDocumentListener(this.documentListener);
            this.leftTreeViewer.expandAll();
            this.leftTreeViewer.collapseAll();
            this.rightTreeViewer.expandAll();
            this.rightTreeViewer.collapseAll();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IASTNode node = this.getASTNode(this.orignalAst, textSelection.getOffset());
            if (node != null) {
                this.leftTreeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            }
            if ((node = this.getASTNode(this.recoveryAst, textSelection.getOffset())) != null) {
                this.rightTreeViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            }
        }
    }

    private IASTNode getASTNode(CompilationUnitDeclaration ast, int offset) {
        CompilationUnitDeclaration parentNode = ast;
        while (this.getSubNode((IASTNode)parentNode, offset) != null) {
            parentNode = this.getSubNode((IASTNode)parentNode, offset);
        }
        return parentNode;
    }

    private IASTNode getSubNode(IASTNode parentNode, int offset) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.leftTreeViewer.getContentProvider();
        Object[] children = contentProvider.getChildren((Object)parentNode);
        if (children == null || children.length == 0) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            IASTNode child;
            if (children[i] instanceof IASTNode && offset >= (child = (IASTNode)children[i]).sourceStart() && offset < child.sourceEnd()) {
                return child;
            }
            ++i;
        }
        return null;
    }

    private CompilationUnitDeclaration getRecoveryASTUnit(CompilationUnitDeclaration declaration, VjoSourceModule sourceModule, VjoEditor vjoEditor) {
        String fileName = this.getFileName(sourceModule, vjoEditor);
        String jsSource = this.getSource(sourceModule, vjoEditor);
        return SyntaxTreeFactory2.fixedProblems((Map)Collections.EMPTY_MAP, (char[])jsSource.toCharArray(), (String)fileName, null, (CompilationUnitDeclaration)declaration);
    }

    private CompilationUnitDeclaration getASTUnit(VjoSourceModule sourceModule, VjoEditor vjoEditor) {
        try {
            String fileName = this.getFileName(sourceModule, vjoEditor);
            String jsSource = this.getSource(sourceModule, vjoEditor);
            CompilationUnitDeclaration ast = SyntaxTreeFactory2.createASTCompilationResult((Map)Collections.EMPTY_MAP, (char[])jsSource.toCharArray(), (String)fileName, null).getCompilationUnitDeclaration();
            return ast;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getFileName(VjoSourceModule sourceModule, VjoEditor vjoEditor) {
        if (sourceModule instanceof NativeVjoSourceModule) {
            IEditorInput editorInput = vjoEditor.getEditorInput();
            String filePath = ((ILocationProvider)editorInput).getPath((Object)editorInput).toOSString();
            return new File(filePath).getName();
        }
        return new String(sourceModule.getFileName());
    }

    private String getSource(VjoSourceModule sourceModule, VjoEditor vjoEditor) {
        try {
            if (sourceModule instanceof NativeVjoSourceModule) {
                IEditorInput editorInput = vjoEditor.getEditorInput();
                String filePath = ((ILocationProvider)editorInput).getPath((Object)editorInput).toOSString();
                return FileUtils.readFully((Reader)new FileReader(filePath));
            }
            return this.convertHTMLCommentsToJsComments(sourceModule.getSource());
        }
        catch (Exception e) {
            DLTKUIPlugin.log((Throwable)e);
            return null;
        }
    }

    private String convertHTMLCommentsToJsComments(String source) {
        if (source.contains("<!--")) {
            source = source.replace("<!--", "//--");
        }
        if (source.contains("-->")) {
            source = source.replace("-->", "///");
        }
        return source;
    }

    public void dispose() {
        if (this.vjoEditor != null) {
            this.vjoEditor.getScriptSourceViewer().getDocument().removeDocumentListener(this.documentListener);
        }
        super.dispose();
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
    }

    private void cleanUp() {
        this.leftTreeViewer.setInput(null);
        this.rightTreeViewer.setInput(null);
        if (this.vjoEditor != null) {
            this.vjoEditor.getScriptSourceViewer().getDocument().removeDocumentListener(this.documentListener);
        }
        this.vjoEditor = null;
    }

    private class CopyPropertiesAction
    extends Action {
        private TreeViewer viewer;

        public CopyPropertiesAction(TreeViewer viewer) {
            super("Copy Properties");
            this.viewer = viewer;
        }

        public void run() {
            Object selectedNode = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            String properties = ASTView.this.copyProperties(selectedNode);
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            clipboard.setContents(new Object[]{properties}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private class CopyStructureAction
    extends Action {
        private TreeViewer viewer;

        public CopyStructureAction(TreeViewer viewer) {
            super("Copy Structure");
            this.viewer = viewer;
        }

        public void run() {
            Object selectedNode = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            String structure = ASTView.this.copyStructure(selectedNode, 0);
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            clipboard.setContents(new Object[]{structure}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentChanged(DocumentEvent event) {
            if (ASTView.this.skipAction.isChecked()) {
                return;
            }
            IModelElement modelElement = ASTView.this.vjoEditor.getInputModelElement();
            if (!(modelElement instanceof VjoSourceModule)) {
                return;
            }
            VjoSourceModule sourceModule = (VjoSourceModule)modelElement;
            CompilationUnitDeclaration astUnit = ASTView.this.getASTUnit(sourceModule, ASTView.this.vjoEditor);
            if (astUnit == null) {
                return;
            }
            CompilationUnitDeclaration recoveryUnit = ASTView.this.getRecoveryASTUnit(astUnit, sourceModule, ASTView.this.vjoEditor);
            ASTView.this.orignalAst = astUnit;
            ASTView.this.recoveryAst = recoveryUnit;
            ASTView.this.leftTreeViewer.setInput((Object)new Object[]{astUnit});
            ASTView.this.leftTreeViewer.expandAll();
            ASTView.this.leftTreeViewer.collapseAll();
            ASTView.this.rightTreeViewer.setInput((Object)new Object[]{recoveryUnit});
            ASTView.this.rightTreeViewer.expandAll();
            ASTView.this.rightTreeViewer.collapseAll();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            int length;
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (!(element instanceof IASTNode) && !(element instanceof IProblem)) {
                return;
            }
            if (element instanceof IProblem) {
                IProblem problem = (IProblem)element;
                length = problem.getSourceEnd() - problem.getSourceStart() + 1;
                ASTView.this.vjoEditor.getScriptSourceViewer().revealRange(problem.getSourceStart(), length);
                ASTView.this.vjoEditor.getScriptSourceViewer().setSelectedRange(problem.getSourceStart(), length);
            }
            if (element instanceof IASTNode) {
                IASTNode node = (IASTNode)element;
                length = node.sourceEnd() - node.sourceStart() + 1;
                ASTView.this.vjoEditor.getScriptSourceViewer().revealRange(node.sourceStart(), length);
                ASTView.this.vjoEditor.getScriptSourceViewer().setSelectedRange(node.sourceStart(), length);
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (ASTView.this.vjoEditor == part) {
                ASTView.this.cleanUp();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class SelectionChangeListener
    implements ISelectionChangedListener {
        private ScriptSourceViewer sourceViewer;

        public SelectionChangeListener(ScriptSourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDocument document;
            Object object = ((TreeSelection)event.getSelection()).getFirstElement();
            if (object instanceof IProblem) {
                String message = ((IProblem)object).getMessage();
                document = this.sourceViewer.getDocument();
                document.set(message);
                this.sourceViewer.setDocument(document, 0, document.getLength());
            }
            if (!(object instanceof IASTNode)) {
                return;
            }
            String astCode = ((IASTNode)object).toString();
            if (astCode == null) {
                return;
            }
            document = this.sourceViewer.getDocument();
            document.set(astCode);
            this.sourceViewer.setDocument(document, 0, document.getLength());
        }
    }
}

