/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.typespace;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;

public class TypespaceViewFilter
extends ViewerFilter {
    private String m_filterStr = "";
    private int m_selectedTypeCount;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IJstType) {
            if (!StringUtils.isBlankOrEmpty((String)this.m_filterStr)) {
                boolean bol;
                IJstType type = (IJstType)element;
                String name = type.getName();
                String simpleName = type.getSimpleName();
                if (StringUtils.isBlankOrEmpty((String)name) || StringUtils.isBlankOrEmpty((String)simpleName)) {
                    return false;
                }
                boolean bl = bol = name.toLowerCase().startsWith(this.m_filterStr) || simpleName.toLowerCase().startsWith(this.m_filterStr);
                if (bol) {
                    ++this.m_selectedTypeCount;
                }
                return bol;
            }
            return true;
        }
        return true;
    }

    public boolean isFilterProperty(Object element, String property) {
        return super.isFilterProperty(element, property);
    }

    public void setFilterStr(String filterStr) {
        this.m_filterStr = filterStr.toLowerCase();
    }

    public boolean isEmptyFilter() {
        return StringUtils.isBlankOrEmpty((String)this.m_filterStr);
    }

    void clearCount() {
        this.m_selectedTypeCount = 0;
    }

    public int getSelectedTypeCount() {
        return this.m_selectedTypeCount;
    }
}

