/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.codeassist.ISelectionEngine;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjoLanguageToolkit;
import org.eclipse.vjet.eclipse.internal.codeassist.select.VjoSelectionEngine;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjetUIUtils {
    public static boolean isMixin(IType type) {
        ISourceModule sourceModule = type.getSourceModule();
        IJstType jstType = null;
        if (sourceModule instanceof VjoSourceModule) {
            jstType = ((IVjoSourceModule)sourceModule).getJstType();
        } else {
            String name = String.valueOf(type.getScriptFolder().getElementName()) + '.' + type.getElementName();
            String groupName = type.getScriptProject().getElementName();
            jstType = TypeSpaceMgr.findType((String)groupName, (String)name);
        }
        if (jstType == null) {
            return false;
        }
        return jstType.hasMixins();
    }

    public static IJstType getJstType(VjoEditor editor) {
        if (editor == null) {
            return null;
        }
        IModelElement modelElement = editor.getInputModelElement();
        if (modelElement instanceof IVjoSourceModule) {
            return ((IVjoSourceModule)modelElement).getJstType();
        }
        return null;
    }

    public static IDocument getDocument(VjoEditor vjoEditor) {
        return vjoEditor.getScriptSourceViewer().getDocument();
    }

    public static int getCommentOffset(JstVars node, IDocument document) {
        int offset = node.getSource().getEndOffSet();
        try {
            char c = document.getChar(offset);
            while (c != ';' && c != '\r' && c != '\n') {
                c = document.getChar(++offset);
            }
            if (c == '\r' || c == '\n') {
                return offset;
            }
            if (c == ';') {
                return offset + 1;
            }
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public static int getCommentOffset(IJstProperty node, IDocument document) {
        int offset = node.getSource().getEndOffSet();
        try {
            char c = document.getChar(offset);
            while (c != ';' && c != '\r' && c != '\n') {
                c = document.getChar(++offset);
            }
            if (c == '\r' || c == '\n') {
                return offset;
            }
            if (c == ';') {
                return offset + 1;
            }
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public static int getCommentOffset(IJstMethod method, IDocument document) {
        int line;
        int offset;
        block6: {
            offset = method.getSource().getStartOffSet();
            line = document.getLineOfOffset(offset);
            if (line != 0) break block6;
            return -1;
        }
        try {
            offset = document.getLineOffset(line - 1);
            char c = document.getChar(offset);
            while (c != '\r' && c != '\n') {
                c = document.getChar(++offset);
            }
            if (c == '\r' || c == '\n') {
                return offset;
            }
            if (c == ';') {
                return offset + 1;
            }
            return -1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public static String getCommentText(JstVars node) {
        IJstType type = node.getType();
        if (type != null) {
            return CodeCompletionUtils.getAliasOrTypeName((IJstType)node.getOwnerType(), (IJstType)type);
        }
        return "";
    }

    public static String getCommentText(IJstMethod method) {
        String s = "";
        if (!method.isConstructor()) {
            s = String.valueOf(CodeassistUtils.calculateRtnType((IJstMethod)method)) + " ";
        }
        return String.valueOf(JsCoreKeywords.EXT_PUBLIC) + " " + s + method.getName() + "()";
    }

    public static String getCommentText(IJstProperty node) {
        IJstType type = node.getType();
        if (type != null) {
            return CodeCompletionUtils.getAliasOrTypeName((IJstType)node.getOwnerType(), (IJstType)type);
        }
        return "";
    }

    public static void performChange(VjoEditor activeEditor, String text, int offset) throws CoreException {
        IDocument document = activeEditor.getScriptSourceViewer().getDocument();
        TextChange change = VjetUIUtils.createTextChange(activeEditor, text, offset);
        if (change == null) {
            return;
        }
        IRewriteTarget rewriteTarget = null;
        try {
            if (change != null) {
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                if (activeEditor != null && (rewriteTarget = (IRewriteTarget)activeEditor.getAdapter(IRewriteTarget.class)) != null) {
                    rewriteTarget.beginCompoundChange();
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                change.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            if (rewriteTarget != null) {
                rewriteTarget.endCompoundChange();
            }
            if (change != null) {
                change.dispose();
            }
        }
    }

    public static TextChange createTextChange(VjoEditor editor, String text, int offset) throws CoreException {
        DocumentChange change = new DocumentChange(text, editor.getViewer().getDocument());
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        InsertEdit edit = new InsertEdit(offset, text);
        rootEdit.addChild((TextEdit)edit);
        return change;
    }

    public static IJstNode getCommentableJstNode(IJstNode node) {
        while (!(node == null || node instanceof IJstMethod || node instanceof IJstProperty || node instanceof JstVars)) {
            node = node.getParentNode();
        }
        return node;
    }

    public static VjoSelectionEngine getSelectionEngine() {
        IDLTKLanguageToolkit toolKit = VjoLanguageToolkit.getDefault();
        ISelectionEngine selectionEngine = DLTKLanguageManager.getSelectionEngine((String)toolKit.getNatureId());
        if (!(selectionEngine instanceof VjoSelectionEngine)) {
            return null;
        }
        VjoSelectionEngine vjoSelectionEngine = (VjoSelectionEngine)selectionEngine;
        return vjoSelectionEngine;
    }
}

