/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.handlers;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathAttribute;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddBootstrapEntryToVJETProject
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection;
        Object firstElem;
        ISelection base = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (base instanceof IStructuredSelection && (firstElem = (selection = (IStructuredSelection)base).getFirstElement()) instanceof ScriptProject) {
            ScriptProject project = (ScriptProject)firstElem;
            IFolder bootstrapFolder = project.getProject().getFolder("bootstrap");
            if (!bootstrapFolder.exists()) {
                try {
                    bootstrapFolder.create(true, true, null);
                    IFile bootstrapjsfile = bootstrapFolder.getFile("bootstrap.js");
                    if (!bootstrapjsfile.exists()) {
                        bootstrapjsfile.create((InputStream)new StringInputStream("var typeExtensions = {} // \"typetoextend\" : \"typewhichdefinesextension\")"), true, null);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (!this.containsBootstrap(project)) {
                ArrayList<IBuildpathEntry> bentries = new ArrayList<IBuildpathEntry>();
                IBuildpathEntry bootstrapEntry = DLTKCore.newBootstrapEntry((IPath)new Path("bootstrap"), null, (IPath[])BuildpathEntry.INCLUDE_ALL, (IPath[])BuildpathEntry.EXCLUDE_NONE, (IBuildpathAttribute[])new IBuildpathAttribute[0], (boolean)false);
                bentries.add(bootstrapEntry);
                try {
                    this.addEntriesToBuildPath((IScriptProject)project, bentries);
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private boolean containsBootstrap(ScriptProject project) {
        IBuildpathEntry[] rawBuildpath = null;
        try {
            rawBuildpath = project.getRawBuildpath();
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            if (buildpathEntry.getEntryKind() == 6) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addEntriesToBuildPath(IScriptProject scriptProject, List<IBuildpathEntry> entries) throws ModelException {
        IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
        HashSet<IBuildpathEntry> newRawBuildpath = new HashSet<IBuildpathEntry>();
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            newRawBuildpath.add(buildpathEntry);
            ++n2;
        }
        for (IBuildpathEntry buildpathEntry : entries) {
            newRawBuildpath.add(buildpathEntry);
        }
        scriptProject.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newRawBuildpath.size()]), null);
    }
}

