/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.javatojs.control.DapJsrGenListener;
import org.eclipse.vjet.dsf.javatojs.control.DefaultTranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.control.IBuildResourceFilter;
import org.eclipse.vjet.dsf.javatojs.control.ICodeGenPathResolver;
import org.eclipse.vjet.dsf.javatojs.control.ITranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.control.TranslationController;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.util.JavaToJsHelper;
import org.eclipse.vjet.dsf.javatojs.util.VjoFiler;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrGenListener;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.logger.LogLevel;

public final class BuildController {
    private TranslationController m_tController;
    private List<JstType> m_jstTypes;
    private List<TranslateError> m_directErrors = new ArrayList<TranslateError>();
    private boolean m_verbose = false;
    private boolean m_genVjo = true;
    private boolean m_genJsr = false;
    private boolean m_useOnDemand = true;
    private boolean m_includeChildPkgs = true;
    private ICodeGenPathResolver m_codeGenPathResolver = ICodeGenPathResolver.DEFAULT;
    private static final TraceId PKG = TranslationTraceId.PKG;
    private static final TraceId FILE = TranslationTraceId.FILE;
    private DapJsrGenListener m_jsrListener = new DapJsrGenListener();

    public BuildController() {
        this(null);
    }

    public BuildController(ITranslationInitializer configInitializer) {
        this.m_tController = configInitializer == null ? new TranslationController((ITranslationInitializer)new DefaultTranslationInitializer()) : new TranslationController(configInitializer);
    }

    public boolean isParallelEnabled() {
        return this.m_tController.isParallelEnabled();
    }

    public BuildController enableParallel(boolean enableParallel) {
        this.m_tController.enableParallel(enableParallel);
        return this;
    }

    public boolean isEnableTrace() {
        return this.m_tController.isTraceEnabled();
    }

    public BuildController enableTrace(boolean enableTrace) {
        this.m_tController.enableTrace(enableTrace);
        return this;
    }

    public TranslationController getTranslateController() {
        return this.m_tController;
    }

    public boolean isGenVjo() {
        return this.m_genVjo;
    }

    public BuildController setGenVjo(boolean genVjo) {
        this.m_genVjo = genVjo;
        return this;
    }

    public boolean isGenJsr() {
        return this.m_genJsr;
    }

    public BuildController setGenJsr(boolean genJsr) {
        this.m_genJsr = genJsr;
        return this;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public boolean shouldUseOnDemand() {
        return this.m_useOnDemand;
    }

    public BuildController setUseOnDemand(boolean onDemand) {
        this.m_useOnDemand = onDemand;
        return this;
    }

    public BuildController setVerbose(boolean verbose) {
        this.m_verbose = verbose;
        return this;
    }

    public boolean shouldIncludeChildPkgs() {
        return this.m_includeChildPkgs;
    }

    public BuildController setIncludeChildPkgs(boolean value) {
        this.m_includeChildPkgs = value;
        return this;
    }

    public void setCodeGenPathResolver(ICodeGenPathResolver resolver) {
        this.m_codeGenPathResolver = resolver;
    }

    public void buildFiles(List<URL> fileList) {
        ITranslateTracer tracer = this.getTracer();
        tracer.startGroup(FILE, new TraceAttr[]{new TraceAttr("name", this.getClass().getSimpleName())});
        try {
            this.translateSource(fileList);
            if (this.shouldGenerateFiles()) {
                try {
                    this.generateFiles();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            tracer.endGroup(PKG);
            this.getCtx().getTraceManager().close();
        }
    }

    public void buildPackage(URL pkgPath) {
        if (pkgPath == null) {
            return;
        }
        ITranslateTracer tracer = this.getTracer();
        tracer.startGroup(PKG, new TraceAttr[]{new TraceAttr("name", pkgPath.toString())});
        try {
            this.out("-> Get java files ...");
            ArrayList<URL> fileList = new ArrayList<URL>();
            try {
                this.getFiles(pkgPath, fileList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (fileList.size() == 0) {
                this.out("<- No java files for Java2Js translation found");
                return;
            }
            this.translateSource(fileList);
            if (this.shouldGenerateFiles()) {
                try {
                    this.generateFiles();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            tracer.endGroup(PKG);
            this.getCtx().getTraceManager().close();
        }
    }

    public List<TranslateError> getDirectErrors() {
        return Collections.unmodifiableList(this.m_directErrors);
    }

    public void clearDirectErrors() {
        this.m_directErrors.clear();
    }

    public List<TranslateError> getTranslateLog(LogLevel logLevel) {
        ArrayList<TranslateError> errors = new ArrayList<TranslateError>();
        for (TranslateError e : this.getAllErrors()) {
            if (e.getLevel() != logLevel) continue;
            errors.add(e);
        }
        return errors;
    }

    public List<TranslateError> getAllErrors() {
        ArrayList<TranslateError> errors = new ArrayList<TranslateError>(this.m_directErrors);
        if (this.m_tController != null) {
            errors.addAll(this.m_tController.getErrors());
        }
        return errors;
    }

    public Map<JstType, List<Throwable>> getAllExceptions() {
        if (this.m_tController == null) {
            return Collections.emptyMap();
        }
        return this.m_tController.getExceptions();
    }

    public List<JstType> getTranslatedJstTypes() {
        if (this.m_jstTypes == null) {
            return Collections.emptyList();
        }
        return this.m_jstTypes;
    }

    public void reset() {
        this.m_tController.reset();
    }

    private TranslateCtx getCtx() {
        return this.m_tController.getCtx();
    }

    private void translateSource(List<URL> fileList) {
        if (fileList == null || fileList.size() == 0) {
            return;
        }
        this.out("-> Read java sources ...");
        LinkedHashMap<URI, String> files = new LinkedHashMap<URI, String>();
        for (URL url : fileList) {
            try {
                if (!this.getCtx().getConfig().getFileFilter().accept(url)) {
                    this.out("Skipped code generation for codegen'd file " + url.toString());
                    continue;
                }
                this.out(url.toString());
                String src = JavaToJsHelper.readFromInputReader((InputStreamReader)new InputStreamReader(url.openStream()));
                files.put(url.toURI(), src);
            }
            catch (IOException iOException) {
                this.m_directErrors.add(new TranslateError("SrcNotFound", "IO Error while reading source : " + url.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                this.m_directErrors.add(new TranslateError("SrcNotFound", "URISyntaxException, Error while reading source : " + url.toString()));
            }
        }
        this.out("-> Translate java sources to JST ...");
        List jstTypes = null;
        jstTypes = this.m_useOnDemand ? this.m_tController.onDemandTranslation(files) : this.m_tController.targetedTranslation(files);
        this.m_jstTypes = new ArrayList<JstType>(jstTypes.size());
        TranslateCtx ctx = this.getCtx();
        for (JstType jstType : jstTypes) {
            if (ctx.isJavaOnly((IJstType)jstType) || ctx.isMappedToJS((IJstType)jstType) || ctx.isExcluded((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType)) continue;
            this.m_jstTypes.add(jstType);
        }
    }

    private void generateFiles() throws MalformedURLException {
        for (JstType jstType : this.m_jstTypes) {
            URL filePath;
            GeneratorCtx gCtx = new GeneratorCtx(CodeStyle.PRETTY);
            if (this.m_genVjo) {
                this.out("-> Generate VJO  for: " + jstType.getName() + "...");
                VjoGenerator vjoGenerator = gCtx.getProvider().getTypeGenerator();
                vjoGenerator.writeVjo((IJstType)jstType);
                filePath = this.m_codeGenPathResolver.getVjoFilePath(jstType);
                VjoFiler.writeToFile((URL)filePath, (String)vjoGenerator.getGeneratedText());
                this.out("Write " + filePath);
            }
            if (!this.m_genJsr) continue;
            this.out("-> Generate JSR for: " + jstType.getName() + "...");
            StringWriter buffer = new StringWriter();
            JsrGenerator jsrGenerator = new JsrGenerator(new PrintWriter(buffer), gCtx.getStyle());
            jsrGenerator.addListener((IJsrGenListener)this.m_jsrListener);
            jsrGenerator.writeJsr((IJstType)jstType, true);
            filePath = this.m_codeGenPathResolver.getJsrFilePath(jstType);
            VjoFiler.writeToFile((URL)filePath, (String)buffer.toString());
            this.out("Write " + filePath);
        }
    }

    private boolean shouldGenerateFiles() {
        return this.m_genVjo || this.m_genJsr;
    }

    private void getFiles(URL dir, List<URL> list) throws IOException, URISyntaxException {
        if (dir == null) {
            return;
        }
        if (!this.shouldIncludeChildPkgs()) {
            JavaToJsHelper.getDirectFiles((URL)dir, list, (IBuildResourceFilter)this.getCtx().getConfig().getFileFilter());
        } else {
            JavaToJsHelper.getFiles((URL)dir, list, (IBuildResourceFilter)this.getCtx().getConfig().getFileFilter(), (boolean)true);
        }
    }

    private ITranslateTracer getTracer() {
        return this.getCtx().getTraceManager().getTracer();
    }

    private void out(String s) {
        if (this.m_verbose) {
            System.out.println(s);
        }
    }
}

