/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.custom.dom.ADomMeta;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.MetaDrivenCustomTranslator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoConstants;
import org.eclipse.vjet.dsf.jsnative.anno.Alias;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserSupport;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.anno.Constructor;
import org.eclipse.vjet.dsf.jsnative.anno.DOMSupport;
import org.eclipse.vjet.dsf.jsnative.anno.DomLevel;
import org.eclipse.vjet.dsf.jsnative.anno.Dynamic;
import org.eclipse.vjet.dsf.jsnative.anno.FactoryFunc;
import org.eclipse.vjet.dsf.jsnative.anno.Function;
import org.eclipse.vjet.dsf.jsnative.anno.GlobalProperty;
import org.eclipse.vjet.dsf.jsnative.anno.IType;
import org.eclipse.vjet.dsf.jsnative.anno.JsArray;
import org.eclipse.vjet.dsf.jsnative.anno.JsMetatype;
import org.eclipse.vjet.dsf.jsnative.anno.JsSupport;
import org.eclipse.vjet.dsf.jsnative.anno.JsVariantArray;
import org.eclipse.vjet.dsf.jsnative.anno.JsVersion;
import org.eclipse.vjet.dsf.jsnative.anno.JstExclude;
import org.eclipse.vjet.dsf.jsnative.anno.JstMultiReturn;
import org.eclipse.vjet.dsf.jsnative.anno.MType;
import org.eclipse.vjet.dsf.jsnative.anno.OverLoadFunc;
import org.eclipse.vjet.dsf.jsnative.anno.OverrideFunc;
import org.eclipse.vjet.dsf.jsnative.anno.OverrideProp;
import org.eclipse.vjet.dsf.jsnative.anno.Property;
import org.eclipse.vjet.dsf.jsnative.anno.Static;
import org.eclipse.vjet.dsf.jsnative.global.Global;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalProp;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalVar;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class JsNativeCustomTranslator
extends MetaDrivenCustomTranslator {
    public JsNativeCustomTranslator() {
        super((ICustomMetaProvider)new ADomMeta());
    }

    public boolean processTypeBody(List bodyDeclaration, JstType jstType) {
        CustomType toType = this.getMetaProvider().getCustomType(jstType.getName());
        if (toType == null) {
            return false;
        }
        jstType.setAlias(jstType.getName());
        jstType.setSimpleName(this.getTypeName(toType));
        jstType.setMetaType(this.isTypeMetaType(toType));
        jstType.getModifiers().setDynamic(this.isTypeDynamic(toType));
        jstType.setPackage(null);
        jstType.clearMethods();
        jstType.clearProperties();
        for (java.lang.Object d : bodyDeclaration) {
            if (!(d instanceof MethodDeclaration)) continue;
            MethodDeclaration astMtd = (MethodDeclaration)d;
            this.processMethod(astMtd, jstType, toType);
        }
        this.addExtendsGlobal(jstType);
        this.addExtendsObject(jstType);
        this.fixOverLoaded(jstType);
        this.fixImports(jstType);
        this.fixCategory(jstType);
        return true;
    }

    private void fixCategory(JstType jstType) {
        jstType.setImpliedImport(true);
        if (jstType.getAnnotation(MType.class.getSimpleName()) != null) {
            jstType.setCategory(JstType.Category.MODULE);
            jstType.removeExtend(jstType.getExtend());
            if (!jstType.getSatisfies().isEmpty()) {
                jstType.removeSatisfy((IJstType)jstType.getSatisfies().get(0));
            }
        } else if (jstType.getAnnotation(IType.class.getSimpleName()) != null) {
            if (jstType.getExtend() != null || jstType.getExtend().getSimpleName().equals("Object")) {
                jstType.removeExtend(jstType.getExtend());
            }
        } else if (jstType.getAnnotation(IType.class.getSimpleName()) == null) {
            jstType.setCategory(JstType.Category.CLASS);
            jstType.getModifiers().setAbstract();
        }
    }

    private void fixOverLoaded(JstType jstType) {
        JstMethod constructor = jstType.getConstructor();
        if (constructor != null && constructor.isDispatcher()) {
            JstArg[] args = new JstArg[constructor.getArgs().size()];
            int i = 0;
            for (JstArg arg : constructor.getArgs()) {
                args[i] = new JstArg(arg.getType(), arg.getName(), arg.isVariable(), arg.isOptional(), arg.isFinal());
                ++i;
            }
            JstConstructor ovldConst = new JstConstructor(constructor.getModifiers(), args);
            constructor.addOverloaded((JstMethod)ovldConst);
            ovldConst.setParent((IJstNode)constructor, false);
        }
        for (IJstMethod method : jstType.getMethods()) {
            if (!method.isDispatcher() || !(method instanceof JstMethod)) continue;
            JstArg[] args = new JstArg[method.getArgs().size()];
            int i = 0;
            for (JstArg arg : method.getArgs()) {
                args[i] = new JstArg(arg.getType(), arg.getName(), arg.isVariable(), arg.isOptional(), arg.isFinal());
                ++i;
            }
            JstMethod mtd = new JstMethod(method.getName(), method.getModifiers(), method.getRtnType(), args);
            ((JstMethod)method).addOverloaded(mtd);
            mtd.setParent((IJstNode)method, false);
        }
    }

    private void addExtendsGlobal(JstType jstType) {
        JstType globalType;
        if ("Window".equals(jstType.getName()) && (globalType = JstCache.getInstance().getType(Global.class.getName())) != null) {
            JstTypeReference jstTypeReference = new JstTypeReference((IJstType)globalType);
            jstType.addExtend((IJstTypeReference)jstTypeReference);
            jstType.addImport((IJstTypeReference)jstTypeReference);
        }
    }

    private void addExtendsObject(JstType jstType) {
        if (jstType.isMixin()) {
            return;
        }
        if ("Object".equals(jstType.getName())) {
            return;
        }
        if ("vjo.Object".equals(jstType.getName())) {
            return;
        }
        IJstType extend = jstType.getExtend();
        if (extend != null && "java.lang.RuntimeException".equals(extend.getName())) {
            jstType.removeExtend(extend);
            extend = null;
        }
        if (extend != null) {
            return;
        }
        JstType objectType = JstCache.getInstance().getType(Object.class.getName());
        if (objectType != null) {
            JstTypeReference jstTypeReference = new JstTypeReference((IJstType)objectType);
            jstType.addExtend((IJstTypeReference)jstTypeReference);
            jstType.addImport((IJstTypeReference)jstTypeReference);
        }
    }

    public JstIdentifier processIdentifier(Name astName, boolean hasSuper, boolean hasThis, IExpr qualifierExpr, JstIdentifier identifier, BaseJstNode jstNode) {
        if (astName.isSimpleName()) {
            return null;
        }
        QualifiedName qualifiedName = (QualifiedName)astName;
        Name qualifier = qualifiedName.getQualifier();
        if (this.isSupportedByAnnotation(qualifier.getFullyQualifiedName())) {
            JstIdentifier jstQualifier = new JstIdentifier(qualifier.toString());
            SimpleName name = qualifiedName.getName();
            JstIdentifier jstIdentifier = new JstIdentifier(name.toString());
            if (jstQualifier != null) {
                jstIdentifier.setQualifier(jstQualifier);
                jstIdentifier.setType(jstQualifier.getType());
            }
            return jstIdentifier;
        }
        return super.processIdentifier((Name)qualifiedName, hasSuper, hasThis, qualifierExpr, identifier, jstNode);
    }

    private boolean isSupportedByAnnotation(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return false;
        }
        return fullyQualifiedName.equals(BrowserType.class.getName()) || fullyQualifiedName.equals(BrowserType.class.getSimpleName()) || fullyQualifiedName.equals(JsVersion.class.getName()) || fullyQualifiedName.equals(JsVersion.class.getSimpleName()) || fullyQualifiedName.equals(DomLevel.class.getName()) || fullyQualifiedName.equals(DomLevel.class.getSimpleName());
    }

    private void fixImports(JstType jstType) {
        List imports = jstType.getImports();
        for (IJstType t : imports) {
            ((JstType)t).setPackage(null);
        }
        jstType.clearImports();
        for (IJstType t : imports) {
            jstType.addImport((IJstTypeReference)new JstTypeReference(t));
        }
    }

    private boolean isTypeDynamic(CustomType cType) {
        Class c = cType.getJavaType();
        Dynamic dynamic = c.getAnnotation(Dynamic.class);
        return dynamic != null;
    }

    private boolean isTypeMetaType(CustomType cType) {
        Class c = cType.getJavaType();
        JsMetatype metatype = c.getAnnotation(JsMetatype.class);
        return metatype != null;
    }

    private String getTypeName(CustomType cType) {
        Class c = cType.getJavaType();
        Alias alias = c.getAnnotation(Alias.class);
        if (alias != null) {
            return alias.value();
        }
        return TranslateHelper.getShortName((String)cType.getJstName());
    }

    private void processMethod(MethodDeclaration astMtd, JstType jstType, CustomType toType) {
        List extModifiers = astMtd.modifiers();
        for (IExtendedModifier em : extModifiers) {
            if (!em.isAnnotation()) continue;
            Annotation ma = (Annotation)em;
            if (GlobalProperty.class.getName().equals(ma.getTypeName().toString()) || GlobalProperty.class.getSimpleName().equals(ma.getTypeName().toString())) {
                this.processGlobalProperty(astMtd, jstType, toType);
                continue;
            }
            if (Property.class.getName().equals(ma.getTypeName().toString()) || Property.class.getSimpleName().equals(ma.getTypeName().toString()) || OverrideProp.class.getName().equals(ma.getTypeName().toString()) || OverrideProp.class.getSimpleName().equals(ma.getTypeName().toString())) {
                this.processProperty(astMtd, jstType, toType);
                continue;
            }
            if (Function.class.getName().equals(ma.getTypeName().toString()) || Function.class.getSimpleName().equals(ma.getTypeName().toString()) || OverrideFunc.class.getName().equals(ma.getTypeName().toString()) || OverrideFunc.class.getSimpleName().equals(ma.getTypeName().toString())) {
                this.processFunction(astMtd, jstType, toType);
                continue;
            }
            if (Constructor.class.getName().equals(ma.getTypeName().toString()) || Constructor.class.getSimpleName().equals(ma.getTypeName().toString())) {
                this.processConstructor(astMtd, jstType, toType);
                continue;
            }
            if (!OverLoadFunc.class.getName().equals(ma.getTypeName().toString()) && !OverLoadFunc.class.getSimpleName().equals(ma.getTypeName().toString())) continue;
            this.processOverLoadFunc(astMtd, jstType, toType);
        }
    }

    private void processGlobalProperty(MethodDeclaration astMtd, JstType jstType, CustomType toType) {
        String mtdName = astMtd.getName().toString();
        if (!mtdName.startsWith("get") || !astMtd.parameters().isEmpty()) {
            return;
        }
        CustomMethod mtd = this.getCustomMethod(toType, astMtd);
        if (mtd == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' not found in custom type " + toType.getJstName(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        Type rtnType = astMtd.getReturnType2();
        if (rtnType == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' is annotated as Property but has no return type", (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        IJstType propType = this.getDataTypeTranslator().processType(rtnType, (BaseJstNode)jstType);
        IJstType arryType = this.setUpArray(propType, astMtd);
        if (arryType != null) {
            ArrayList<IJstType> types = new ArrayList<IJstType>();
            types.add(arryType);
            types.add(propType);
            propType = new JstMixedType(types);
        }
        if (propType == null) {
            this.getLogger().logError("NullResult", "failed translation for property type " + rtnType.toString(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        boolean isStatic = this.isStatic(astMtd);
        JstProperty pty = new JstProperty(propType, this.normalizeName(mtd, astMtd), new JstModifiers().setPublic().setStatic(isStatic));
        JstGlobalProp prop = new JstGlobalProp((IJstProperty)pty);
        JstGlobalVar var = new JstGlobalVar((IJstGlobalProp)prop);
        jstType.addGlobalVar((IJstGlobalVar)var);
        this.processFieldJavadoc(astMtd, pty);
        for (java.lang.Object m : astMtd.modifiers()) {
            if (!(m instanceof Annotation)) continue;
            this.processAnnotation((BaseJstNode)pty, m);
        }
    }

    private void processConstructor(MethodDeclaration astMtd, JstType jstType, CustomType toType) {
        CustomMethod mtd = this.getCustomMethod(toType, astMtd);
        if (mtd == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' not supported base on meta info for type " + jstType.getName(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        List params = astMtd.parameters();
        JstArg[] argsArray = new JstArg[params.size()];
        int indx = 0;
        for (SingleVariableDeclaration sv : params) {
            String name = this.getNameTranslator().processVarName(sv.getName().toString());
            IJstType type = this.getDataTypeTranslator().processType(sv.getType(), (BaseJstNode)jstType);
            argsArray[indx] = new JstArg(type, name, sv.isVarargs());
            ++indx;
        }
        JstConstructor constr = new JstConstructor(new JstModifiers().setPublic(), argsArray);
        JstMethod currConstructor = jstType.getConstructor();
        if (currConstructor != null) {
            currConstructor.addOverloaded((JstMethod)constr);
            constr.setParent((IJstNode)currConstructor, false);
        } else {
            jstType.setConstructor((JstMethod)constr);
        }
        for (java.lang.Object m : astMtd.modifiers()) {
            if (!(m instanceof Annotation)) continue;
            this.processAnnotation((BaseJstNode)constr, m);
        }
    }

    private void processFunction(MethodDeclaration astMtd, JstType jstType, CustomType toType) {
        JstModifiers modifiers;
        CustomMethod mtd = this.getCustomMethod(toType, astMtd);
        if (mtd == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' not supported base on meta info for type " + jstType.getName(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        String mtdName = this.normalizeName(mtd, astMtd);
        if (jstType.getMethod(mtdName, (modifiers = new JstModifiers().setPublic().setStatic(this.isStatic(astMtd))).isStatic()) != null) {
            String msg = "Method '" + astMtd.getName().toString() + "' already exists in type " + jstType.getName();
            this.getLogger().logError("FailedToParse", "Method '" + astMtd.getName().toString() + "' already exists in type " + jstType.getName(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            throw new RuntimeException(msg);
        }
        JstMethod jstMtd = new JstMethod(mtdName, modifiers, new JstArg[0]);
        List params = astMtd.parameters();
        for (SingleVariableDeclaration sv : params) {
            String name = this.getNameTranslator().processVarName(sv.getName(), (BaseJstNode)jstMtd.getBlock(true));
            IJstType type = this.getDataTypeTranslator().processType(sv.getType(), (BaseJstNode)jstType);
            jstType.setPackage(null);
            jstMtd.getBlock(true).getVarTable().addVarType(name, type);
            jstMtd.addArg(new JstArg(type, name, sv.isVarargs()));
        }
        Type rtnType = astMtd.getReturnType2();
        if (rtnType != null) {
            IJstType type = this.getDataTypeTranslator().processType(rtnType, (BaseJstNode)jstType);
            jstType.setPackage(null);
            jstMtd.setRtnType(type);
        }
        List extModifiers = astMtd.modifiers();
        for (IExtendedModifier em : extModifiers) {
            if (!em.isAnnotation()) continue;
            Annotation ma = (Annotation)em;
            if (FactoryFunc.class.getSimpleName().equals(ma.getTypeName().toString())) {
                jstMtd.setTypeFactoryEnabled(true);
            }
            if (!JstMultiReturn.class.getSimpleName().equals(ma.getTypeName().toString()) || !(ma instanceof SingleMemberAnnotation)) continue;
            SingleMemberAnnotation sma = (SingleMemberAnnotation)em;
            List<IJstType> types = this.getTypesFromAryInAnno(sma);
            types.add(jstMtd.getRtnType());
            JstMixedType mixed = new JstMixedType(types);
            jstMtd.setRtnType((IJstType)mixed);
        }
        this.processMethodJavadoc(astMtd, jstMtd);
        jstType.addMethod((IJstMethod)jstMtd);
        for (java.lang.Object m : astMtd.modifiers()) {
            if (!(m instanceof Annotation)) continue;
            this.processAnnotation((BaseJstNode)jstMtd, m);
        }
        if (!this.isSupported(jstMtd)) {
            jstType.removeMethod(jstMtd.getName().getName(), jstMtd.isStatic());
        }
    }

    private List<IJstType> getTypesFromAryInAnno(SingleMemberAnnotation sma) {
        ArrayList<IJstType> types = new ArrayList<IJstType>();
        if (sma.getValue() instanceof ArrayInitializer) {
            System.out.println("test");
            ArrayInitializer ai = (ArrayInitializer)sma.getValue();
            for (java.lang.Object oj : ai.expressions()) {
                if (!(oj instanceof TypeLiteral)) continue;
                TypeLiteral tl = (TypeLiteral)oj;
                String fullName = tl.getType().toString();
                JstType type = JstCache.getInstance().getType("org.eclipse.vjet.dsf.jsnative." + fullName);
                if (type == null) {
                    type = JstCache.getInstance().getType("org.eclipse.vjet.dsf.jsnative.global." + fullName);
                }
                if (type == null) {
                    type = JsNativeCustomTranslator.toJsNativeType(fullName);
                }
                if (type == null) continue;
                types.add((IJstType)type);
            }
        }
        return types;
    }

    protected static IJstType toJsNativeType(String type) {
        IJstType[] iJstTypeArray = VjoConstants.NativeTypes.getJstNativeTypes();
        int n = iJstTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJstType jsNativeType = iJstTypeArray[n2];
            if (JsNativeCustomTranslator.equals(jsNativeType, type)) {
                return jsNativeType;
            }
            ++n2;
        }
        return null;
    }

    public static boolean equals(IJstType one, String two) {
        if (one == null || two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        String name1 = one.getName();
        String name2 = two;
        if (name1 != null) {
            if (name1.equals(name2)) {
                return true;
            }
            return !(!"Object".equals(name1) && !"(obj literal)".equals(name1) || !"Object".equals(name2) && !"(obj literal)".equals(name2));
        }
        return false;
    }

    private boolean isSupported(JstMethod jstMtd) {
        IJstAnnotation anno = jstMtd.getAnnotation("JstExclude");
        return anno == null;
    }

    private void processAnnotation(BaseJstNode jstMtd, java.lang.Object m) {
        if (DOMSupport.class.getSimpleName().equals(((Annotation)m).getTypeName().toString())) {
            this.getOtherTranslator().processAnnotation((Annotation)m, jstMtd);
        } else if (BrowserSupport.class.getSimpleName().equals(((Annotation)m).getTypeName().toString())) {
            this.getOtherTranslator().processAnnotation((Annotation)m, jstMtd);
        } else if (JsSupport.class.getSimpleName().equals(((Annotation)m).getTypeName().toString())) {
            this.getOtherTranslator().processAnnotation((Annotation)m, jstMtd);
        } else if (JstExclude.class.getSimpleName().equals(((Annotation)m).getTypeName().toString())) {
            this.getOtherTranslator().processAnnotation((Annotation)m, jstMtd);
        }
    }

    private void processOverLoadFunc(MethodDeclaration astMtd, JstType jstType, CustomType toType) {
        JstMethod currMtd;
        CustomMethod mtd = this.getCustomMethod(toType, astMtd);
        if (mtd == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' not supported base on meta info for type " + jstType.getName(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        JstMethod jstMtd = new JstMethod(this.normalizeName(mtd, astMtd), new JstModifiers().setPublic().setStatic(this.isStatic(astMtd)), new JstArg[0]);
        List params = astMtd.parameters();
        for (SingleVariableDeclaration sv : params) {
            String name = this.getNameTranslator().processVarName(sv.getName(), (BaseJstNode)jstMtd.getBlock(true));
            IJstType type = this.getDataTypeTranslator().processType(sv.getType(), (BaseJstNode)jstType);
            jstType.setPackage(null);
            jstMtd.getBlock(true).getVarTable().addVarType(name, type);
            jstMtd.addArg(new JstArg(type, name, sv.isVarargs()));
        }
        Type rtnType = astMtd.getReturnType2();
        if (rtnType != null) {
            IJstType type = this.getDataTypeTranslator().processType(rtnType, (BaseJstNode)jstType);
            jstType.setPackage(null);
            jstMtd.setRtnType(type);
        }
        if ((currMtd = (JstMethod)jstType.getMethod(jstMtd.getName().getName(), jstMtd.isStatic())) != null) {
            this.processMethodJavadoc(astMtd, currMtd);
            currMtd.addOverloaded(jstMtd);
            jstMtd.setParent((IJstNode)currMtd, false);
        } else {
            jstType.addMethod((IJstMethod)jstMtd);
        }
        for (java.lang.Object m : astMtd.modifiers()) {
            if (!(m instanceof Annotation)) continue;
            this.processAnnotation((BaseJstNode)jstMtd, m);
            if (!(m instanceof SingleMemberAnnotation)) continue;
            SingleMemberAnnotation sma = (SingleMemberAnnotation)m;
            if (!JstMultiReturn.class.getSimpleName().equals(sma.getTypeName().toString())) continue;
            List<IJstType> types = this.getTypesFromAryInAnno(sma);
            types.add(jstMtd.getRtnType());
            JstMixedType mixed = new JstMixedType(types);
            jstMtd.setRtnType((IJstType)mixed);
        }
    }

    private String normalizeName(CustomMethod mtd, MethodDeclaration astMtd) {
        if ("_void".equals(mtd.getJstOrigName())) {
            return "void";
        }
        Annotation alias = this.getAliasAnnotation(astMtd);
        if (alias != null && alias instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation smAnn = (SingleMemberAnnotation)alias;
            String value = smAnn.getValue().toString();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        return mtd.getJstOrigName();
    }

    private Annotation getAliasAnnotation(MethodDeclaration astMtd) {
        List extModifiers = astMtd.modifiers();
        for (IExtendedModifier em : extModifiers) {
            if (!em.isAnnotation()) continue;
            Annotation ma = (Annotation)em;
            if (!Alias.class.getName().equals(ma.getTypeName().toString()) && !Alias.class.getSimpleName().equals(ma.getTypeName().toString())) continue;
            return ma;
        }
        return null;
    }

    private void processProperty(MethodDeclaration astMtd, JstType jstType, CustomType toType) {
        String mtdName = astMtd.getName().toString();
        if (!mtdName.startsWith("get") || !astMtd.parameters().isEmpty()) {
            return;
        }
        CustomMethod mtd = this.getCustomMethod(toType, astMtd);
        if (mtd == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' not found in custom type " + toType.getJstName(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        Type rtnType = astMtd.getReturnType2();
        if (rtnType == null) {
            this.getLogger().logError("ExcludedMethod", "Method '" + astMtd.getName().toString() + "' is annotated as Property but has no return type", (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        IJstType propType = this.getDataTypeTranslator().processType(rtnType, (BaseJstNode)jstType);
        IJstType arrayType = this.setUpArray(propType, astMtd);
        if (arrayType != null) {
            ArrayList<IJstType> types = new ArrayList<IJstType>();
            types.add(arrayType);
            types.add(propType);
            propType = new JstMixedType(types);
        }
        if (propType == null) {
            this.getLogger().logError("NullResult", "failed translation for property type " + rtnType.toString(), (BaseTranslator)this, (ASTNode)astMtd, (BaseJstNode)jstType);
            return;
        }
        boolean isStatic = this.isStatic(astMtd);
        JstProperty pty = new JstProperty(propType, this.normalizeName(mtd, astMtd), new JstModifiers().setPublic().setStatic(isStatic));
        jstType.addProperty((IJstProperty)pty);
        this.processFieldJavadoc(astMtd, pty);
        for (java.lang.Object m : astMtd.modifiers()) {
            if (!(m instanceof Annotation)) continue;
            this.processAnnotation((BaseJstNode)pty, m);
        }
    }

    private IJstType setUpArray(IJstType propType, MethodDeclaration astMtd) {
        IJstType type = this.getArrayType(astMtd, propType);
        if (type != null) {
            return new JstArray(type);
        }
        return null;
    }

    private void processMethodJavadoc(MethodDeclaration astMtd, JstMethod jstMtd) {
        Javadoc javadoc = astMtd.getJavadoc();
        if (javadoc == null) {
            return;
        }
        JstDoc jstDoc = new JstDoc(this.cleanUpDoc(javadoc.toString()));
        jstMtd.setDoc((IJstDoc)jstDoc);
    }

    private void processFieldJavadoc(MethodDeclaration astMtd, JstProperty pty) {
        Javadoc javadoc = astMtd.getJavadoc();
        if (javadoc == null) {
            return;
        }
        String jsdoc = this.cleanUpDoc(javadoc.toString());
        JstDoc jstDoc = new JstDoc(jsdoc);
        pty.setDoc((IJstDoc)jstDoc);
    }

    private String cleanUpDoc(String jsdoc) {
        jsdoc = jsdoc.trim();
        jsdoc = jsdoc.replaceAll("^/\\*\\*", "");
        jsdoc = jsdoc.replaceAll("^\\*", "");
        jsdoc = jsdoc.replaceAll("\\*/$", "");
        jsdoc = jsdoc.replaceAll("\\s+\\*", "\n");
        return jsdoc;
    }

    private boolean isStatic(MethodDeclaration astMtd) {
        List extModifiers = astMtd.modifiers();
        for (IExtendedModifier em : extModifiers) {
            if (!em.isAnnotation() || !(em instanceof MarkerAnnotation)) continue;
            MarkerAnnotation ma = (MarkerAnnotation)em;
            if (!Static.class.getName().equals(ma.getTypeName().toString()) && !Static.class.getSimpleName().equals(ma.getTypeName().toString())) continue;
            return true;
        }
        return false;
    }

    private IJstType getArrayType(MethodDeclaration astMtd, IJstType propType) {
        List extModifiers = astMtd.modifiers();
        for (IExtendedModifier em : extModifiers) {
            if (!em.isAnnotation() || !(em instanceof SingleMemberAnnotation)) continue;
            SingleMemberAnnotation sma = (SingleMemberAnnotation)em;
            if (JsVariantArray.class.getSimpleName().equals(sma.getTypeName().toString())) {
                List<IJstType> types = this.getTypesFromAryInAnno(sma);
                return new JstMixedType(types);
            }
            if (!JsArray.class.getSimpleName().equals(sma.getTypeName().toString())) continue;
            JstAnnotation annotation = new JstAnnotation();
            annotation.setParent((IJstNode)propType);
            if (sma.getValue() instanceof TypeLiteral) {
                TypeLiteral tl = (TypeLiteral)sma.getValue();
                String fullName = tl.getType().toString();
                JstType type = JstCache.getInstance().getType("org.eclipse.vjet.dsf.jsnative." + fullName);
                return type;
            }
            return null;
        }
        return null;
    }
}

