/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json.serializer;

import org.eclipse.vjet.dsf.json.serializer.AbstractSerializer;
import org.eclipse.vjet.dsf.json.serializer.ObjectMatch;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SerializerState;

public class BooleanSerializer
extends AbstractSerializer {
    private static Class[] s_serializableClasses = new Class[]{Boolean.TYPE, Boolean.class};
    private static Class[] s_JSONClasses = new Class[]{Boolean.class, String.class};

    public Class[] getSerializableClasses() {
        return s_serializableClasses;
    }

    public Class[] getJSONClasses() {
        return s_JSONClasses;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws SerializationException {
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws SerializationException {
        Object result = jso;
        if (jso instanceof String) {
            try {
                result = Boolean.valueOf((String)jso);
            }
            catch (Exception exception) {
                throw new SerializationException("Cannot convert " + jso + " to Boolean");
            }
        }
        if (clazz == Boolean.TYPE) {
            result = (Boolean)jso;
        }
        return result;
    }

    @Override
    public Object marshall(SerializerState state, Object o) throws SerializationException {
        return o;
    }
}

