/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.vjet.dsf.liveconnect.DLCFutureResultMgr;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpRequest;
import org.eclipse.vjet.dsf.liveconnect.DLCHttpResponse;
import org.eclipse.vjet.dsf.liveconnect.IDLCReceiver;

class DLCReceiverInvocator
implements IDLCReceiver {
    private final IDLCReceiver m_receiver;
    private int m_channelIndex = 0;
    private WeakHashMap<SocketChannel, ChannelBasedInvocator> m_invocators = new WeakHashMap();
    private final DLCFutureResultMgr m_dlcRequestMgr;

    DLCReceiverInvocator(IDLCReceiver receiver, DLCFutureResultMgr mgr) {
        this.m_receiver = receiver;
        this.m_dlcRequestMgr = mgr;
    }

    @Override
    public void connected(SocketChannel channel) {
        this.getInvocator(channel).connected(channel);
    }

    @Override
    public void received(SocketChannel channel, String message) {
        this.getInvocator(channel).received(channel, message);
    }

    @Override
    public void closed(SocketChannel channel) {
        this.getInvocator(channel).closed(channel);
    }

    @Override
    public DLCHttpResponse get(SocketChannel channel, DLCHttpRequest request) {
        return this.getInvocator(channel).get(channel, request);
    }

    private synchronized ChannelBasedInvocator getInvocator(SocketChannel channel) {
        ChannelBasedInvocator invocator = this.m_invocators.get(channel);
        if (invocator == null) {
            invocator = new ChannelBasedInvocator(this.m_channelIndex++);
            this.m_invocators.put(channel, invocator);
        }
        return invocator;
    }

    class ChannelBasedInvocator
    implements Runnable,
    IDLCReceiver {
        private List<Runnable> m_fifo = new LinkedList<Runnable>();

        ChannelBasedInvocator(int channelIndex) {
            Thread t = new Thread((Runnable)this, "DLCReceiverInvocator_" + DLCReceiverInvocator.this.m_channelIndex);
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (!this.m_fifo.isEmpty()) {
                    DLCReceiverInvocator.this.m_dlcRequestMgr.waitForAllDone();
                    this.m_fifo.remove(0).run();
                    continue;
                }
                List<Runnable> list = this.m_fifo;
                synchronized (list) {
                    if (this.m_fifo.isEmpty()) {
                        try {
                            this.m_fifo.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        @Override
        public void connected(final SocketChannel channel) {
            Runnable cmd = new Runnable(){

                @Override
                public void run() {
                    DLCReceiverInvocator.this.m_receiver.connected(channel);
                }
            };
            this.addCmd(cmd);
        }

        @Override
        public void received(final SocketChannel channel, final String message) {
            Runnable cmd = new Runnable(){

                @Override
                public void run() {
                    DLCReceiverInvocator.this.m_receiver.received(channel, message);
                }
            };
            this.addCmd(cmd);
        }

        @Override
        public void closed(final SocketChannel channel) {
            Runnable cmd = new Runnable(){

                @Override
                public void run() {
                    DLCReceiverInvocator.this.m_receiver.closed(channel);
                    DLCReceiverInvocator.this.m_invocators.remove(channel);
                }
            };
            this.addCmd(cmd);
        }

        @Override
        public DLCHttpResponse get(SocketChannel channel, DLCHttpRequest request) {
            return DLCReceiverInvocator.this.m_receiver.get(channel, request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCmd(Runnable cmd) {
            this.m_fifo.add(cmd);
            List<Runnable> list = this.m_fifo;
            synchronized (list) {
                this.m_fifo.notifyAll();
            }
        }
    }
}

